/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.logging.Log;

public class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void logRequest(Log logger, Request request, Boolean logRequest) {
        if (logger != null && CommonUtils.isTrue(logRequest)) {
            logger.debug((CharSequence)("REQUEST_URL: " + request.url().toString()));
            logger.debug((CharSequence)("REQUEST_METHOD: " + request.method()));
            Request copy = request.newBuilder().build();
            RequestBody body = copy.body();
            if (body != null) {
                logger.debug((CharSequence)("REQUEST_CONTENT_TYPE: " + body.contentType().toString()));
            }
        }
    }

    public static void logResponse(Log logger, Response response, boolean logResponse) {
        if (logger != null) {
            logger.debug((CharSequence)("RESPONSE_CONTENT_TYPE:" + response.header("Content-Type")));
            logger.debug((CharSequence)("RESPONSE_HTTP_STATUS: " + response.code()));
            if (logResponse) {
                logger.debug((CharSequence)"RESPONSE_BODY:");
                logger.debug((CharSequence)"=======================");
                try (ResponseBody responseBody = response.peekBody(0x100000L);){
                    logger.debug((CharSequence)responseBody.string());
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static OkHttpClient createHttpClient(Boolean useInternalTestProxy, Boolean ignoreSslErrors, Integer timeout) throws IOException {
        OkHttpClient client;
        OkHttpClient.Builder newBuilder = new OkHttpClient.Builder();
        if (CommonUtils.isTrue(ignoreSslErrors) || CommonUtils.isTrue(useInternalTestProxy)) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                newBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]);
                newBuilder.hostnameVerifier((host, session) -> true);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("problem setting up SSL http client configuration");
            }
        }
        if (CommonUtils.isTrue(useInternalTestProxy)) {
            String hostname = "localhost";
            int port = 18080;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
            client = newBuilder.connectTimeout((long)timeout.intValue(), TimeUnit.SECONDS).readTimeout((long)timeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)timeout.intValue(), TimeUnit.SECONDS).callTimeout((long)timeout.intValue(), TimeUnit.SECONDS).proxy(proxy).build();
        } else {
            client = newBuilder.connectTimeout((long)timeout.intValue(), TimeUnit.SECONDS).readTimeout((long)timeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)timeout.intValue(), TimeUnit.SECONDS).callTimeout((long)timeout.intValue(), TimeUnit.SECONDS).build();
        }
        return client;
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public static void unzipContentsToFolder(InputStream zippedContents, String outputFolder) throws IOException {
        ZipEntry zipEntry;
        File destDir = new File(outputFolder);
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(zippedContents));
        while ((zipEntry = zis.getNextEntry()) != null) {
            File newFile = CommonUtils.newFile(destDir, zipEntry);
            if (zipEntry.isDirectory()) {
                if (newFile.isDirectory() || newFile.mkdirs()) continue;
                throw new IOException("Failed to create directory " + newFile);
            }
            File parent = newFile.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("Failed to create directory " + parent);
            }
            try (FileOutputStream fos = new FileOutputStream(newFile);){
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
        }
        zis.closeEntry();
        zis.close();
    }
}

