/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import app.getxray.xray.CommonCloud;
import app.getxray.xray.CommonUtils;
import app.getxray.xray.XrayFeaturesImporterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class XrayFeaturesImporter {
    private static final String FEATURE_EXTENSION = ".feature";
    private static final MediaType MEDIA_TYPE_ZIP = MediaType.parse((String)"application/zip");
    private static final MediaType MEDIA_TYPE_FOR_FEATURE_FILES = MediaType.parse((String)"text/plain");
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_HEADER_PREFIX = "Bearer ";
    private static final String TEMP_DIR_PREFIX = "import_features";
    private String jiraBaseUrl;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraPersonalAccessToken;
    private String clientId;
    private String clientSecret;
    private String cloudApiBaseUrl;
    private String projectKey;
    private String projectId;
    private String source;
    private Boolean updateRepository = false;
    private Boolean ignoreSslErrors = false;
    private Boolean useInternalTestProxy = false;
    private Integer timeout = 50;
    private Boolean verbose = false;
    private Log logger;

    private XrayFeaturesImporter(ServerDCBuilder builder) {
        this.jiraBaseUrl = builder.jiraBaseUrl;
        this.jiraUsername = builder.jiraUsername;
        this.jiraPassword = builder.jiraPassword;
        this.jiraPersonalAccessToken = builder.jiraPersonalAccessToken;
        this.projectKey = builder.projectKey;
        this.projectId = builder.projectId;
        this.source = builder.source;
        this.updateRepository = builder.updateRepository;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    private XrayFeaturesImporter(CloudBuilder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.cloudApiBaseUrl = builder.cloudApiBaseUrl;
        this.projectKey = builder.projectKey;
        this.projectId = builder.projectId;
        this.source = builder.source;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    public JSONArray importFrom(String inputPath) throws IOException, XrayFeaturesImporterException {
        if (this.clientId != null) {
            return this.importCloud(inputPath, null, null);
        }
        return this.importServerDC(inputPath, null, null);
    }

    public JSONArray importFrom(String inputPath, JSONObject testInfo) throws IOException, XrayFeaturesImporterException {
        if (this.clientId != null) {
            return this.importCloud(inputPath, testInfo, null);
        }
        return this.importServerDC(inputPath, testInfo, null);
    }

    public JSONArray importFrom(String inputPath, JSONObject testInfo, JSONObject precondInfo) throws IOException, XrayFeaturesImporterException {
        if (this.clientId != null) {
            return this.importCloud(inputPath, testInfo, precondInfo);
        }
        return this.importServerDC(inputPath, testInfo, precondInfo);
    }

    public JSONArray importServerDC(String inputPath, JSONObject testInfo, JSONObject precondInfo) throws XrayFeaturesImporterException, IOException {
        MediaType mediaType;
        OkHttpClient client = CommonUtils.createHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        File inputFile = new File(inputPath);
        String credentials = this.jiraPersonalAccessToken != null ? BEARER_HEADER_PREFIX + this.jiraPersonalAccessToken : Credentials.basic((String)this.jiraUsername, (String)this.jiraPassword);
        String endpointUrl = this.jiraBaseUrl + "/rest/raven/2.0/import/feature";
        Response response = null;
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        if (this.projectKey != null) {
            builder.addQueryParameter("projectKey", this.projectKey);
        }
        if (this.updateRepository != null) {
            builder.addQueryParameter("updateRepository", this.updateRepository.toString());
        }
        if (inputPath.toLowerCase().endsWith(".zip")) {
            mediaType = MEDIA_TYPE_ZIP;
        } else if (inputPath.toLowerCase().endsWith(FEATURE_EXTENSION)) {
            mediaType = MEDIA_TYPE_FOR_FEATURE_FILES;
        } else if (inputFile.isDirectory()) {
            mediaType = MEDIA_TYPE_ZIP;
            File tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
            File tempZip = File.createTempFile("dummy", ".zip", tempDir);
            XrayFeaturesImporter.zipDirectory(inputPath, tempZip.getAbsolutePath());
            inputFile = tempZip;
        } else {
            throw new XrayFeaturesImporterException("Unsupported file format");
        }
        String partName = "file";
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(partName, inputFile.getName(), RequestBody.create((File)inputFile, (MediaType)mediaType));
        if (testInfo != null) {
            requestBodyBuilder = requestBodyBuilder.addFormDataPart("testInfo", "testinfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
        }
        if (precondInfo != null) {
            requestBodyBuilder = requestBodyBuilder.addFormDataPart("preCondInfo", "precondinfo.json", RequestBody.create((String)precondInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
        }
        requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(builder.build()).post((RequestBody)requestBody).addHeader(AUTHORIZATION_HEADER, credentials).build();
        CommonUtils.logRequest(this.logger, request, this.verbose);
        try {
            response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response, this.verbose);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                return new JSONArray(responseBody);
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            throw new XrayFeaturesImporterException(e.getMessage());
        }
    }

    public JSONArray importCloud(String inputPath, JSONObject testInfo, JSONObject precondInfo) throws XrayFeaturesImporterException, IOException {
        MediaType mediaType;
        OkHttpClient client = CommonUtils.createHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String authToken = CommonCloud.authenticateXrayAPIKeyCredentials(this.logger, this.verbose, client, this.clientId, this.clientSecret, this.cloudApiBaseUrl);
        String credentials = BEARER_HEADER_PREFIX + authToken;
        File inputFile = new File(inputPath);
        String endpointUrl = this.cloudApiBaseUrl + "/import/feature";
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("projectKey", this.projectKey);
        parameters.put("projectId", this.projectId);
        parameters.put("source", this.source);
        for (Map.Entry entry : parameters.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            builder.addQueryParameter((String)entry.getKey(), value);
        }
        if (inputPath.toLowerCase().endsWith(".zip")) {
            mediaType = MEDIA_TYPE_ZIP;
        } else if (inputPath.toLowerCase().endsWith(FEATURE_EXTENSION)) {
            mediaType = MEDIA_TYPE_FOR_FEATURE_FILES;
        } else {
            mediaType = MEDIA_TYPE_ZIP;
            if (inputFile.isDirectory()) {
                File tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
                File tempZip = File.createTempFile("dummy", ".zip", tempDir);
                XrayFeaturesImporter.zipDirectory(inputPath, tempZip.getAbsolutePath());
                inputFile = tempZip;
            }
        }
        String partName = "file";
        try {
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(partName, inputFile.getName(), RequestBody.create((File)inputFile, (MediaType)mediaType));
            if (testInfo != null) {
                requestBodyBuilder = requestBodyBuilder.addFormDataPart("testInfo", "testinfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
            }
            if (precondInfo != null) {
                requestBodyBuilder = requestBodyBuilder.addFormDataPart("precondInfo", "precondinfo.json", RequestBody.create((String)precondInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
            }
            requestBody = requestBodyBuilder.build();
        }
        catch (Exception e1) {
            this.logger.error((Throwable)e1);
            throw new XrayFeaturesImporterException(e1.getMessage());
        }
        Request request = new Request.Builder().url(builder.build()).post((RequestBody)requestBody).addHeader(AUTHORIZATION_HEADER, credentials).build();
        CommonUtils.logRequest(this.logger, request, this.verbose);
        try {
            Response response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response, this.verbose);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                JSONArray responseObj = new JSONArray();
                responseObj.put((Object)new JSONObject(responseBody));
                return responseObj;
            }
            throw new IOException("Unexpected HTTP code " + response);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            throw new XrayFeaturesImporterException(e.getMessage());
        }
    }

    public static void zipDirectory(String sourceDir, String outputZip) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputZip);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ZipOutputStream zipOut = new ZipOutputStream(bos);
        zipOut.setMethod(8);
        zipOut.setLevel(0);
        File fileToZip = new File(sourceDir);
        XrayFeaturesImporter.zipFile(fileToZip, fileToZip.getName(), zipOut, false);
        zipOut.finish();
        zipOut.close();
        fos.close();
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut, boolean createDir) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (createDir) {
                ZipEntry zipEntry = fileName.endsWith("/") ? new ZipEntry(fileName) : new ZipEntry(fileName + "/");
                FileTime fileTime = FileTime.fromMillis(System.currentTimeMillis());
                zipEntry.setCreationTime(fileTime);
                zipEntry.setLastAccessTime(fileTime);
                zipEntry.setLastModifiedTime(fileTime);
                zipOut.putNextEntry(zipEntry);
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                if (!childFile.isDirectory() && !childFile.getName().toLowerCase().endsWith(FEATURE_EXTENSION)) continue;
                if (createDir) {
                    XrayFeaturesImporter.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut, true);
                    continue;
                }
                XrayFeaturesImporter.zipFile(childFile, childFile.getName(), zipOut, true);
            }
            return;
        }
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            int length;
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipEntry.setSize(fileToZip.length());
            FileTime time = FileTime.fromMillis(System.currentTimeMillis());
            zipEntry.setCreationTime(time);
            zipEntry.setLastAccessTime(time);
            zipEntry.setLastModifiedTime(time);
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) > 0) {
                zipOut.write(bytes, 0, length);
            }
            zipOut.flush();
            zipOut.closeEntry();
        }
    }

    public static class CloudBuilder {
        private final String clientId;
        private final String clientSecret;
        private String cloudApiBaseUrl = "https://xray.cloud.getxray.app/api/v2";
        private String projectKey;
        private String projectId;
        private String source;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public CloudBuilder(String clientId, String clientSecret, String cloudApiBaseUrl) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.cloudApiBaseUrl = cloudApiBaseUrl;
        }

        public CloudBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public CloudBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public CloudBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public CloudBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public CloudBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public CloudBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public CloudBuilder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public CloudBuilder withSource(String source) {
            this.source = source;
            return this;
        }

        public XrayFeaturesImporter build() {
            return new XrayFeaturesImporter(this);
        }
    }

    public static class ServerDCBuilder {
        private final String jiraBaseUrl;
        private String jiraUsername;
        private String jiraPassword;
        private String jiraPersonalAccessToken;
        private String projectKey;
        private String projectId;
        private String source;
        private Boolean updateRepository = false;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public ServerDCBuilder(String jiraBaseUrl, String jiraUsername, String jiraPassword) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraUsername = jiraUsername;
            this.jiraPassword = jiraPassword;
        }

        public ServerDCBuilder(String jiraBaseUrl, String jiraPersonalAccessToken) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraPersonalAccessToken = jiraPersonalAccessToken;
        }

        public ServerDCBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public ServerDCBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public ServerDCBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ServerDCBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public ServerDCBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public ServerDCBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public ServerDCBuilder withupdateRepository(Boolean updateRepository) {
            this.updateRepository = updateRepository;
            return this;
        }

        public XrayFeaturesImporter build() {
            return new XrayFeaturesImporter(this);
        }
    }
}

