/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.FilterOperatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ValueSet", profile="http://hl7.org/fhir/profiles/ValueSet", id="valueset")
public class ValueSet
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="url", path="ValueSet.url", description="The logical URL for the value set", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="identifier", path="ValueSet.identifier", description="The identifier for the value set", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="ValueSet.version", description="The version identifier of the value set", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="ValueSet.name", description="The name of the value set", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ValueSet.publisher", description="Name of the publisher of the value set", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="ValueSet.description", description="Text search in the description of the value set", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="ValueSet.status", description="The status of the value set", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="ValueSet.date", description="The value set publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="system", path="ValueSet.codeSystem.system", description="The system for any codes defined by this value set", type="uri")
    public static final String SP_SYSTEM = "system";
    public static final UriClientParam SYSTEM = new UriClientParam("system");
    @SearchParamDefinition(name="code", path="ValueSet.codeSystem.concept.code", description="A code defined in the value set", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="reference", path="ValueSet.compose.include.system", description="A code system included or excluded in the value set or an imported value set", type="uri")
    public static final String SP_REFERENCE = "reference";
    public static final UriClientParam REFERENCE = new UriClientParam("reference");
    @SearchParamDefinition(name="context", path="ValueSet.useContext", description="A use context assigned to the value set", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="expansion", path="ValueSet.expansion.identifier", description="", type="uri")
    public static final String SP_EXPANSION = "expansion";
    public static final UriClientParam EXPANSION = new UriClientParam("expansion");
    @Child(name="url", type={UriDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An absolute URL that is used to identify this value set when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this value set is (or will be) published")
    private UriDt myUrl;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    private IdentifierDt myIdentifier;
    @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id.version", formalDefinition="Used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name describing the value set")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="status", formalDefinition="The status of the value set")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="This valueset was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="The name of the individual or organization that published the value set")
    private StringDt myPublisher;
    @Child(name="contact", order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date that the value set status was last changed. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes (e.g. the 'content logical definition')")
    private DateTimeDt myDate;
    @Child(name="lockedDate", type={DateDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="If a locked date is defined, then the Content Logical Definition must be evaluated using the current version of all referenced code system(s) and value set instances as of the locked date")
    private DateDt myLockedDate;
    @Child(name="description", type={StringDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language description of the use of the value set - reason for definition, \"the semantic space\" to be included in the value set, conditions of use, etc. The description may include a list of expected usages for the value set and can also describe the approach taken to build the value set.")
    private StringDt myDescription;
    @Child(name="useContext", type={CodeableConceptDt.class}, order=11, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of value set definitions.")
    private List<CodeableConceptDt> myUseContext;
    @Child(name="immutable", type={BooleanDt.class}, order=12, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change")
    private BooleanDt myImmutable;
    @Child(name="requirements", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Explains why this value set is needed and why it has been constrained as it has")
    private StringDt myRequirements;
    @Child(name="copyright", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set")
    private StringDt myCopyright;
    @Child(name="extensible", type={BooleanDt.class}, order=15, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Whether this is intended to be used with an extensible binding or not")
    private BooleanDt myExtensible;
    @Child(name="codeSystem", order=16, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A definition of a code system, inlined into the value set (as a packaging convenience). Note that the inline code system may be used from other value sets by referring to its (codeSystem.system) directly")
    private CodeSystem myCodeSystem;
    @Child(name="compose", order=17, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A set of criteria that provide the content logical definition of the value set by including or excluding codes from outside this value set")
    private Compose myCompose;
    @Child(name="expansion", order=18, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed")
    private Expansion myExpansion;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myLockedDate, this.myDescription, this.myUseContext, this.myImmutable, this.myRequirements, this.myCopyright, this.myExtensible, this.myCodeSystem, this.myCompose, this.myExpansion});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myLockedDate, this.myDescription, this.myUseContext, this.myImmutable, this.myRequirements, this.myCopyright, this.myExtensible, this.myCodeSystem, this.myCompose, this.myExpansion});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public ValueSet setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public ValueSet setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public ValueSet setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public ValueSet setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public ValueSet setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public ValueSet setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public ValueSet setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public ValueSet setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ValueSet setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public ValueSet setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public ValueSet setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public ValueSet setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public ValueSet setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public ValueSet setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public ValueSet addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public ValueSet setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ValueSet setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ValueSet setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public DateDt getLockedDateElement() {
        if (this.myLockedDate == null) {
            this.myLockedDate = new DateDt();
        }
        return this.myLockedDate;
    }

    public Date getLockedDate() {
        return (Date)this.getLockedDateElement().getValue();
    }

    public ValueSet setLockedDate(DateDt theValue) {
        this.myLockedDate = theValue;
        return this;
    }

    public ValueSet setLockedDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myLockedDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public ValueSet setLockedDateWithDayPrecision(Date theDate) {
        this.myLockedDate = new DateDt(theDate);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public ValueSet setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ValueSet setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getUseContext() {
        if (this.myUseContext == null) {
            this.myUseContext = new ArrayList<CodeableConceptDt>();
        }
        return this.myUseContext;
    }

    public ValueSet setUseContext(List<CodeableConceptDt> theValue) {
        this.myUseContext = theValue;
        return this;
    }

    public CodeableConceptDt addUseContext() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getUseContext().add(newType);
        return newType;
    }

    public ValueSet addUseContext(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUseContext().add(theValue);
        return this;
    }

    public CodeableConceptDt getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            return this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public BooleanDt getImmutableElement() {
        if (this.myImmutable == null) {
            this.myImmutable = new BooleanDt();
        }
        return this.myImmutable;
    }

    public Boolean getImmutable() {
        return (Boolean)this.getImmutableElement().getValue();
    }

    public ValueSet setImmutable(BooleanDt theValue) {
        this.myImmutable = theValue;
        return this;
    }

    public ValueSet setImmutable(boolean theBoolean) {
        this.myImmutable = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public ValueSet setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public ValueSet setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public String getCopyright() {
        return (String)this.getCopyrightElement().getValue();
    }

    public ValueSet setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public ValueSet setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public BooleanDt getExtensibleElement() {
        if (this.myExtensible == null) {
            this.myExtensible = new BooleanDt();
        }
        return this.myExtensible;
    }

    public Boolean getExtensible() {
        return (Boolean)this.getExtensibleElement().getValue();
    }

    public ValueSet setExtensible(BooleanDt theValue) {
        this.myExtensible = theValue;
        return this;
    }

    public ValueSet setExtensible(boolean theBoolean) {
        this.myExtensible = new BooleanDt(theBoolean);
        return this;
    }

    public CodeSystem getCodeSystem() {
        if (this.myCodeSystem == null) {
            this.myCodeSystem = new CodeSystem();
        }
        return this.myCodeSystem;
    }

    public ValueSet setCodeSystem(CodeSystem theValue) {
        this.myCodeSystem = theValue;
        return this;
    }

    public Compose getCompose() {
        if (this.myCompose == null) {
            this.myCompose = new Compose();
        }
        return this.myCompose;
    }

    public ValueSet setCompose(Compose theValue) {
        this.myCompose = theValue;
        return this;
    }

    public Expansion getExpansion() {
        if (this.myExpansion == null) {
            this.myExpansion = new Expansion();
        }
        return this.myExpansion;
    }

    public ValueSet setExpansion(Expansion theValue) {
        this.myExpansion = theValue;
        return this;
    }

    public String getResourceName() {
        return "ValueSet";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class ExpansionContains
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI which is the code system in which the code for this item in the expansion is defined")
        private UriDt mySystem;
        @Child(name="abstract", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value")
        private BooleanDt myAbstract;
        @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The version of this code system that defined this code and/or display. This should only be used with code systems that do not enforce concept permanence")
        private StringDt myVersion;
        @Child(name="code", type={CodeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set")
        private CodeDt myCode;
        @Child(name="display", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The recommended display for this item in the expansion")
        private StringDt myDisplay;
        @Child(name="contains", type={ExpansionContains.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Other codes and entries contained under this entry in the hierarchy")
        private List<ExpansionContains> myContains;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myAbstract, this.myVersion, this.myCode, this.myDisplay, this.myContains});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myAbstract, this.myVersion, this.myCode, this.myDisplay, this.myContains});
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public String getSystem() {
            return (String)this.getSystemElement().getValue();
        }

        public ExpansionContains setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public ExpansionContains setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public BooleanDt getAbstractElement() {
            if (this.myAbstract == null) {
                this.myAbstract = new BooleanDt();
            }
            return this.myAbstract;
        }

        public Boolean getAbstract() {
            return (Boolean)this.getAbstractElement().getValue();
        }

        public ExpansionContains setAbstract(BooleanDt theValue) {
            this.myAbstract = theValue;
            return this;
        }

        public ExpansionContains setAbstract(boolean theBoolean) {
            this.myAbstract = new BooleanDt(theBoolean);
            return this;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public String getVersion() {
            return (String)this.getVersionElement().getValue();
        }

        public ExpansionContains setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public ExpansionContains setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public ExpansionContains setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ExpansionContains setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public String getDisplay() {
            return (String)this.getDisplayElement().getValue();
        }

        public ExpansionContains setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public ExpansionContains setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public List<ExpansionContains> getContains() {
            if (this.myContains == null) {
                this.myContains = new ArrayList<ExpansionContains>();
            }
            return this.myContains;
        }

        public ExpansionContains setContains(List<ExpansionContains> theValue) {
            this.myContains = theValue;
            return this;
        }

        public ExpansionContains addContains() {
            ExpansionContains newType = new ExpansionContains();
            this.getContains().add(newType);
            return newType;
        }

        public ExpansionContains addContains(ExpansionContains theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getContains().add(theValue);
            return this;
        }

        public ExpansionContains getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                return this.addContains();
            }
            return this.getContains().get(0);
        }
    }

    @Block
    public static class ExpansionParameter
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of the parameter")
        private StringDt myName;
        @Child(name="value", order=1, min=0, max=1, summary=false, modifier=false, type={StringDt.class, BooleanDt.class, IntegerDt.class, DecimalDt.class, UriDt.class, CodeDt.class})
        @Description(shortDefinition="", formalDefinition="The value of the parameter")
        private IDatatype myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myValue});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public ExpansionParameter setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public ExpansionParameter setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public IDatatype getValue() {
            return this.myValue;
        }

        public ExpansionParameter setValue(IDatatype theValue) {
            this.myValue = theValue;
            return this;
        }
    }

    @Block
    public static class Expansion
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={UriDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An identifier that uniquely identifies this expansion of the valueset. Systems may re-use the same identifier as long as the expansion and the definition remain the same, but are not required to do so")
        private UriDt myIdentifier;
        @Child(name="timestamp", type={DateTimeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The time at which the expansion was produced by the expanding system.")
        private DateTimeDt myTimestamp;
        @Child(name="total", type={IntegerDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter")
        private IntegerDt myTotal;
        @Child(name="offset", type={IntegerDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL not be present")
        private IntegerDt myOffset;
        @Child(name="parameter", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion")
        private List<ExpansionParameter> myParameter;
        @Child(name="contains", order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The codes that are contained in the value set expansion")
        private List<ExpansionContains> myContains;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myTimestamp, this.myTotal, this.myOffset, this.myParameter, this.myContains});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myTimestamp, this.myTotal, this.myOffset, this.myParameter, this.myContains});
        }

        public UriDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new UriDt();
            }
            return this.myIdentifier;
        }

        public String getIdentifier() {
            return (String)this.getIdentifierElement().getValue();
        }

        public Expansion setIdentifier(UriDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Expansion setIdentifier(String theUri) {
            this.myIdentifier = new UriDt(theUri);
            return this;
        }

        public DateTimeDt getTimestampElement() {
            if (this.myTimestamp == null) {
                this.myTimestamp = new DateTimeDt();
            }
            return this.myTimestamp;
        }

        public Date getTimestamp() {
            return (Date)this.getTimestampElement().getValue();
        }

        public Expansion setTimestamp(DateTimeDt theValue) {
            this.myTimestamp = theValue;
            return this;
        }

        public Expansion setTimestamp(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myTimestamp = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Expansion setTimestampWithSecondsPrecision(Date theDate) {
            this.myTimestamp = new DateTimeDt(theDate);
            return this;
        }

        public IntegerDt getTotalElement() {
            if (this.myTotal == null) {
                this.myTotal = new IntegerDt();
            }
            return this.myTotal;
        }

        public Integer getTotal() {
            return (Integer)this.getTotalElement().getValue();
        }

        public Expansion setTotal(IntegerDt theValue) {
            this.myTotal = theValue;
            return this;
        }

        public Expansion setTotal(int theInteger) {
            this.myTotal = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getOffsetElement() {
            if (this.myOffset == null) {
                this.myOffset = new IntegerDt();
            }
            return this.myOffset;
        }

        public Integer getOffset() {
            return (Integer)this.getOffsetElement().getValue();
        }

        public Expansion setOffset(IntegerDt theValue) {
            this.myOffset = theValue;
            return this;
        }

        public Expansion setOffset(int theInteger) {
            this.myOffset = new IntegerDt(theInteger);
            return this;
        }

        public List<ExpansionParameter> getParameter() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<ExpansionParameter>();
            }
            return this.myParameter;
        }

        public Expansion setParameter(List<ExpansionParameter> theValue) {
            this.myParameter = theValue;
            return this;
        }

        public ExpansionParameter addParameter() {
            ExpansionParameter newType = new ExpansionParameter();
            this.getParameter().add(newType);
            return newType;
        }

        public Expansion addParameter(ExpansionParameter theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getParameter().add(theValue);
            return this;
        }

        public ExpansionParameter getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                return this.addParameter();
            }
            return this.getParameter().get(0);
        }

        public List<ExpansionContains> getContains() {
            if (this.myContains == null) {
                this.myContains = new ArrayList<ExpansionContains>();
            }
            return this.myContains;
        }

        public Expansion setContains(List<ExpansionContains> theValue) {
            this.myContains = theValue;
            return this;
        }

        public ExpansionContains addContains() {
            ExpansionContains newType = new ExpansionContains();
            this.getContains().add(newType);
            return newType;
        }

        public Expansion addContains(ExpansionContains theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getContains().add(theValue);
            return this;
        }

        public ExpansionContains getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                return this.addContains();
            }
            return this.getContains().get(0);
        }
    }

    @Block
    public static class ComposeIncludeFilter
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="property", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code that identifies a property defined in the code system")
        private CodeDt myProperty;
        @Child(name="op", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The kind of operation to perform as a part of the filter criteria")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/filter-operator")
        private BoundCodeDt<FilterOperatorEnum> myOp;
        @Child(name="value", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value")
        private CodeDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myProperty, this.myOp, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myProperty, this.myOp, this.myValue});
        }

        public CodeDt getPropertyElement() {
            if (this.myProperty == null) {
                this.myProperty = new CodeDt();
            }
            return this.myProperty;
        }

        public String getProperty() {
            return (String)this.getPropertyElement().getValue();
        }

        public ComposeIncludeFilter setProperty(CodeDt theValue) {
            this.myProperty = theValue;
            return this;
        }

        public ComposeIncludeFilter setProperty(String theCode) {
            this.myProperty = new CodeDt(theCode);
            return this;
        }

        public BoundCodeDt<FilterOperatorEnum> getOpElement() {
            if (this.myOp == null) {
                this.myOp = new BoundCodeDt(FilterOperatorEnum.VALUESET_BINDER);
            }
            return this.myOp;
        }

        public String getOp() {
            return (String)this.getOpElement().getValue();
        }

        public ComposeIncludeFilter setOp(BoundCodeDt<FilterOperatorEnum> theValue) {
            this.myOp = theValue;
            return this;
        }

        public ComposeIncludeFilter setOp(FilterOperatorEnum theValue) {
            this.setOp((BoundCodeDt<FilterOperatorEnum>)new BoundCodeDt(FilterOperatorEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public CodeDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new CodeDt();
            }
            return this.myValue;
        }

        public String getValue() {
            return (String)this.getValueElement().getValue();
        }

        public ComposeIncludeFilter setValue(CodeDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ComposeIncludeFilter setValue(String theCode) {
            this.myValue = new CodeDt(theCode);
            return this;
        }
    }

    @Block
    public static class ComposeIncludeConcept
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specifies a code for the concept to be included or excluded")
        private CodeDt myCode;
        @Child(name="display", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system")
        private StringDt myDisplay;
        @Child(name="designation", type={CodeSystemConceptDesignation.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        private List<CodeSystemConceptDesignation> myDesignation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myDisplay, this.myDesignation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDisplay, this.myDesignation});
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public ComposeIncludeConcept setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ComposeIncludeConcept setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public String getDisplay() {
            return (String)this.getDisplayElement().getValue();
        }

        public ComposeIncludeConcept setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public ComposeIncludeConcept setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public List<CodeSystemConceptDesignation> getDesignation() {
            if (this.myDesignation == null) {
                this.myDesignation = new ArrayList<CodeSystemConceptDesignation>();
            }
            return this.myDesignation;
        }

        public ComposeIncludeConcept setDesignation(List<CodeSystemConceptDesignation> theValue) {
            this.myDesignation = theValue;
            return this;
        }

        public CodeSystemConceptDesignation addDesignation() {
            CodeSystemConceptDesignation newType = new CodeSystemConceptDesignation();
            this.getDesignation().add(newType);
            return newType;
        }

        public ComposeIncludeConcept addDesignation(CodeSystemConceptDesignation theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDesignation().add(theValue);
            return this;
        }

        public CodeSystemConceptDesignation getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                return this.addDesignation();
            }
            return this.getDesignation().get(0);
        }
    }

    @Block
    public static class ComposeInclude
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI which is the code system from which the selected codes come from")
        private UriDt mySystem;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The version of the code system that the codes are selected from")
        private StringDt myVersion;
        @Child(name="concept", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specifies a concept to be included or excluded.")
        private List<ComposeIncludeConcept> myConcept;
        @Child(name="filter", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Select concepts by specify a matching criteria based on the properties (including relationships) defined by the system. If multiple filters are specified, they SHALL all be true.")
        private List<ComposeIncludeFilter> myFilter;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myVersion, this.myConcept, this.myFilter});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myVersion, this.myConcept, this.myFilter});
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public String getSystem() {
            return (String)this.getSystemElement().getValue();
        }

        public ComposeInclude setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public ComposeInclude setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public String getVersion() {
            return (String)this.getVersionElement().getValue();
        }

        public ComposeInclude setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public ComposeInclude setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public List<ComposeIncludeConcept> getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<ComposeIncludeConcept>();
            }
            return this.myConcept;
        }

        public ComposeInclude setConcept(List<ComposeIncludeConcept> theValue) {
            this.myConcept = theValue;
            return this;
        }

        public ComposeIncludeConcept addConcept() {
            ComposeIncludeConcept newType = new ComposeIncludeConcept();
            this.getConcept().add(newType);
            return newType;
        }

        public ComposeInclude addConcept(ComposeIncludeConcept theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getConcept().add(theValue);
            return this;
        }

        public ComposeIncludeConcept getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                return this.addConcept();
            }
            return this.getConcept().get(0);
        }

        public List<ComposeIncludeFilter> getFilter() {
            if (this.myFilter == null) {
                this.myFilter = new ArrayList<ComposeIncludeFilter>();
            }
            return this.myFilter;
        }

        public ComposeInclude setFilter(List<ComposeIncludeFilter> theValue) {
            this.myFilter = theValue;
            return this;
        }

        public ComposeIncludeFilter addFilter() {
            ComposeIncludeFilter newType = new ComposeIncludeFilter();
            this.getFilter().add(newType);
            return newType;
        }

        public ComposeInclude addFilter(ComposeIncludeFilter theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getFilter().add(theValue);
            return this;
        }

        public ComposeIncludeFilter getFilterFirstRep() {
            if (this.getFilter().isEmpty()) {
                return this.addFilter();
            }
            return this.getFilter().get(0);
        }
    }

    @Block
    public static class Compose
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="import", type={UriDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Includes the contents of the referenced value set as a part of the contents of this value set. This is an absolute URI that is a reference to ValueSet.uri")
        private List<UriDt> myImport;
        @Child(name="include", order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Include one or more codes from a code system")
        private List<ComposeInclude> myInclude;
        @Child(name="exclude", type={ComposeInclude.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Exclude one or more codes from the value set")
        private List<ComposeInclude> myExclude;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myImport, this.myInclude, this.myExclude});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myImport, this.myInclude, this.myExclude});
        }

        public List<UriDt> getImport() {
            if (this.myImport == null) {
                this.myImport = new ArrayList<UriDt>();
            }
            return this.myImport;
        }

        public Compose setImport(List<UriDt> theValue) {
            this.myImport = theValue;
            return this;
        }

        public UriDt addImport() {
            UriDt newType = new UriDt();
            this.getImport().add(newType);
            return newType;
        }

        public Compose addImport(UriDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getImport().add(theValue);
            return this;
        }

        public UriDt getImportFirstRep() {
            if (this.getImport().isEmpty()) {
                return this.addImport();
            }
            return this.getImport().get(0);
        }

        public Compose addImport(String theUri) {
            if (this.myImport == null) {
                this.myImport = new ArrayList<UriDt>();
            }
            this.myImport.add(new UriDt(theUri));
            return this;
        }

        public List<ComposeInclude> getInclude() {
            if (this.myInclude == null) {
                this.myInclude = new ArrayList<ComposeInclude>();
            }
            return this.myInclude;
        }

        public Compose setInclude(List<ComposeInclude> theValue) {
            this.myInclude = theValue;
            return this;
        }

        public ComposeInclude addInclude() {
            ComposeInclude newType = new ComposeInclude();
            this.getInclude().add(newType);
            return newType;
        }

        public Compose addInclude(ComposeInclude theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getInclude().add(theValue);
            return this;
        }

        public ComposeInclude getIncludeFirstRep() {
            if (this.getInclude().isEmpty()) {
                return this.addInclude();
            }
            return this.getInclude().get(0);
        }

        public List<ComposeInclude> getExclude() {
            if (this.myExclude == null) {
                this.myExclude = new ArrayList<ComposeInclude>();
            }
            return this.myExclude;
        }

        public Compose setExclude(List<ComposeInclude> theValue) {
            this.myExclude = theValue;
            return this;
        }

        public ComposeInclude addExclude() {
            ComposeInclude newType = new ComposeInclude();
            this.getExclude().add(newType);
            return newType;
        }

        public Compose addExclude(ComposeInclude theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getExclude().add(theValue);
            return this;
        }

        public ComposeInclude getExcludeFirstRep() {
            if (this.getExclude().isEmpty()) {
                return this.addExclude();
            }
            return this.getExclude().get(0);
        }
    }

    @Block
    public static class CodeSystemConceptDesignation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="language", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The language this designation is defined for")
        private CodeDt myLanguage;
        @Child(name="use", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code that details how this designation would be used")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-designation-use")
        private CodingDt myUse;
        @Child(name="value", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The text value for this designation")
        private StringDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLanguage, this.myUse, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLanguage, this.myUse, this.myValue});
        }

        public CodeDt getLanguageElement() {
            if (this.myLanguage == null) {
                this.myLanguage = new CodeDt();
            }
            return this.myLanguage;
        }

        public String getLanguage() {
            return (String)this.getLanguageElement().getValue();
        }

        public CodeSystemConceptDesignation setLanguage(CodeDt theValue) {
            this.myLanguage = theValue;
            return this;
        }

        public CodeSystemConceptDesignation setLanguage(String theCode) {
            this.myLanguage = new CodeDt(theCode);
            return this;
        }

        public CodingDt getUse() {
            if (this.myUse == null) {
                this.myUse = new CodingDt();
            }
            return this.myUse;
        }

        public CodeSystemConceptDesignation setUse(CodingDt theValue) {
            this.myUse = theValue;
            return this;
        }

        public StringDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new StringDt();
            }
            return this.myValue;
        }

        public String getValue() {
            return (String)this.getValueElement().getValue();
        }

        public CodeSystemConceptDesignation setValue(StringDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public CodeSystemConceptDesignation setValue(String theString) {
            this.myValue = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class CodeSystemConcept
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code - a text symbol - that uniquely identifies the concept within the code system")
        private CodeDt myCode;
        @Child(name="abstract", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If this code is not for use as a real concept")
        private BooleanDt myAbstract;
        @Child(name="display", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A human readable string that is the recommended default way to present this concept to a user")
        private StringDt myDisplay;
        @Child(name="definition", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The formal definition of the concept. The value set resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept")
        private StringDt myDefinition;
        @Child(name="designation", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        private List<CodeSystemConceptDesignation> myDesignation;
        @Child(name="concept", type={CodeSystemConcept.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) and can only be determined by examining the definitions of the concepts")
        private List<CodeSystemConcept> myConcept;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myAbstract, this.myDisplay, this.myDefinition, this.myDesignation, this.myConcept});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myAbstract, this.myDisplay, this.myDefinition, this.myDesignation, this.myConcept});
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public CodeSystemConcept setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public CodeSystemConcept setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public BooleanDt getAbstractElement() {
            if (this.myAbstract == null) {
                this.myAbstract = new BooleanDt();
            }
            return this.myAbstract;
        }

        public Boolean getAbstract() {
            return (Boolean)this.getAbstractElement().getValue();
        }

        public CodeSystemConcept setAbstract(BooleanDt theValue) {
            this.myAbstract = theValue;
            return this;
        }

        public CodeSystemConcept setAbstract(boolean theBoolean) {
            this.myAbstract = new BooleanDt(theBoolean);
            return this;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public String getDisplay() {
            return (String)this.getDisplayElement().getValue();
        }

        public CodeSystemConcept setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public CodeSystemConcept setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public StringDt getDefinitionElement() {
            if (this.myDefinition == null) {
                this.myDefinition = new StringDt();
            }
            return this.myDefinition;
        }

        public String getDefinition() {
            return (String)this.getDefinitionElement().getValue();
        }

        public CodeSystemConcept setDefinition(StringDt theValue) {
            this.myDefinition = theValue;
            return this;
        }

        public CodeSystemConcept setDefinition(String theString) {
            this.myDefinition = new StringDt(theString);
            return this;
        }

        public List<CodeSystemConceptDesignation> getDesignation() {
            if (this.myDesignation == null) {
                this.myDesignation = new ArrayList<CodeSystemConceptDesignation>();
            }
            return this.myDesignation;
        }

        public CodeSystemConcept setDesignation(List<CodeSystemConceptDesignation> theValue) {
            this.myDesignation = theValue;
            return this;
        }

        public CodeSystemConceptDesignation addDesignation() {
            CodeSystemConceptDesignation newType = new CodeSystemConceptDesignation();
            this.getDesignation().add(newType);
            return newType;
        }

        public CodeSystemConcept addDesignation(CodeSystemConceptDesignation theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDesignation().add(theValue);
            return this;
        }

        public CodeSystemConceptDesignation getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                return this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        public List<CodeSystemConcept> getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<CodeSystemConcept>();
            }
            return this.myConcept;
        }

        public CodeSystemConcept setConcept(List<CodeSystemConcept> theValue) {
            this.myConcept = theValue;
            return this;
        }

        public CodeSystemConcept addConcept() {
            CodeSystemConcept newType = new CodeSystemConcept();
            this.getConcept().add(newType);
            return newType;
        }

        public CodeSystemConcept addConcept(CodeSystemConcept theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getConcept().add(theValue);
            return this;
        }

        public CodeSystemConcept getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                return this.addConcept();
            }
            return this.getConcept().get(0);
        }
    }

    @Block
    public static class CodeSystem
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI that is used to reference this code system, including in [Coding]{datatypes.html#Coding}.system")
        private UriDt mySystem;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The version of this code system that defines the codes. Note that the version is optional because a well maintained code system does not suffer from versioning, and therefore the version does not need to be maintained. However many code systems are not well maintained, and the version needs to be defined and tracked")
        private StringDt myVersion;
        @Child(name="caseSensitive", type={BooleanDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="If code comparison is case sensitive when codes within this system are compared to each other")
        private BooleanDt myCaseSensitive;
        @Child(name="concept", order=3, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meaning of the hierarchical relationships are")
        private List<CodeSystemConcept> myConcept;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myVersion, this.myCaseSensitive, this.myConcept});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myVersion, this.myCaseSensitive, this.myConcept});
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public String getSystem() {
            return (String)this.getSystemElement().getValue();
        }

        public CodeSystem setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public CodeSystem setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public String getVersion() {
            return (String)this.getVersionElement().getValue();
        }

        public CodeSystem setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public CodeSystem setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public BooleanDt getCaseSensitiveElement() {
            if (this.myCaseSensitive == null) {
                this.myCaseSensitive = new BooleanDt();
            }
            return this.myCaseSensitive;
        }

        public Boolean getCaseSensitive() {
            return (Boolean)this.getCaseSensitiveElement().getValue();
        }

        public CodeSystem setCaseSensitive(BooleanDt theValue) {
            this.myCaseSensitive = theValue;
            return this;
        }

        public CodeSystem setCaseSensitive(boolean theBoolean) {
            this.myCaseSensitive = new BooleanDt(theBoolean);
            return this;
        }

        public List<CodeSystemConcept> getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<CodeSystemConcept>();
            }
            return this.myConcept;
        }

        public CodeSystem setConcept(List<CodeSystemConcept> theValue) {
            this.myConcept = theValue;
            return this;
        }

        public CodeSystemConcept addConcept() {
            CodeSystemConcept newType = new CodeSystemConcept();
            this.getConcept().add(newType);
            return newType;
        }

        public CodeSystem addConcept(CodeSystemConcept theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getConcept().add(theValue);
            return this;
        }

        public CodeSystemConcept getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                return this.addConcept();
            }
            return this.getConcept().get(0);
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the value set")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }
}

