/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.ElementDefinitionDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.DataElementStringencyEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DataElement", profile="http://hl7.org/fhir/profiles/DataElement", id="dataelement")
public class DataElement
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="DataElement.identifier", description="The identifier of the data element", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="DataElement.version", description="The version identifier of the data element", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");
    @SearchParamDefinition(name="name", path="DataElement.name", description="Name of the data element", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="DataElement.publisher", description="Name of the publisher of the data element", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="DataElement.element.definition", description="Text search in the description of the data element.  This corresponds to the definition of the first DataElement.element.", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="DataElement.status", description="The current status of the data element", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="DataElement.date", description="The data element publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="code", path="DataElement.element.code", description="A code for the data element (server may choose to do subsumption)", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="context", path="DataElement.useContext", description="A use context assigned to the data element", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="url", path="DataElement.url", description="The official URL for the data element", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="stringency", path="DataElement.stringency", description="The stringency of the data element definition", type="token")
    public static final String SP_STRINGENCY = "stringency";
    public static final TokenClientParam STRINGENCY = new TokenClientParam("stringency");
    @Child(name="url", type={UriDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An absolute URL that is used to identify this data element when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this data element is (or will be) published")
    private UriDt myUrl;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Formal identifier that is used to identify this data element when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The identifier that is used to identify this version of the data element when it is referenced in a StructureDefinition, Questionnaire or instance. This is an arbitrary value managed by the definition author manually.")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The term used by humans to refer to the data element.  Should ideally be unique within the context in which the data element is expected to be used.")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The status of the data element")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A flag to indicate that this search data element definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of the individual or organization that published the data element")
    private StringDt myPublisher;
    @Child(name="contact", order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date this version of the data element was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the data element  changes")
    private DateTimeDt myDate;
    @Child(name="useContext", type={CodeableConceptDt.class}, order=9, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of data element definitions.")
    private List<CodeableConceptDt> myUseContext;
    @Child(name="copyright", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A copyright statement relating to the definition of the data element. Copyright statements are generally legal restrictions on the use and publishing of the details of the definition of the data element")
    private StringDt myCopyright;
    @Child(name="stringency", type={CodeDt.class}, order=11, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies how precise the data element is in its definition")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/dataelement-stringency")
    private BoundCodeDt<DataElementStringencyEnum> myStringency;
    @Child(name="mapping", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies a specification (other than a terminology) that the elements which make up the DataElement have some correspondence with")
    private List<Mapping> myMapping;
    @Child(name="element", type={ElementDefinitionDt.class}, order=13, min=1, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Defines the structure, type, allowed values and other constraining characteristics of the data element")
    private List<ElementDefinitionDt> myElement;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myUseContext, this.myCopyright, this.myStringency, this.myMapping, this.myElement});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myUseContext, this.myCopyright, this.myStringency, this.myMapping, this.myElement});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public DataElement setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public DataElement setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DataElement setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public DataElement addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public DataElement setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public DataElement setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public DataElement setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public DataElement setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public DataElement setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DataElement setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public DataElement setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public DataElement setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public DataElement setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public DataElement setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public DataElement setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public DataElement addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public DataElement setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public DataElement setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DataElement setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public List<CodeableConceptDt> getUseContext() {
        if (this.myUseContext == null) {
            this.myUseContext = new ArrayList<CodeableConceptDt>();
        }
        return this.myUseContext;
    }

    public DataElement setUseContext(List<CodeableConceptDt> theValue) {
        this.myUseContext = theValue;
        return this;
    }

    public CodeableConceptDt addUseContext() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getUseContext().add(newType);
        return newType;
    }

    public DataElement addUseContext(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUseContext().add(theValue);
        return this;
    }

    public CodeableConceptDt getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            return this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public String getCopyright() {
        return (String)this.getCopyrightElement().getValue();
    }

    public DataElement setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public DataElement setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<DataElementStringencyEnum> getStringencyElement() {
        if (this.myStringency == null) {
            this.myStringency = new BoundCodeDt(DataElementStringencyEnum.VALUESET_BINDER);
        }
        return this.myStringency;
    }

    public String getStringency() {
        return (String)this.getStringencyElement().getValue();
    }

    public DataElement setStringency(BoundCodeDt<DataElementStringencyEnum> theValue) {
        this.myStringency = theValue;
        return this;
    }

    public DataElement setStringency(DataElementStringencyEnum theValue) {
        this.setStringency((BoundCodeDt<DataElementStringencyEnum>)new BoundCodeDt(DataElementStringencyEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<Mapping> getMapping() {
        if (this.myMapping == null) {
            this.myMapping = new ArrayList<Mapping>();
        }
        return this.myMapping;
    }

    public DataElement setMapping(List<Mapping> theValue) {
        this.myMapping = theValue;
        return this;
    }

    public Mapping addMapping() {
        Mapping newType = new Mapping();
        this.getMapping().add(newType);
        return newType;
    }

    public DataElement addMapping(Mapping theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMapping().add(theValue);
        return this;
    }

    public Mapping getMappingFirstRep() {
        if (this.getMapping().isEmpty()) {
            return this.addMapping();
        }
        return this.getMapping().get(0);
    }

    public List<ElementDefinitionDt> getElement() {
        if (this.myElement == null) {
            this.myElement = new ArrayList<ElementDefinitionDt>();
        }
        return this.myElement;
    }

    public DataElement setElement(List<ElementDefinitionDt> theValue) {
        this.myElement = theValue;
        return this;
    }

    public ElementDefinitionDt addElement() {
        ElementDefinitionDt newType = new ElementDefinitionDt();
        this.getElement().add(newType);
        return newType;
    }

    public DataElement addElement(ElementDefinitionDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getElement().add(theValue);
        return this;
    }

    public ElementDefinitionDt getElementFirstRep() {
        if (this.getElement().isEmpty()) {
            return this.addElement();
        }
        return this.getElement().get(0);
    }

    public String getResourceName() {
        return "DataElement";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the data element")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }

    @Block
    public static class Mapping
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An internal id that is used to identify this mapping set when specific mappings are made on a per-element basis")
        private IdDt myIdentity;
        @Child(name="uri", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI that identifies the specification that this mapping is expressed to")
        private UriDt myUri;
        @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A name for the specification that is being mapped to")
        private StringDt myName;
        @Child(name="comments", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage")
        private StringDt myComments;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myUri, this.myName, this.myComments});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myUri, this.myName, this.myComments});
        }

        public IdDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new IdDt();
            }
            return this.myIdentity;
        }

        public String getIdentity() {
            return this.getIdentityElement().getValue();
        }

        public Mapping setIdentity(IdDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public Mapping setIdentity(String theId) {
            this.myIdentity = new IdDt(theId);
            return this;
        }

        public UriDt getUriElement() {
            if (this.myUri == null) {
                this.myUri = new UriDt();
            }
            return this.myUri;
        }

        public String getUri() {
            return (String)this.getUriElement().getValue();
        }

        public Mapping setUri(UriDt theValue) {
            this.myUri = theValue;
            return this;
        }

        public Mapping setUri(String theUri) {
            this.myUri = new UriDt(theUri);
            return this;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Mapping setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Mapping setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getCommentsElement() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public String getComments() {
            return (String)this.getCommentsElement().getValue();
        }

        public Mapping setComments(StringDt theValue) {
            this.myComments = theValue;
            return this;
        }

        public Mapping setComments(String theString) {
            this.myComments = new StringDt(theString);
            return this;
        }
    }
}

