/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Specimen;
import ca.uhn.fhir.model.dstu2.valueset.DigitalMediaTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Media", profile="http://hl7.org/fhir/profiles/Media", id="media")
public class Media
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Media.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="subtype", path="Media.subtype", description="", type="token")
    public static final String SP_SUBTYPE = "subtype";
    public static final TokenClientParam SUBTYPE = new TokenClientParam("subtype");
    @SearchParamDefinition(name="identifier", path="Media.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="created", path="Media.content.creation", description="", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="subject", path="Media.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Encounter"), @Compartment(name="RelatedPerson")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="operator", path="Media.operator", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_OPERATOR = "operator";
    public static final ReferenceClientParam OPERATOR = new ReferenceClientParam("operator");
    @SearchParamDefinition(name="view", path="Media.view", description="", type="token")
    public static final String SP_VIEW = "view";
    public static final TokenClientParam VIEW = new TokenClientParam("view");
    @SearchParamDefinition(name="patient", path="Media.subject", description="", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_OPERATOR = new Include("Media:operator");
    public static final Include INCLUDE_PATIENT = new Include("Media:patient");
    public static final Include INCLUDE_SUBJECT = new Include("Media:subject");
    @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Whether the media is a photo (still image), an audio recording, or a video recording")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/digital-media-type")
    private BoundCodeDt<DigitalMediaTypeEnum> myType;
    @Child(name="subtype", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality")
    private CodeableConceptDt mySubtype;
    @Child(name="identifier", type={IdentifierDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=3, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, Group.class, Device.class, Specimen.class})
    @Description(shortDefinition="who.focus", formalDefinition="Who/What this Media is a record of")
    private ResourceReferenceDt mySubject;
    @Child(name="operator", order=4, min=0, max=1, summary=true, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.actor", formalDefinition="The person who administered the collection of the image")
    private ResourceReferenceDt myOperator;
    @Child(name="view", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="The name of the imaging view e.g. Lateral or Antero-posterior (AP).")
    private CodeableConceptDt myView;
    @Child(name="deviceName", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of the device / manufacturer of the device  that was used to make the recording")
    private StringDt myDeviceName;
    @Child(name="height", type={PositiveIntDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Height of the image in pixels (photo/video)")
    private PositiveIntDt myHeight;
    @Child(name="width", type={PositiveIntDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Width of the image in pixels (photo/video)")
    private PositiveIntDt myWidth;
    @Child(name="frames", type={PositiveIntDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required")
    private PositiveIntDt myFrames;
    @Child(name="duration", type={UnsignedIntDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The duration of the recording in seconds - for audio and video")
    private UnsignedIntDt myDuration;
    @Child(name="content", type={AttachmentDt.class}, order=11, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The actual content of the media - inline or by direct reference to the media source file")
    private AttachmentDt myContent;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.mySubtype, this.myIdentifier, this.mySubject, this.myOperator, this.myView, this.myDeviceName, this.myHeight, this.myWidth, this.myFrames, this.myDuration, this.myContent});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySubtype, this.myIdentifier, this.mySubject, this.myOperator, this.myView, this.myDeviceName, this.myHeight, this.myWidth, this.myFrames, this.myDuration, this.myContent});
    }

    public BoundCodeDt<DigitalMediaTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(DigitalMediaTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public String getType() {
        return (String)this.getTypeElement().getValue();
    }

    public Media setType(BoundCodeDt<DigitalMediaTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Media setType(DigitalMediaTypeEnum theValue) {
        this.setType((BoundCodeDt<DigitalMediaTypeEnum>)new BoundCodeDt(DigitalMediaTypeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getSubtype() {
        if (this.mySubtype == null) {
            this.mySubtype = new CodeableConceptDt();
        }
        return this.mySubtype;
    }

    public Media setSubtype(CodeableConceptDt theValue) {
        this.mySubtype = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Media setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Media addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Media setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getOperator() {
        if (this.myOperator == null) {
            this.myOperator = new ResourceReferenceDt();
        }
        return this.myOperator;
    }

    public Media setOperator(ResourceReferenceDt theValue) {
        this.myOperator = theValue;
        return this;
    }

    public CodeableConceptDt getView() {
        if (this.myView == null) {
            this.myView = new CodeableConceptDt();
        }
        return this.myView;
    }

    public Media setView(CodeableConceptDt theValue) {
        this.myView = theValue;
        return this;
    }

    public StringDt getDeviceNameElement() {
        if (this.myDeviceName == null) {
            this.myDeviceName = new StringDt();
        }
        return this.myDeviceName;
    }

    public String getDeviceName() {
        return (String)this.getDeviceNameElement().getValue();
    }

    public Media setDeviceName(StringDt theValue) {
        this.myDeviceName = theValue;
        return this;
    }

    public Media setDeviceName(String theString) {
        this.myDeviceName = new StringDt(theString);
        return this;
    }

    public PositiveIntDt getHeightElement() {
        if (this.myHeight == null) {
            this.myHeight = new PositiveIntDt();
        }
        return this.myHeight;
    }

    public Integer getHeight() {
        return (Integer)this.getHeightElement().getValue();
    }

    public Media setHeight(PositiveIntDt theValue) {
        this.myHeight = theValue;
        return this;
    }

    public Media setHeight(int theInteger) {
        this.myHeight = new PositiveIntDt(theInteger);
        return this;
    }

    public PositiveIntDt getWidthElement() {
        if (this.myWidth == null) {
            this.myWidth = new PositiveIntDt();
        }
        return this.myWidth;
    }

    public Integer getWidth() {
        return (Integer)this.getWidthElement().getValue();
    }

    public Media setWidth(PositiveIntDt theValue) {
        this.myWidth = theValue;
        return this;
    }

    public Media setWidth(int theInteger) {
        this.myWidth = new PositiveIntDt(theInteger);
        return this;
    }

    public PositiveIntDt getFramesElement() {
        if (this.myFrames == null) {
            this.myFrames = new PositiveIntDt();
        }
        return this.myFrames;
    }

    public Integer getFrames() {
        return (Integer)this.getFramesElement().getValue();
    }

    public Media setFrames(PositiveIntDt theValue) {
        this.myFrames = theValue;
        return this;
    }

    public Media setFrames(int theInteger) {
        this.myFrames = new PositiveIntDt(theInteger);
        return this;
    }

    public UnsignedIntDt getDurationElement() {
        if (this.myDuration == null) {
            this.myDuration = new UnsignedIntDt();
        }
        return this.myDuration;
    }

    public Integer getDuration() {
        return (Integer)this.getDurationElement().getValue();
    }

    public Media setDuration(UnsignedIntDt theValue) {
        this.myDuration = theValue;
        return this;
    }

    public Media setDuration(int theInteger) {
        this.myDuration = new UnsignedIntDt(theInteger);
        return this;
    }

    public AttachmentDt getContent() {
        if (this.myContent == null) {
            this.myContent = new AttachmentDt();
        }
        return this.myContent;
    }

    public Media setContent(AttachmentDt theValue) {
        this.myContent = theValue;
        return this;
    }

    public String getResourceName() {
        return "Media";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

