/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum DiagnosticOrderStatusEnum {
    PROPOSED("proposed", "http://hl7.org/fhir/diagnostic-order-status"),
    DRAFT("draft", "http://hl7.org/fhir/diagnostic-order-status"),
    PLANNED("planned", "http://hl7.org/fhir/diagnostic-order-status"),
    REQUESTED("requested", "http://hl7.org/fhir/diagnostic-order-status"),
    RECEIVED("received", "http://hl7.org/fhir/diagnostic-order-status"),
    ACCEPTED("accepted", "http://hl7.org/fhir/diagnostic-order-status"),
    IN_PROGRESS("in-progress", "http://hl7.org/fhir/diagnostic-order-status"),
    REVIEW("review", "http://hl7.org/fhir/diagnostic-order-status"),
    COMPLETED("completed", "http://hl7.org/fhir/diagnostic-order-status"),
    CANCELLED("cancelled", "http://hl7.org/fhir/diagnostic-order-status"),
    SUSPENDED("suspended", "http://hl7.org/fhir/diagnostic-order-status"),
    REJECTED("rejected", "http://hl7.org/fhir/diagnostic-order-status"),
    FAILED("failed", "http://hl7.org/fhir/diagnostic-order-status");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "DiagnosticOrderStatus";
    private static Map<String, DiagnosticOrderStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, DiagnosticOrderStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<DiagnosticOrderStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static DiagnosticOrderStatusEnum forCode(String theCode) {
        DiagnosticOrderStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private DiagnosticOrderStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, DiagnosticOrderStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, DiagnosticOrderStatusEnum>>();
        for (DiagnosticOrderStatusEnum next : DiagnosticOrderStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<DiagnosticOrderStatusEnum>(){

            public String toCodeString(DiagnosticOrderStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(DiagnosticOrderStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public DiagnosticOrderStatusEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public DiagnosticOrderStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, DiagnosticOrderStatusEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

