/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum InstanceAvailabilityEnum {
    ONLINE("ONLINE", "http://nema.org/dicom/dicm"),
    OFFLINE("OFFLINE", "http://nema.org/dicom/dicm"),
    NEARLINE("NEARLINE", "http://nema.org/dicom/dicm"),
    UNAVAILABLE("UNAVAILABLE", "http://nema.org/dicom/dicm");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "InstanceAvailability";
    private static Map<String, InstanceAvailabilityEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, InstanceAvailabilityEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<InstanceAvailabilityEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static InstanceAvailabilityEnum forCode(String theCode) {
        InstanceAvailabilityEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private InstanceAvailabilityEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, InstanceAvailabilityEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, InstanceAvailabilityEnum>>();
        for (InstanceAvailabilityEnum next : InstanceAvailabilityEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<InstanceAvailabilityEnum>(){

            public String toCodeString(InstanceAvailabilityEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(InstanceAvailabilityEnum theEnum) {
                return theEnum.getSystem();
            }

            public InstanceAvailabilityEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public InstanceAvailabilityEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, InstanceAvailabilityEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

