/*
 * Decompiled with CFR 0.152.
 */
package cat.gencat.economia.pscp.interficies.exemples;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public abstract class DateTimeUtilsIntegrador {
    public static final String DATETIME_PSCP1_FORMAT_REGEX = "^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})Z$";
    public static final String SIMPLE_DATETIME_PSCP1_FORMAT_REGEX = "^(\\d{2}\\/\\d{2}\\/\\d{4})$";
    public static final String DATETIME_PSCP1_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String SIMPLE_DATETIME_PSCP1_FORMAT = "dd/MM/yyyy";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final DateTimeFormatter DATE_TIME_PSCP1_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneId.of("UTC"));
    public static final DateTimeFormatter SIMPLE_DATE_TIME_PSCP1_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy").withZone(ZoneId.of("UTC"));
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));

    private DateTimeUtilsIntegrador() {
    }

    public static LocalDateTime parseToLocalDateTime(String dateAsUTC) {
        LocalDateTime localDateTimeAsUTC = null;
        localDateTimeAsUTC = dateAsUTC.matches(DATETIME_PSCP1_FORMAT_REGEX) ? LocalDateTime.parse(dateAsUTC, DATE_TIME_PSCP1_FORMATTER) : (dateAsUTC.matches(SIMPLE_DATETIME_PSCP1_FORMAT_REGEX) ? LocalDateTime.of(LocalDate.parse(dateAsUTC, SIMPLE_DATE_TIME_PSCP1_FORMATTER), LocalTime.of(0, 0, 0)) : LocalDateTime.parse(dateAsUTC, DATE_TIME_FORMATTER));
        return localDateTimeAsUTC.atZone(ZoneId.of("UTC")).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String toISO8601(LocalDateTime dateAsServerTime) {
        return DATE_TIME_FORMATTER.format(dateAsServerTime.atZone(ZoneId.systemDefault()));
    }
}

