/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.auth;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerBase;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import com.amazonaws.neptune.auth.RequestMetadata;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class NeptuneRequestMetadataSigV4Signer
extends NeptuneSigV4SignerBase<RequestMetadata> {
    public NeptuneRequestMetadataSigV4Signer(String regionName, AWSCredentialsProvider v1AwsCredentialProvider) throws NeptuneSigV4SignerException {
        super(regionName, v1AwsCredentialProvider);
    }

    public NeptuneRequestMetadataSigV4Signer(String regionName, AWSCredentialsProvider v1AwsCredentialProvider, String serviceName) throws NeptuneSigV4SignerException {
        super(regionName, v1AwsCredentialProvider, serviceName);
    }

    public NeptuneRequestMetadataSigV4Signer(String regionName, AwsCredentialsProvider awsCredentialsProvider) throws NeptuneSigV4SignerException {
        super(regionName, awsCredentialsProvider);
    }

    public NeptuneRequestMetadataSigV4Signer(String regionName, AwsCredentialsProvider awsCredentialsProvider, String serviceName) throws NeptuneSigV4SignerException {
        super(regionName, awsCredentialsProvider, serviceName);
    }

    @Override
    protected SdkHttpFullRequest toSignableRequest(RequestMetadata request) throws NeptuneSigV4SignerException {
        this.checkNotNull(request, "The request must not be null");
        this.checkNotNull(request.getFullUri(), "The request URI must not be null");
        this.checkNotNull(request.getMethod(), "The request method must not be null");
        URI fullUri = URI.create(request.getFullUri());
        this.checkNotNull(fullUri.getAuthority(), "Authority must not be null");
        this.checkNotNull(fullUri.getScheme(), "Scheme must not be null");
        String hostName = "";
        HashMap<String, List<String>> headersInternal = new HashMap<String, List<String>>();
        Map<String, String> headers = request.getHeaders();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (!header.getKey().equalsIgnoreCase("Host")) {
                headersInternal.put(header.getKey(), Arrays.asList(header.getValue()));
                continue;
            }
            hostName = header.getValue();
        }
        String queryStr = fullUri.getRawQuery();
        Map<String, List<String>> parametersInternal = this.extractParametersFromQueryString(queryStr);
        byte[] bytes = request.getContent().isPresent() ? request.getContent().get() : "".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        URI endpointUri = URI.create(fullUri.getScheme() + "://" + fullUri.getAuthority());
        String resourcePath = fullUri.getPath();
        return this.convertToSignableRequest(request.getMethod(), endpointUri, resourcePath, headersInternal, parametersInternal, content);
    }

    @Override
    protected void attachSignature(RequestMetadata request, NeptuneSigV4SignerBase.NeptuneSigV4Signature signature) throws NeptuneSigV4SignerException {
        this.checkNotNull(signature, "The signature must not be null");
        this.checkNotNull(signature.getHostHeader(), "The signed Host header must not be null");
        this.checkNotNull(signature.getXAmzDateHeader(), "The signed X-AMZ-DATE header must not be null");
        this.checkNotNull(signature.getAuthorizationHeader(), "The signed Authorization header must not be null");
        Map<String, String> headers = request.getHeaders();
        Optional<String> hostHeaderName = Optional.empty();
        for (String name2 : headers.keySet()) {
            if (!name2.equalsIgnoreCase("Host")) continue;
            hostHeaderName = Optional.of(name2);
            break;
        }
        hostHeaderName.ifPresent(name -> headers.remove(name));
        request.getHeaders().put("Host", signature.getHostHeader());
        request.getHeaders().put("X-Amz-Date", signature.getXAmzDateHeader());
        request.getHeaders().put("Authorization", signature.getAuthorizationHeader());
        if (!signature.getSessionToken().isEmpty()) {
            request.getHeaders().put("X-Amz-Security-Token", signature.getSessionToken());
        }
    }
}

