/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.auth;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.NeptuneSigV4Signer;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import com.amazonaws.neptune.auth.credentials.V1toV2CredentialsProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public abstract class NeptuneSigV4SignerBase<T>
implements NeptuneSigV4Signer<T> {
    private static final String NEPTUNE_SERVICE_NAME = "neptune-db";
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region awsRegion;
    private final String serviceName;
    private final Aws4Signer aws4Signer;

    public NeptuneSigV4SignerBase(String regionName, AWSCredentialsProvider v1AwsCredentialProvider) throws NeptuneSigV4SignerException {
        this(regionName, v1AwsCredentialProvider, NEPTUNE_SERVICE_NAME);
    }

    public NeptuneSigV4SignerBase(String regionName, AWSCredentialsProvider v1AwsCredentialProvider, String serviceName) throws NeptuneSigV4SignerException {
        this(regionName, V1toV2CredentialsProvider.create(v1AwsCredentialProvider), serviceName);
    }

    public NeptuneSigV4SignerBase(String regionName, AwsCredentialsProvider awsCredentialsProvider) throws NeptuneSigV4SignerException {
        this(regionName, awsCredentialsProvider, NEPTUNE_SERVICE_NAME);
    }

    public NeptuneSigV4SignerBase(String regionName, AwsCredentialsProvider awsCredentialsProvider, String serviceName) throws NeptuneSigV4SignerException {
        this.checkNotNull(regionName, "The region name must not be null");
        this.checkNotNull(awsCredentialsProvider, "The credentials provider must not be null");
        this.checkNotNull(serviceName, "The serviceName must not be null");
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsRegion = Region.of((String)regionName);
        this.serviceName = serviceName;
        this.aws4Signer = Aws4Signer.create();
    }

    protected abstract SdkHttpFullRequest toSignableRequest(T var1) throws NeptuneSigV4SignerException;

    protected abstract void attachSignature(T var1, NeptuneSigV4Signature var2) throws NeptuneSigV4SignerException;

    @Override
    public void signRequest(T request) throws NeptuneSigV4SignerException {
        try {
            SdkHttpFullRequest awsSignableRequest = this.toSignableRequest(request);
            AwsCredentials credentials = this.awsCredentialsProvider.resolveCredentials();
            Aws4SignerParams awsSignerParams = Aws4SignerParams.builder().awsCredentials(credentials).signingName(this.serviceName).signingRegion(this.awsRegion).build();
            SdkHttpFullRequest awsSignedRequest = this.aws4Signer.sign(awsSignableRequest, awsSignerParams);
            String sessionToken = "";
            if (credentials instanceof AwsSessionCredentials) {
                sessionToken = ((AwsSessionCredentials)credentials).sessionToken();
            }
            NeptuneSigV4Signature signature = new NeptuneSigV4Signature((String)awsSignedRequest.matchingHeaders("Host").get(0), (String)awsSignedRequest.matchingHeaders("X-Amz-Date").get(0), (String)awsSignedRequest.matchingHeaders("Authorization").get(0), sessionToken);
            this.attachSignature(request, signature);
        }
        catch (Throwable t) {
            throw new NeptuneSigV4SignerException(t);
        }
    }

    protected SdkHttpFullRequest convertToSignableRequest(String httpMethodName, URI httpEndpointUri, String resourcePath, Map<String, List<String>> httpHeaders, Map<String, List<String>> httpParameters, InputStream httpContent) throws NeptuneSigV4SignerException {
        SdkHttpFullRequest awsRequest;
        this.checkNotNull(httpMethodName, "Http method name must not be null");
        this.checkNotNull(httpEndpointUri, "Http endpoint URI must not be null");
        this.checkNotNull(httpHeaders, "Http headers must not be null");
        this.checkNotNull(httpParameters, "Http parameters must not be null");
        this.checkNotNull(httpContent, "Http content name must not be null");
        try {
            awsRequest = SdkHttpFullRequest.builder().method(SdkHttpMethod.fromValue((String)httpMethodName)).uri(httpEndpointUri).encodedPath(resourcePath).headers(httpHeaders).rawQueryParameters(httpParameters).contentStreamProvider(RequestBody.fromInputStream((InputStream)httpContent, (long)httpContent.available()).contentStreamProvider()).build();
        }
        catch (IOException e) {
            throw new NeptuneSigV4SignerException(e);
        }
        return awsRequest;
    }

    protected Map<String, List<String>> extractParametersFromQueryString(String queryStr) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (queryStr != null) {
            for (String queryParam : queryStr.split("&")) {
                if (queryParam.isEmpty()) continue;
                String[] keyValuePair = queryParam.split("=", 2);
                String key = SdkHttpUtils.urlDecode((String)keyValuePair[0]);
                String value = keyValuePair.length == 2 ? SdkHttpUtils.urlDecode((String)keyValuePair[1]) : "";
                if (!parameters.containsKey(key)) {
                    parameters.put(key, new ArrayList());
                }
                ((List)parameters.get(key)).add(value);
            }
        }
        return parameters;
    }

    protected void checkNotNull(Object obj, String errMsg) throws NeptuneSigV4SignerException {
        if (obj == null) {
            throw new NeptuneSigV4SignerException(errMsg);
        }
    }

    public static class NeptuneSigV4Signature {
        private final String hostHeader;
        private final String xAmzDateHeader;
        private final String authorizationHeader;
        private final String sessionToken;

        public NeptuneSigV4Signature(String hostHeader, String xAmzDateHeader, String authorizationHeader, String sessionToken) {
            this.hostHeader = hostHeader;
            this.xAmzDateHeader = xAmzDateHeader;
            this.authorizationHeader = authorizationHeader;
            this.sessionToken = sessionToken;
        }

        public String getHostHeader() {
            return this.hostHeader;
        }

        public String getXAmzDateHeader() {
            return this.xAmzDateHeader;
        }

        public String getAuthorizationHeader() {
            return this.authorizationHeader;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }
    }
}

