/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.logs.model.Anomaly;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class AnomalyMarshaller {
    private static final MarshallingInfo<String> ANOMALYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("anomalyId").build();
    private static final MarshallingInfo<String> PATTERNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patternId").build();
    private static final MarshallingInfo<String> ANOMALYDETECTORARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("anomalyDetectorArn").build();
    private static final MarshallingInfo<String> PATTERNSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patternString").build();
    private static final MarshallingInfo<String> PATTERNREGEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patternRegex").build();
    private static final MarshallingInfo<String> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("priority").build();
    private static final MarshallingInfo<Long> FIRSTSEEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstSeen").build();
    private static final MarshallingInfo<Long> LASTSEEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastSeen").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Boolean> ACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("active").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<Map> HISTOGRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("histogram").build();
    private static final MarshallingInfo<List> LOGSAMPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logSamples").build();
    private static final MarshallingInfo<List> PATTERNTOKENS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patternTokens").build();
    private static final MarshallingInfo<List> LOGGROUPARNLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupArnList").build();
    private static final MarshallingInfo<Boolean> SUPPRESSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suppressed").build();
    private static final MarshallingInfo<Long> SUPPRESSEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suppressedDate").build();
    private static final MarshallingInfo<Long> SUPPRESSEDUNTIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suppressedUntil").build();
    private static final MarshallingInfo<Boolean> ISPATTERNLEVELSUPPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isPatternLevelSuppression").build();
    private static final AnomalyMarshaller instance = new AnomalyMarshaller();

    public static AnomalyMarshaller getInstance() {
        return instance;
    }

    public void marshall(Anomaly anomaly, ProtocolMarshaller protocolMarshaller) {
        if (anomaly == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)anomaly.getAnomalyId(), ANOMALYID_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getPatternId(), PATTERNID_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getAnomalyDetectorArn(), ANOMALYDETECTORARN_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getPatternString(), PATTERNSTRING_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getPatternRegex(), PATTERNREGEX_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getPriority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getFirstSeen(), FIRSTSEEN_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getLastSeen(), LASTSEEN_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getActive(), ACTIVE_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getState(), STATE_BINDING);
            protocolMarshaller.marshall(anomaly.getHistogram(), HISTOGRAM_BINDING);
            protocolMarshaller.marshall(anomaly.getLogSamples(), LOGSAMPLES_BINDING);
            protocolMarshaller.marshall(anomaly.getPatternTokens(), PATTERNTOKENS_BINDING);
            protocolMarshaller.marshall(anomaly.getLogGroupArnList(), LOGGROUPARNLIST_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getSuppressed(), SUPPRESSED_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getSuppressedDate(), SUPPRESSEDDATE_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getSuppressedUntil(), SUPPRESSEDUNTIL_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getIsPatternLevelSuppression(), ISPATTERNLEVELSUPPRESSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

