/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.caesium.cron.rule.field;

import com.atlassian.scheduler.caesium.cron.rule.field.DayOfWeekConstantConverter;
import com.atlassian.scheduler.caesium.cron.rule.field.SpecialDayFieldRule;
import com.atlassian.util.concurrent.Assertions;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class SpecialDayOfWeekNthFieldRule
extends SpecialDayFieldRule {
    private static final long serialVersionUID = 6051673567197325589L;
    private final int isoDayOfWeek;
    private final int nth;

    public SpecialDayOfWeekNthFieldRule(int cronDayOfWeek, int nth) {
        Assertions.isTrue((String)"cronDayOfWeek must be in the range [1,7]", (cronDayOfWeek >= 1 && cronDayOfWeek <= 7 ? 1 : 0) != 0);
        Assertions.isTrue((String)"nth must be in the range [1,5]", (nth >= 1 && nth <= 5 ? 1 : 0) != 0);
        this.isoDayOfWeek = DayOfWeekConstantConverter.cronToIso(cronDayOfWeek);
        this.nth = nth;
    }

    @Override
    int calculateMatchingDay(int year, int month) {
        LocalDate lastDayOfMonth;
        LocalDate firstDayOfMonth = new LocalDate(year, month, 1);
        LocalDate date = this.calculateNthDayOfWeekFromFirstOfMonth(firstDayOfMonth);
        if (date.isAfter((ReadablePartial)(lastDayOfMonth = firstDayOfMonth.dayOfMonth().withMaximumValue()))) {
            return -1;
        }
        return date.getDayOfMonth();
    }

    private LocalDate calculateNthDayOfWeekFromFirstOfMonth(LocalDate firstDayOfMonth) {
        LocalDate date = firstDayOfMonth.withDayOfWeek(this.isoDayOfWeek);
        if (date.isBefore((ReadablePartial)firstDayOfMonth)) {
            return date.plusWeeks(this.nth);
        }
        return date.plusWeeks(this.nth - 1);
    }

    @Override
    protected void appendTo(StringBuilder sb) {
        sb.append(DayOfWeekConstantConverter.isoToName(this.isoDayOfWeek)).append('#').append(this.nth);
    }
}

