/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler;
import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler2;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReceiveLinkHandlerWrapper {
    private final boolean isV2;
    private final ReceiveLinkHandler receiveLinkHandler;
    private final ReceiveLinkHandler2 receiveLinkHandler2;
    private ClientLogger logger;

    public ReceiveLinkHandlerWrapper(ReceiveLinkHandler receiveLinkHandler) {
        this.isV2 = false;
        this.receiveLinkHandler = receiveLinkHandler;
        this.receiveLinkHandler2 = null;
    }

    public ReceiveLinkHandlerWrapper(ReceiveLinkHandler2 receiveLinkHandler2) {
        this.isV2 = true;
        this.receiveLinkHandler = null;
        this.receiveLinkHandler2 = receiveLinkHandler2;
    }

    public void setLogger(ClientLogger logger) {
        this.logger = logger;
    }

    public boolean isV2() {
        return this.isV2;
    }

    String getConnectionId() {
        return this.isV2 ? this.receiveLinkHandler2.getConnectionId() : this.receiveLinkHandler.getConnectionId();
    }

    public String getLinkName() {
        return this.isV2 ? this.receiveLinkHandler2.getLinkName() : this.receiveLinkHandler.getLinkName();
    }

    public String getHostname() {
        return this.isV2 ? this.receiveLinkHandler2.getHostname() : this.receiveLinkHandler.getHostname();
    }

    Flux<EndpointState> getEndpointStates() {
        if (this.isV2) {
            return this.receiveLinkHandler2.getEndpointStates();
        }
        return this.receiveLinkHandler.getEndpointStates();
    }

    Flux<Delivery> getDeliveredMessagesV1() {
        if (this.isV2) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)ReceiveLinkHandlerWrapper.unsupportedOperation("getDeliveredMessagesV1", "V2"));
        }
        return this.receiveLinkHandler.getDeliveredMessages();
    }

    Flux<Message> getDeliveredMessagesV2() {
        if (!this.isV2) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)ReceiveLinkHandlerWrapper.unsupportedOperation("getDeliveredMessagesV2", "V1"));
        }
        return this.receiveLinkHandler2.getMessages();
    }

    Mono<Void> sendDisposition(String deliveryTag, DeliveryState deliveryState) {
        if (!this.isV2) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ReceiveLinkHandlerWrapper.unsupportedOperation("updateDisposition", "V1"));
        }
        return this.receiveLinkHandler2.sendDisposition(deliveryTag, deliveryState);
    }

    Mono<Void> beginClose() {
        if (this.isV2) {
            return this.receiveLinkHandler2.preClose();
        }
        return Mono.empty();
    }

    void close() {
        if (this.isV2) {
            this.receiveLinkHandler2.close();
        } else {
            this.receiveLinkHandler.close();
        }
    }

    private static RuntimeException unsupportedOperation(String operation, String unsupportedStack) {
        return new UnsupportedOperationException("The " + operation + " is not needed or supported in " + unsupportedStack + ".");
    }
}

