/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.models;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.models.DeliveryOutcome;
import com.azure.core.amqp.models.DeliveryState;
import java.util.Map;
import java.util.Objects;

public final class RejectedDeliveryOutcome
extends DeliveryOutcome {
    private final AmqpErrorCondition errorCondition;
    private Map<String, Object> errorInfo;

    public RejectedDeliveryOutcome(AmqpErrorCondition errorCondition) {
        super(DeliveryState.REJECTED);
        this.errorCondition = Objects.requireNonNull(errorCondition, "'errorCondition' cannot be null.");
    }

    public AmqpErrorCondition getErrorCondition() {
        return this.errorCondition;
    }

    public String getErrorDescription() {
        return this.errorCondition.getErrorCondition();
    }

    public Map<String, Object> getErrorInfo() {
        return this.errorInfo;
    }

    public RejectedDeliveryOutcome setErrorInfo(Map<String, Object> errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }
}

