/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpManagementNode;
import com.azure.core.amqp.AmqpSession;
import com.azure.core.amqp.AmqpShutdownSignal;
import com.azure.core.amqp.ClaimsBasedSecurityNode;
import com.azure.core.util.AsyncCloseable;
import java.util.Map;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface AmqpConnection
extends Disposable,
AsyncCloseable {
    public String getId();

    public String getFullyQualifiedNamespace();

    public int getMaxFrameSize();

    public Map<String, Object> getConnectionProperties();

    public Mono<ClaimsBasedSecurityNode> getClaimsBasedSecurityNode();

    public Mono<AmqpSession> createSession(String var1);

    public boolean removeSession(String var1);

    public Flux<AmqpEndpointState> getEndpointStates();

    public Flux<AmqpShutdownSignal> getShutdownSignals();

    default public Mono<AmqpManagementNode> getManagementNode(String entityPath) {
        return Mono.error((Throwable)new UnsupportedOperationException("This has not been implemented."));
    }

    default public Mono<Void> closeAsync() {
        return Mono.fromRunnable(() -> ((AmqpConnection)this).dispose());
    }
}

