/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationPropertyBuilder;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

public class ProxyOptions
implements AutoCloseable {
    public static final String PROXY_USERNAME = "PROXY_USERNAME";
    public static final String PROXY_PASSWORD = "PROXY_PASSWORD";
    public static final String PROXY_AUTHENTICATION_TYPE = "PROXY_AUTHENTICATION_TYPE";
    private static final ConfigurationProperty<ProxyAuthenticationType> AUTH_TYPE_PROPERTY = new ConfigurationPropertyBuilder("amqp.proxy.authentication-type", s -> ProxyAuthenticationType.valueOf(s)).shared(true).logValue(true).defaultValue((Object)ProxyAuthenticationType.NONE).build();
    private static final ConfigurationProperty<Proxy.Type> TYPE_PROPERTY = new ConfigurationPropertyBuilder("amqp.proxy.type", s -> Proxy.Type.valueOf(s)).shared(true).logValue(true).defaultValue((Object)Proxy.Type.HTTP).build();
    private static final ConfigurationProperty<String> HOST_PROPERTY = ConfigurationPropertyBuilder.ofString((String)"amqp.proxy.hostname").shared(true).logValue(true).build();
    private static final ConfigurationProperty<Integer> PORT_PROPERTY = ConfigurationPropertyBuilder.ofInteger((String)"amqp.proxy.port").shared(true).required(true).build();
    private static final ConfigurationProperty<String> USER_PROPERTY = ConfigurationPropertyBuilder.ofString((String)"amqp.proxy.username").shared(true).logValue(true).build();
    private static final ConfigurationProperty<String> PASSWORD_PROPERTY = ConfigurationPropertyBuilder.ofString((String)"amqp.proxy.password").shared(true).build();
    private static final ClientLogger LOGGER = new ClientLogger(ProxyOptions.class);
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile("^[^:]+:\\d+");
    private final PasswordAuthentication credentials;
    private final Proxy proxyAddress;
    private final ProxyAuthenticationType authentication;
    public static final ProxyOptions SYSTEM_DEFAULTS = new ProxyOptions();

    private ProxyOptions() {
        this.credentials = null;
        this.proxyAddress = null;
        this.authentication = ProxyAuthenticationType.NONE;
    }

    public ProxyOptions(ProxyAuthenticationType authentication, Proxy proxyAddress, String username, String password) {
        this.authentication = Objects.requireNonNull(authentication, "'authentication' cannot be null.");
        this.proxyAddress = proxyAddress;
        if (username != null && password != null) {
            this.credentials = new PasswordAuthentication(username, password.toCharArray());
        } else {
            LOGGER.info("Username or password is null. Using system-wide authentication.");
            this.credentials = null;
        }
    }

    public static ProxyOptions fromConfiguration(Configuration configuration) {
        if (configuration == Configuration.NONE) {
            return SYSTEM_DEFAULTS;
        }
        String host = (String)(configuration = configuration == null ? Configuration.getGlobalConfiguration() : configuration).get(HOST_PROPERTY);
        if (CoreUtils.isNullOrEmpty((CharSequence)host)) {
            return ProxyOptions.loadFromEnvironmentConfiguration(configuration);
        }
        int port = (Integer)configuration.get(PORT_PROPERTY);
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        Proxy.Type proxyType = (Proxy.Type)((Object)configuration.get(TYPE_PROPERTY));
        ProxyAuthenticationType authType = (ProxyAuthenticationType)((Object)configuration.get(AUTH_TYPE_PROPERTY));
        String username = (String)configuration.get(USER_PROPERTY);
        String password = (String)configuration.get(PASSWORD_PROPERTY);
        return new ProxyOptions(authType, new Proxy(proxyType, socketAddress), username, password);
    }

    public ProxyAuthenticationType getAuthentication() {
        return this.authentication;
    }

    public Proxy getProxyAddress() {
        return this.proxyAddress;
    }

    public PasswordAuthentication getCredential() {
        return this.credentials;
    }

    public boolean hasUserDefinedCredentials() {
        return this.credentials != null;
    }

    public boolean isProxyAddressConfigured() {
        return this.proxyAddress != null && this.proxyAddress.address() != null;
    }

    @Override
    public void close() {
        if (this.credentials != null) {
            Arrays.fill(this.credentials.getPassword(), '\u0000');
        }
    }

    private static ProxyOptions loadFromEnvironmentConfiguration(Configuration configuration) {
        com.azure.core.http.ProxyOptions httpProxyOptions;
        ProxyAuthenticationType authentication;
        String proxyAddress = configuration.get("HTTP_PROXY");
        if (CoreUtils.isNullOrEmpty((CharSequence)proxyAddress)) {
            return SYSTEM_DEFAULTS;
        }
        String authTypeStr = configuration.get(PROXY_AUTHENTICATION_TYPE);
        ProxyAuthenticationType proxyAuthenticationType = authentication = authTypeStr != null ? ProxyAuthenticationType.valueOf(authTypeStr) : ProxyAuthenticationType.NONE;
        if (HOST_PORT_PATTERN.matcher(proxyAddress.trim()).find()) {
            String[] hostPort = proxyAddress.split(":");
            String host = hostPort[0];
            int port = Integer.parseInt(hostPort[1]);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            String username = configuration.get(PROXY_USERNAME);
            String password = configuration.get(PROXY_PASSWORD);
            return new ProxyOptions(authentication, proxy, username, password);
        }
        if (Boolean.parseBoolean(configuration.get("java.net.useSystemProxies")) && (httpProxyOptions = com.azure.core.http.ProxyOptions.fromConfiguration((Configuration)configuration)) != null) {
            return new ProxyOptions(authentication, new Proxy(httpProxyOptions.getType().toProxyType(), httpProxyOptions.getAddress()), httpProxyOptions.getUsername(), httpProxyOptions.getPassword());
        }
        LOGGER.verbose("'HTTP_PROXY' was configured but ignored as 'java.net.useSystemProxies' wasn't set or was false.");
        return SYSTEM_DEFAULTS;
    }

    private static class ConfigurationProperties {
        public static final String AMQP_PROXY_AUTHENTICATION_TYPE = "amqp.proxy.authentication-type";
        public static final String AMQP_PROXY_TYPE = "amqp.proxy.type";
        public static final String AMQP_PROXY_HOST = "amqp.proxy.hostname";
        public static final String AMQP_PROXY_PORT = "amqp.proxy.port";
        public static final String AMQP_PROXY_USER = "amqp.proxy.username";
        public static final String AMQP_PROXY_PASSWORD = "amqp.proxy.password";

        private ConfigurationProperties() {
        }
    }
}

