/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ReceiversPumpingScheduler
implements Scheduler {
    private static final ClientLogger LOGGER = new ClientLogger(ReceiversPumpingScheduler.class);
    private static final String NAME = "receiverPump";
    private static final int TASK_QUEUE_CAP = 100000;
    private static final int IDLE_TTL_SECONDS = 60;
    private static final AtomicReference<ReceiversPumpingScheduler> INSTANCE = new AtomicReference();
    private final Scheduler inner;

    public static Scheduler instance() {
        if (ReceiversPumpingScheduler.isVTSchedulerMode()) {
            return Schedulers.boundedElastic();
        }
        ReceiversPumpingScheduler scheduler = INSTANCE.get();
        if (scheduler != null) {
            return scheduler;
        }
        scheduler = new ReceiversPumpingScheduler();
        if (!INSTANCE.compareAndSet(null, scheduler)) {
            scheduler.inner.dispose();
        }
        return INSTANCE.get();
    }

    public Disposable schedule(Runnable task) {
        return this.inner.schedule(task);
    }

    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        return this.inner.schedule(task, delay, unit);
    }

    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.inner.schedulePeriodically(task, initialDelay, period, unit);
    }

    public Scheduler.Worker createWorker() {
        return this.inner.createWorker();
    }

    public long now(TimeUnit unit) {
        return this.inner.now(unit);
    }

    @Deprecated
    public void start() {
        this.inner.start();
    }

    public void init() {
        this.inner.init();
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return this.inner.isDisposed();
    }

    public String toString() {
        return NAME;
    }

    private ReceiversPumpingScheduler() {
        Supplier<Integer> poolMaxSizeDefault = () -> 20 * Runtime.getRuntime().availableProcessors();
        Optional<Integer> poolMaxSizeOverridden = Optional.ofNullable(System.getProperty("com.azure.core.amqp.receiversPumpingThreadPoolMaxSize")).map(m -> {
            try {
                return Integer.parseInt(m);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        });
        int poolMaxSize = poolMaxSizeOverridden.orElseGet(poolMaxSizeDefault);
        this.inner = Schedulers.newBoundedElastic((int)poolMaxSize, (int)100000, (String)NAME, (int)60, (boolean)true);
        LOGGER.atVerbose().addKeyValue("maxThreads", (long)poolMaxSize).log("Initialized common thread pool for receivers pumping.");
    }

    private static boolean isVTSchedulerMode() {
        Scheduler s = Schedulers.boundedElastic();
        if (s instanceof Supplier && ((Supplier)s).get() instanceof Scheduler) {
            return ((Supplier)s).get().getClass().getSimpleName().equals("VirtualTimeScheduler");
        }
        LOGGER.atVerbose().log("Can't perform VTScheduler check.");
        return false;
    }
}

