/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.AmqpMetricsProvider;
import com.azure.core.amqp.implementation.TimeoutTracker;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Sender;
import reactor.core.publisher.MonoSink;

class RetriableWorkItem {
    private final AtomicInteger retryAttempts = new AtomicInteger();
    private final MonoSink<DeliveryState> monoSink;
    private final TimeoutTracker timeoutTracker;
    private final ReadableBuffer encodedBuffer;
    private final byte[] encodedBytes;
    private final int messageFormat;
    private final int encodedMessageSize;
    private final DeliveryState deliveryState;
    private boolean waitingForAck;
    private Exception lastKnownException;
    private final AmqpMetricsProvider metricsProvider;
    private long tryStartTime = 0L;

    RetriableWorkItem(ReadableBuffer buffer, int messageFormat, MonoSink<DeliveryState> monoSink, Duration timeout, DeliveryState deliveryState, AmqpMetricsProvider metricsProvider) {
        this.encodedBuffer = buffer;
        this.encodedBytes = null;
        this.encodedMessageSize = buffer.remaining();
        this.messageFormat = messageFormat;
        this.monoSink = monoSink;
        this.timeoutTracker = new TimeoutTracker(timeout, false);
        this.deliveryState = deliveryState;
        this.metricsProvider = metricsProvider;
    }

    RetriableWorkItem(byte[] bytes, int encodedMessageSize, int messageFormat, MonoSink<DeliveryState> monoSink, Duration timeout, DeliveryState deliveryState, AmqpMetricsProvider metricsProvider) {
        this.encodedBytes = bytes;
        this.encodedBuffer = null;
        this.encodedMessageSize = encodedMessageSize;
        this.messageFormat = messageFormat;
        this.monoSink = monoSink;
        this.timeoutTracker = new TimeoutTracker(timeout, false);
        this.deliveryState = deliveryState;
        this.metricsProvider = metricsProvider;
    }

    DeliveryState getDeliveryState() {
        return this.deliveryState;
    }

    boolean isDeliveryStateProvided() {
        return this.deliveryState != null;
    }

    TimeoutTracker getTimeoutTracker() {
        return this.timeoutTracker;
    }

    void success(DeliveryState deliveryState) {
        this.reportMetrics(deliveryState);
        this.monoSink.success((Object)deliveryState);
    }

    void error(Throwable error, DeliveryState deliveryState) {
        this.reportMetrics(deliveryState);
        this.monoSink.error(error);
    }

    int incrementRetryAttempts() {
        return this.retryAttempts.incrementAndGet();
    }

    void beforeTry() {
        if (this.metricsProvider.isSendDeliveryEnabled()) {
            this.tryStartTime = Instant.now().toEpochMilli();
        }
    }

    boolean hasBeenRetried() {
        return this.retryAttempts.get() == 0;
    }

    int getEncodedMessageSize() {
        return this.encodedMessageSize;
    }

    int getMessageFormat() {
        return this.messageFormat;
    }

    Exception getLastKnownException() {
        return this.lastKnownException;
    }

    void setLastKnownException(Exception exception) {
        this.lastKnownException = exception;
    }

    void setWaitingForAck() {
        this.waitingForAck = true;
    }

    boolean isWaitingForAck() {
        return this.waitingForAck;
    }

    void send(Sender sender) {
        int sentMsgSize;
        if (this.encodedBytes != null) {
            sentMsgSize = sender.send(this.encodedBytes, 0, this.encodedMessageSize);
        } else {
            this.encodedBuffer.rewind();
            sentMsgSize = sender.send(this.encodedBuffer);
        }
        assert (sentMsgSize == this.encodedMessageSize) : "Contract of the ProtonJ library for Sender. Send API changed";
    }

    private void reportMetrics(DeliveryState deliveryState) {
        if (this.metricsProvider.isSendDeliveryEnabled()) {
            this.metricsProvider.recordSend(this.tryStartTime, deliveryState == null ? null : deliveryState.getType());
        }
    }
}

