/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.polling;

import com.azure.core.http.HttpHeaders;
import java.util.Objects;

public final class PollResult<T> {
    private final T value;
    private final Error error;

    public PollResult(T value) {
        this.value = value;
        this.error = null;
    }

    public PollResult(Error error) {
        this.error = error;
        this.value = null;
    }

    public T getValue() {
        return this.value;
    }

    public Error getError() {
        return this.error;
    }

    public static class Error {
        private final String message;
        private final int responseStatusCode;
        private final String responseBody;
        private final HttpHeaders responseHeaders;

        public Error(String message, int responseStatusCode, HttpHeaders responseHeaders, String responseBody) {
            this.message = Objects.requireNonNull(message, "'message' cannot be null.");
            this.responseStatusCode = responseStatusCode;
            this.responseBody = responseBody;
            this.responseHeaders = responseHeaders;
        }

        public String getMessage() {
            return this.message;
        }

        public int getResponseStatusCode() {
            return this.responseStatusCode;
        }

        public String getResponseBody() {
            return this.responseBody;
        }

        public HttpHeaders getResponseHeaders() {
            return this.responseHeaders;
        }
    }
}

