/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBodyContentImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBodyContentImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBodyContentImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBodyContentImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLinkImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleActionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementError;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionImpl;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class AdministrationModelConverter {
    static final String CONTENT_TYPE = "application/xml";
    private final ClientLogger logger;
    private final String serviceBusNamespace;
    private final ServiceBusManagementSerializer serializer;

    AdministrationModelConverter(ClientLogger logger, String serviceBusNamespace, ServiceBusManagementSerializer serializer) {
        this.logger = logger;
        this.serviceBusNamespace = serviceBusNamespace;
        this.serializer = serializer;
    }

    void addSupplementaryAuthHeader(HttpHeaderName headerName, String entity, Context context) {
        context.getData((Object)"azure-http-headers-key").ifPresent(headers -> {
            if (headers instanceof HttpHeaders) {
                HttpHeaders customHttpHeaders = (HttpHeaders)headers;
                customHttpHeaders.add(headerName, entity);
            }
        });
    }

    CreateQueueBodyImpl getCreateQueueBody(QueueDescriptionImpl queueDescription) {
        CreateQueueBodyContentImpl content = new CreateQueueBodyContentImpl().setType(CONTENT_TYPE).setQueueDescription(queueDescription);
        return new CreateQueueBodyImpl().setContent(content);
    }

    CreateQueueBodyImpl getCreateQueueBody(CreateQueueOptions createQueueOptions, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(createQueueOptions.getForwardTo(), context);
        if (forwardTo != null) {
            createQueueOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(createQueueOptions.getForwardDeadLetteredMessagesTo(), context)) != null) {
            createQueueOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        return this.getCreateQueueBody(EntityHelper.getQueueDescription(createQueueOptions));
    }

    CreateRuleBodyImpl getCreateRuleBody(String ruleName, CreateRuleOptions ruleOptions) {
        RuleActionImpl action = ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null;
        RuleFilterImpl filter = ruleOptions.getFilter() != null ? EntityHelper.toImplementation(ruleOptions.getFilter()) : null;
        RuleDescriptionImpl rule = new RuleDescriptionImpl().setAction(action).setFilter(filter).setName(ruleName);
        CreateRuleBodyContentImpl content = new CreateRuleBodyContentImpl().setType(CONTENT_TYPE).setRuleDescription(rule);
        return new CreateRuleBodyImpl().setContent(content);
    }

    CreateSubscriptionBodyImpl getCreateSubscriptionBody(SubscriptionDescriptionImpl subscriptionDescription) {
        CreateSubscriptionBodyContentImpl content = new CreateSubscriptionBodyContentImpl().setType(CONTENT_TYPE).setSubscriptionDescription(subscriptionDescription);
        return new CreateSubscriptionBodyImpl().setContent(content);
    }

    CreateSubscriptionBodyImpl getCreateSubscriptionBody(CreateSubscriptionOptions subscriptionOptions, String ruleName, CreateRuleOptions ruleOptions, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(subscriptionOptions.getForwardTo(), context);
        if (forwardTo != null) {
            subscriptionOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscriptionOptions.getForwardDeadLetteredMessagesTo(), context)) != null) {
            subscriptionOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        if (ruleOptions != null) {
            if (ruleOptions.getFilter() == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'RuleFilter' cannot be null."));
            }
            RuleDescriptionImpl rule = new RuleDescriptionImpl().setAction(ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null).setFilter(EntityHelper.toImplementation(ruleOptions.getFilter())).setName(ruleName);
            subscriptionOptions.setDefaultRule(EntityHelper.toModel(rule));
        }
        return this.getCreateSubscriptionBody(EntityHelper.getSubscriptionDescription(subscriptionOptions));
    }

    CreateTopicBodyImpl getCreateTopicBody(TopicDescriptionImpl topicOptions) {
        CreateTopicBodyContentImpl content = new CreateTopicBodyContentImpl().setType(CONTENT_TYPE).setTopicDescription(topicOptions);
        return new CreateTopicBodyImpl().setContent(content);
    }

    CreateQueueBodyImpl getUpdateQueueBody(QueueProperties queue, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(queue.getForwardTo(), context);
        if (forwardTo != null) {
            queue.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(queue.getForwardDeadLetteredMessagesTo(), context)) != null) {
            queue.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        return this.getCreateQueueBody(EntityHelper.toImplementation(queue));
    }

    CreateRuleBodyImpl getUpdateRuleBody(RuleProperties rule) {
        RuleDescriptionImpl implementation = EntityHelper.toImplementation(rule);
        CreateRuleBodyContentImpl content = new CreateRuleBodyContentImpl().setType(CONTENT_TYPE).setRuleDescription(implementation);
        return new CreateRuleBodyImpl().setContent(content);
    }

    CreateSubscriptionBodyImpl getUpdateSubscriptionBody(SubscriptionProperties subscription, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(subscription.getForwardTo(), context);
        if (forwardTo != null) {
            subscription.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscription.getForwardDeadLetteredMessagesTo(), context)) != null) {
            subscription.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        return this.getCreateSubscriptionBody(EntityHelper.toImplementation(subscription));
    }

    CreateTopicBodyImpl getUpdateTopicBody(TopicProperties topic) {
        TopicDescriptionImpl implementation = EntityHelper.toImplementation(topic);
        CreateTopicBodyContentImpl content = new CreateTopicBodyContentImpl().setType(CONTENT_TYPE).setTopicDescription(implementation);
        return new CreateTopicBodyImpl().setContent(content);
    }

    List<TopicProperties> getTopics(TopicDescriptionFeedImpl feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getTopicDescription() != null).map(e -> this.getTopicProperties((TopicDescriptionEntryImpl)e)).collect(Collectors.toList());
    }

    List<QueueProperties> getQueues(QueueDescriptionFeedImpl feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getQueueDescription() != null).map(e -> this.getQueueProperties((QueueDescriptionEntryImpl)e)).collect(Collectors.toList());
    }

    List<RuleProperties> getRules(RuleDescriptionFeedImpl feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getRuleDescription() != null).map(e -> EntityHelper.toModel(e.getContent().getRuleDescription())).collect(Collectors.toList());
    }

    List<SubscriptionProperties> getSubscriptions(String topicName, SubscriptionDescriptionFeedImpl feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getSubscriptionDescription() != null).map(e -> this.getSubscriptionProperties(topicName, (SubscriptionDescriptionEntryImpl)e)).collect(Collectors.toList());
    }

    QueueProperties getQueueProperties(QueueDescriptionEntryImpl e) {
        String queueName = e.getTitle().getContent();
        QueueProperties queueProperties = EntityHelper.toModel(e.getContent().getQueueDescription());
        EntityHelper.setQueueName(queueProperties, queueName);
        return queueProperties;
    }

    SubscriptionProperties getSubscriptionProperties(String topicName, SubscriptionDescriptionEntryImpl entry) {
        SubscriptionProperties subscription = EntityHelper.toModel(entry.getContent().getSubscriptionDescription());
        String subscriptionName = entry.getTitle().getContent();
        EntityHelper.setSubscriptionName(subscription, subscriptionName);
        EntityHelper.setTopicName(subscription, topicName);
        return subscription;
    }

    TopicProperties getTopicProperties(TopicDescriptionEntryImpl entry) {
        TopicProperties result = EntityHelper.toModel(entry.getContent().getTopicDescription());
        String topicName = entry.getTitle().getContent();
        EntityHelper.setTopicName(result, topicName);
        return result;
    }

    SimpleResponse<SubscriptionProperties> getSubscriptionPropertiesSimpleResponse(String topicName, Response<SubscriptionDescriptionEntryImpl> response) {
        SubscriptionDescriptionEntryImpl entry = (SubscriptionDescriptionEntryImpl)response.getValue();
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        SubscriptionProperties subscription = this.getSubscriptionProperties(topicName, entry);
        String subscriptionName = entry.getTitle().getContent();
        EntityHelper.setSubscriptionName(subscription, subscriptionName);
        EntityHelper.setTopicName(subscription, topicName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)subscription);
    }

    SimpleResponse<RuleProperties> getRulePropertiesSimpleResponse(Response<RuleDescriptionEntryImpl> response) {
        RuleDescriptionEntryImpl entry = (RuleDescriptionEntryImpl)response.getValue();
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        RuleDescriptionImpl description = entry.getContent().getRuleDescription();
        RuleProperties result = EntityHelper.toModel(description);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    void validateQueueName(String queueName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)queueName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'queueName' cannot be null or empty."));
        }
    }

    void validateRuleName(String ruleName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)ruleName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'ruleName' cannot be null or empty."));
        }
    }

    void validateTopicName(String topicName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
    }

    void validateSubscriptionName(String subscriptionName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
    }

    <T> Response<T> deserialize(Response<Object> response, Class<T> clazz) {
        T deserialize = this.deserialize(response.getValue(), clazz);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), deserialize);
    }

    private <T> T deserialize(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        String contents = String.valueOf(object);
        if (contents.isEmpty()) {
            return null;
        }
        try {
            return this.serializer.deserialize(contents, clazz);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Exception while deserializing. Body: [%s]. Class: %s", contents, clazz), e));
        }
    }

    Response<QueueProperties> deserializeQueue(Response<Object> response) {
        TopicDescriptionEntryImpl entryTopic;
        QueueDescriptionEntryImpl entry = this.deserialize(response.getValue(), QueueDescriptionEntryImpl.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getQueueDescription() == null && (entryTopic = this.deserialize(response.getValue(), TopicDescriptionEntryImpl.class)) != null && entryTopic.getContent() != null && entryTopic.getContent().getTopicDescription() != null) {
            this.logger.warning("'{}' is not a queue, it is a topic.", new Object[]{entryTopic.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        QueueProperties result = this.getQueueProperties(entry);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    Response<TopicProperties> deserializeTopic(Response<Object> response) {
        QueueDescriptionEntryImpl entryQueue;
        TopicDescriptionEntryImpl entry = this.deserialize(response.getValue(), TopicDescriptionEntryImpl.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getTopicDescription() == null && (entryQueue = this.deserialize(response.getValue(), QueueDescriptionEntryImpl.class)) != null && entryQueue.getContent() != null && entryQueue.getContent().getQueueDescription() != null) {
            this.logger.warning("'{}' is not a topic, it is a queue.", new Object[]{entryQueue.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        TopicProperties result = this.getTopicProperties(entry);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    Context getContext(Context context) {
        context = context == null ? Context.NONE : context;
        return context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
    }

    String getAbsoluteUrlFromEntity(String entity) {
        try {
            URL url = new URL(entity);
            return url.toString();
        }
        catch (MalformedURLException url) {
            UrlBuilder urlBuilder = new UrlBuilder();
            urlBuilder.setScheme("https");
            urlBuilder.setHost(this.serviceBusNamespace);
            urlBuilder.setPath(entity);
            try {
                URL url2 = urlBuilder.toUrl();
                return url2.toString();
            }
            catch (MalformedURLException ex) {
                this.logger.error("Failed to construct URL using the endpoint:'{}' and entity:'{}'", new Object[]{this.serviceBusNamespace, entity});
                this.logger.logThrowableAsError((Throwable)ex);
                return null;
            }
        }
    }

    private String getForwardDlqEntity(String forwardDlqToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardDlqToEntity)) {
            this.addSupplementaryAuthHeader(ServiceBusConstants.SERVICE_BUS_DLQ_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME, forwardDlqToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardDlqToEntity);
        }
        return null;
    }

    private String getForwardToEntity(String forwardToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            this.addSupplementaryAuthHeader(ServiceBusConstants.SERVICE_BUS_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME, forwardToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardToEntity);
        }
        return null;
    }

    static Throwable mapException(Throwable exception) {
        if (!(exception instanceof ServiceBusManagementErrorException)) {
            return exception;
        }
        return AdministrationModelConverter.mapException((ServiceBusManagementErrorException)((Object)exception));
    }

    static RuntimeException mapException(ServiceBusManagementErrorException exception) {
        ServiceBusManagementError error = exception.getValue();
        HttpResponse errorHttpResponse = exception.getResponse();
        int statusCode = error != null && error.getCode() != null ? error.getCode().intValue() : errorHttpResponse.getStatusCode();
        String errorDetail = error != null && error.getDetail() != null ? error.getDetail() : exception.getMessage();
        switch (statusCode) {
            case 401: {
                return new ClientAuthenticationException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
            case 404: {
                return new ResourceNotFoundException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
            case 409: {
                return new ResourceExistsException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
            case 412: {
                return new ResourceModifiedException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
        }
        return new HttpResponseException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
    }

    <TResult, TFeed> FeedPage<TResult> extractPage(Response<TFeed> response, List<TResult> entities, List<ResponseLinkImpl> responseLinks) throws MalformedURLException, UnsupportedEncodingException {
        Optional<ResponseLinkImpl> nextLink = responseLinks.stream().filter(link -> link.getRel().equalsIgnoreCase("next")).findFirst();
        if (!nextLink.isPresent()) {
            return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
        }
        URL url = new URL(nextLink.get().getHref());
        String decode = URLDecoder.decode(url.getQuery(), StandardCharsets.UTF_8.toString());
        Optional<Integer> skipParameter = Arrays.stream(decode.split("&amp;|&")).map(part -> part.split("=", 2)).filter(parts -> parts[0].equalsIgnoreCase("$skip") && ((String[])parts).length == 2).map(parts -> Integer.valueOf(parts[1])).findFirst();
        if (skipParameter.isPresent()) {
            return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities, skipParameter.get());
        }
        this.logger.warning("There should have been a skip parameter for the next page.");
        return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
    }

    static final class FeedPage<T>
    implements PagedResponse<T> {
        private final int statusCode;
        private final HttpHeaders header;
        private final HttpRequest request;
        private final IterableStream<T> entries;
        private final String continuationToken;

        FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = null;
        }

        FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries, int skip) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = String.valueOf(skip);
        }

        public IterableStream<T> getElements() {
            return this.entries;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public HttpHeaders getHeaders() {
            return this.header;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void close() {
        }
    }

    static final class EntityNotFoundHttpResponse<T>
    extends HttpResponse {
        private final int statusCode;
        private final HttpHeaders headers;

        EntityNotFoundHttpResponse(Response<T> response) {
            super(response.getRequest());
            this.headers = response.getHeaders();
            this.statusCode = response.getStatusCode();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String name) {
            return this.headers.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.empty();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.empty();
        }
    }
}

