/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBodyImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceBusManagementSerializer
implements SerializerAdapter {
    private static final String MINIMUM_DATETIME_FORMATTED = ">0001-01-01T00:00:00Z</";
    private static final Pattern MINIMUM_DATETIME_PATTERN = Pattern.compile(">0001-01-01T00:00:00</", 8);
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("xmlns:(?<namespace>\\w+)=\"http://schemas\\.microsoft\\.com/netservices/2010/10/servicebus/connect\"", 8);
    private static final Pattern FILTER_ACTION_PATTERN = Pattern.compile("<(Filter|Action) type=", 8);
    private static final Pattern FILTER_VALUE_PATTERN = Pattern.compile("<(Value)", 8);
    private static final String RULE_VALUE_ATTRIBUTE_XML = "<$1 xmlns:d6p1=\"http://www.w3.org/2001/XMLSchema\" ns0:type=\"d6p1:string\"";
    private static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusManagementSerializer.class);

    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        Matcher filterType;
        String contents = SERIALIZER_ADAPTER.serialize(object, encoding);
        Class<?> clazz = object.getClass();
        if (!(CreateQueueBodyImpl.class.equals(clazz) || CreateRuleBodyImpl.class.equals(clazz) || CreateSubscriptionBodyImpl.class.equals(clazz) || CreateTopicBodyImpl.class.equals(clazz))) {
            return contents;
        }
        Matcher namespaceMatcher = NAMESPACE_PATTERN.matcher(contents);
        if (!namespaceMatcher.find()) {
            LOGGER.warning("Could not find {} in {}", new Object[]{NAMESPACE_PATTERN.pattern(), contents});
            return contents;
        }
        String namespace = namespaceMatcher.group("namespace");
        String replaced = contents.replaceAll(namespace + ":", "").replace("xmlns:" + namespace + "=", "xmlns=");
        if (!CreateRuleBodyImpl.class.equals(clazz) && !CreateSubscriptionBodyImpl.class.equals(clazz)) {
            return replaced;
        }
        if (CreateRuleBodyImpl.class.equals(clazz)) {
            Matcher filterValue = FILTER_VALUE_PATTERN.matcher(replaced);
            if (filterValue.find()) {
                replaced = filterValue.replaceAll(RULE_VALUE_ATTRIBUTE_XML);
            } else {
                LOGGER.warning("Could not find filter name pattern '{}' in {}.", new Object[]{FILTER_VALUE_PATTERN.pattern(), contents});
            }
        }
        if ((filterType = FILTER_ACTION_PATTERN.matcher(replaced)).find()) {
            return filterType.replaceAll("<$1 xmlns:ns0=\"http://www.w3.org/2001/XMLSchema-instance\" ns0:type=");
        }
        LOGGER.warning("Could not find filter name pattern '{}' in {}.", new Object[]{FILTER_ACTION_PATTERN.pattern(), contents});
        return replaced;
    }

    public String serializeRaw(Object object) {
        return SERIALIZER_ADAPTER.serializeRaw(object);
    }

    public String serializeList(List<?> list, CollectionFormat format) {
        return SERIALIZER_ADAPTER.serializeList(list, format);
    }

    public <T> T deserialize(String value, Type type) throws IOException {
        String serializedString;
        Matcher matcher = MINIMUM_DATETIME_PATTERN.matcher(value);
        if (matcher.find(0)) {
            LOGGER.verbose("Found instances of '{}' to replace. Value: {}", new Object[]{MINIMUM_DATETIME_PATTERN.pattern(), value});
            serializedString = matcher.replaceAll(MINIMUM_DATETIME_FORMATTED);
        } else {
            serializedString = value;
        }
        return (T)SERIALIZER_ADAPTER.deserialize(serializedString, type, SerializerEncoding.XML);
    }

    public <T> T deserialize(String value, Type type, SerializerEncoding encoding) throws IOException {
        if (encoding != SerializerEncoding.XML) {
            return (T)SERIALIZER_ADAPTER.deserialize(value, type, encoding);
        }
        if (Object.class == type) {
            return (T)value;
        }
        return this.deserialize(value, type);
    }

    public <T> T deserialize(HttpHeaders headers, Type type) throws IOException {
        return (T)SERIALIZER_ADAPTER.deserialize(headers, type);
    }
}

