/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.EntityAvailabilityStatusImpl;
import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetailsImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionImpl;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class SubscriptionProperties {
    private final SubscriptionDescriptionImpl description;
    private String topicName;
    private String subscriptionName;

    SubscriptionProperties(SubscriptionDescriptionImpl description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        this.description = description;
    }

    public String getTopicName() {
        return this.topicName;
    }

    SubscriptionProperties setTopicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    SubscriptionProperties setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
        return this;
    }

    public Duration getLockDuration() {
        return this.description.getLockDuration();
    }

    public SubscriptionProperties setLockDuration(Duration lockDuration) {
        this.description.setLockDuration(lockDuration);
        return this;
    }

    public boolean isSessionRequired() {
        return MessageUtils.toPrimitive(this.description.isRequiresSession());
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.description.getDefaultMessageTimeToLive();
    }

    public SubscriptionProperties setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.description.setDefaultMessageTimeToLive(defaultMessageTimeToLive);
        return this;
    }

    public boolean isDeadLetteringOnMessageExpiration() {
        return MessageUtils.toPrimitive(this.description.isDeadLetteringOnMessageExpiration());
    }

    public SubscriptionProperties setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
        this.description.setDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpiration);
        return this;
    }

    public boolean isDeadLetteringOnFilterEvaluationExceptions() {
        return MessageUtils.toPrimitive(this.description.isDeadLetteringOnFilterEvaluationExceptions());
    }

    public SubscriptionProperties setEnableDeadLetteringOnFilterEvaluationExceptions(boolean deadLetteringOnFilterEvaluationExceptions) {
        this.description.setDeadLetteringOnFilterEvaluationExceptions(deadLetteringOnFilterEvaluationExceptions);
        return this;
    }

    int getMessageCount() {
        return MessageUtils.toPrimitive(this.description.getMessageCount());
    }

    SubscriptionProperties setMessageCount(int messageCount) {
        this.description.setMessageCount(messageCount);
        return this;
    }

    public int getMaxDeliveryCount() {
        return MessageUtils.toPrimitive(this.description.getMaxDeliveryCount());
    }

    public SubscriptionProperties setMaxDeliveryCount(int maxDeliveryCount) {
        this.description.setMaxDeliveryCount(maxDeliveryCount);
        return this;
    }

    public boolean isBatchedOperationsEnabled() {
        return MessageUtils.toPrimitive(this.description.isEnableBatchedOperations());
    }

    public SubscriptionProperties setBatchedOperationsEnabled(boolean enableBatchedOperations) {
        this.description.setEnableBatchedOperations(enableBatchedOperations);
        return this;
    }

    public EntityStatus getStatus() {
        return this.description.getStatus();
    }

    public SubscriptionProperties setStatus(EntityStatus status) {
        this.description.setStatus(status);
        return this;
    }

    public String getForwardTo() {
        return this.description.getForwardTo();
    }

    public SubscriptionProperties setForwardTo(String forwardTo) {
        this.description.setForwardTo(forwardTo);
        return this;
    }

    OffsetDateTime getCreatedAt() {
        return this.description.getCreatedAt();
    }

    OffsetDateTime getUpdatedAt() {
        return this.description.getUpdatedAt();
    }

    OffsetDateTime getAccessedAt() {
        return this.description.getAccessedAt();
    }

    MessageCountDetailsImpl getMessageCountDetails() {
        return this.description.getMessageCountDetails();
    }

    public String getUserMetadata() {
        return this.description.getUserMetadata();
    }

    public SubscriptionProperties setUserMetadata(String userMetadata) {
        this.description.setUserMetadata(userMetadata);
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.description.getForwardDeadLetteredMessagesTo();
    }

    public SubscriptionProperties setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.description.setForwardDeadLetteredMessagesTo(forwardDeadLetteredMessagesTo);
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.description.getAutoDeleteOnIdle();
    }

    public SubscriptionProperties setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.description.setAutoDeleteOnIdle(autoDeleteOnIdle);
        return this;
    }

    EntityAvailabilityStatusImpl getEntityAvailabilityStatus() {
        return this.description.getEntityAvailabilityStatus();
    }

    static {
        EntityHelper.setSubscriptionAccessor(new EntityHelper.SubscriptionAccessor(){

            @Override
            public SubscriptionProperties toModel(SubscriptionDescriptionImpl description) {
                return new SubscriptionProperties(description);
            }

            @Override
            public SubscriptionDescriptionImpl toImplementation(SubscriptionProperties subscription) {
                return subscription.description;
            }

            @Override
            public void setTopicName(SubscriptionProperties subscriptionProperties, String topicName) {
                subscriptionProperties.setTopicName(topicName);
            }

            @Override
            public void setSubscriptionName(SubscriptionProperties subscriptionProperties, String subscriptionName) {
                subscriptionProperties.setSubscriptionName(subscriptionName);
            }
        });
    }
}

