/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation.instrumentation;

import com.azure.core.util.Context;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.DoubleHistogram;
import com.azure.core.util.metrics.LongCounter;
import com.azure.core.util.metrics.LongGauge;
import com.azure.core.util.metrics.Meter;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ServiceBusMeter {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusMeter.class);
    private static final String GENERIC_STATUS_KEY = "status";
    private static final int DISPOSITION_STATUSES_COUNT = DispositionStatus.values().length;
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private final boolean isEnabled;
    private final AtomicReference<CompositeSubscription> lastSeqNoSubscription = new AtomicReference<Object>(null);
    private TelemetryAttributes sendAttributesSuccess;
    private TelemetryAttributes sendAttributesFailure;
    private TelemetryAttributes sendAttributesCancelled;
    private TelemetryAttributes receiveAttributes;
    private TelemetryAttributes[] settleSuccessAttributes;
    private TelemetryAttributes[] settleFailureAttributes;
    private LongCounter sentMessagesCounter;
    private DoubleHistogram consumerLag;
    private DoubleHistogram settleMessageDuration;
    private LongGauge settledSequenceNumber;

    public ServiceBusMeter(Meter meter, String namespace, String entityPath, String subscriptionName) {
        boolean bl = this.isEnabled = meter != null && meter.isEnabled();
        if (this.isEnabled) {
            HashMap<String, String> commonAttributesMap = new HashMap<String, String>(3);
            commonAttributesMap.put("hostName", namespace);
            int entityNameEnd = entityPath.indexOf(47);
            if (entityNameEnd > 0) {
                commonAttributesMap.put("entityName", entityPath.substring(0, entityNameEnd));
            } else {
                commonAttributesMap.put("entityName", entityPath);
            }
            if (subscriptionName != null) {
                commonAttributesMap.put("subscriptionName", subscriptionName);
            }
            HashMap<String, String> successMap = new HashMap<String, String>(commonAttributesMap);
            successMap.put(GENERIC_STATUS_KEY, "ok");
            this.sendAttributesSuccess = meter.createAttributes(successMap);
            HashMap<String, String> failureMap = new HashMap<String, String>(commonAttributesMap);
            failureMap.put(GENERIC_STATUS_KEY, "error");
            this.sendAttributesFailure = meter.createAttributes(failureMap);
            HashMap<String, String> cancelMap = new HashMap<String, String>(commonAttributesMap);
            cancelMap.put(GENERIC_STATUS_KEY, "cancelled");
            this.sendAttributesCancelled = meter.createAttributes(cancelMap);
            this.settleSuccessAttributes = new TelemetryAttributes[DISPOSITION_STATUSES_COUNT];
            this.settleFailureAttributes = new TelemetryAttributes[DISPOSITION_STATUSES_COUNT];
            for (int i = 0; i < DISPOSITION_STATUSES_COUNT; ++i) {
                HashMap<String, String> successMapWithStatus = new HashMap<String, String>(successMap);
                successMapWithStatus.put("dispositionStatus", DispositionStatus.values()[i].getValue());
                this.settleSuccessAttributes[i] = meter.createAttributes(successMapWithStatus);
                HashMap<String, String> failureMapWithStatus = new HashMap<String, String>(failureMap);
                failureMapWithStatus.put("dispositionStatus", DispositionStatus.values()[i].getValue());
                this.settleFailureAttributes[i] = meter.createAttributes(failureMapWithStatus);
            }
            this.receiveAttributes = meter.createAttributes(commonAttributesMap);
            this.sentMessagesCounter = meter.createLongCounter("messaging.servicebus.messages.sent", "Number of sent messages", "messages");
            this.settleMessageDuration = meter.createDoubleHistogram("messaging.servicebus.settlement.request.duration", "Duration of settlement call.", "ms");
            this.consumerLag = meter.createDoubleHistogram("messaging.servicebus.receiver.lag", "Difference between local time when event was received and the local time it was enqueued on broker.", "sec");
            this.settledSequenceNumber = meter.createLongGauge("messaging.servicebus.settlement.sequence_number", "Last settled message sequence number", "seqNo");
        }
    }

    public boolean isBatchSendEnabled() {
        return this.isEnabled && this.sentMessagesCounter.isEnabled();
    }

    void reportBatchSend(int batchSize, Throwable throwable, boolean cancelled, Context context) {
        if (this.isEnabled && this.sentMessagesCounter.isEnabled()) {
            TelemetryAttributes attributes = this.sendAttributesSuccess;
            if (throwable != null) {
                attributes = this.sendAttributesFailure;
            } else if (cancelled) {
                attributes = this.sendAttributesCancelled;
            }
            this.sentMessagesCounter.add((long)batchSize, attributes, context);
        }
    }

    boolean isConsumerLagEnabled() {
        return this.isEnabled && this.consumerLag.isEnabled();
    }

    void reportConsumerLag(OffsetDateTime enqueuedTime, Context context) {
        if (this.isEnabled && this.consumerLag.isEnabled()) {
            double diff = 0.0;
            if (enqueuedTime != null && (diff = (double)(Instant.now().toEpochMilli() - enqueuedTime.toInstant().toEpochMilli())) < 0.0) {
                diff = 0.0;
            }
            this.consumerLag.record(diff / 1000.0, this.receiveAttributes, context);
        }
    }

    public boolean isSettlementEnabled() {
        return this.isEnabled && (this.settleMessageDuration.isEnabled() || this.settledSequenceNumber.isEnabled());
    }

    public void reportSettlement(long start, long seqNo, DispositionStatus status, Throwable throwable, boolean cancelled, Context context) {
        if (this.isEnabled) {
            if (this.settleMessageDuration.isEnabled()) {
                TelemetryAttributes attributes = throwable == null ? this.settleSuccessAttributes[status.ordinal()] : this.settleFailureAttributes[status.ordinal()];
                this.settleMessageDuration.record((double)(Instant.now().toEpochMilli() - start), attributes, context);
            }
            CompositeSubscription subs = this.lastSeqNoSubscription.get();
            if (this.settledSequenceNumber.isEnabled() && subs != null) {
                subs.set(seqNo, status, throwable == null && !cancelled);
            }
        }
    }

    AutoCloseable trackSettlementSequenceNumber() {
        if (!this.isEnabled || !this.settledSequenceNumber.isEnabled()) {
            return NOOP_CLOSEABLE;
        }
        CompositeSubscription existingSubscription = this.lastSeqNoSubscription.get();
        if (existingSubscription == null) {
            CompositeSubscription subs = new CompositeSubscription(this.settledSequenceNumber, this.settleSuccessAttributes, this.settleFailureAttributes);
            if (this.lastSeqNoSubscription.compareAndSet(null, subs)) {
                return subs;
            }
            subs.close();
        }
        LOGGER.warning("Sequence number subscription has been already created.");
        return existingSubscription;
    }

    private static class CompositeSubscription
    implements AutoCloseable {
        private final AtomicLong[] lastSeqNoSuccess = new AtomicLong[ServiceBusMeter.access$000()];
        private final AtomicLong[] lastSeqNoFailure = new AtomicLong[ServiceBusMeter.access$000()];
        private final AutoCloseable[] subscriptionsSuccess = new AutoCloseable[ServiceBusMeter.access$000()];
        private final AutoCloseable[] subscriptionsFailure = new AutoCloseable[ServiceBusMeter.access$000()];

        CompositeSubscription(LongGauge settledSequenceNumber, TelemetryAttributes[] settleSuccessAttributes, TelemetryAttributes[] settleFailureAttributes) {
            for (int i = 0; i < DISPOSITION_STATUSES_COUNT; ++i) {
                this.lastSeqNoSuccess[i] = new AtomicLong();
                this.lastSeqNoFailure[i] = new AtomicLong();
                int fi = i;
                this.subscriptionsSuccess[i] = settledSequenceNumber.registerCallback(() -> this.lastSeqNoSuccess[fi].get(), settleSuccessAttributes[i]);
                this.subscriptionsFailure[i] = settledSequenceNumber.registerCallback(() -> this.lastSeqNoFailure[fi].get(), settleFailureAttributes[i]);
            }
        }

        public void set(long value, DispositionStatus status, boolean success) {
            AtomicLong valueSetter = success ? this.lastSeqNoSuccess[status.ordinal()] : this.lastSeqNoFailure[status.ordinal()];
            valueSetter.set(value);
        }

        @Override
        public void close() {
            for (int i = 0; i < DISPOSITION_STATUSES_COUNT; ++i) {
                try {
                    this.subscriptionsSuccess[i].close();
                    this.subscriptionsFailure[i].close();
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.info("Unable to close settlement sequence number subscription.", new Object[]{ex});
                }
            }
        }
    }
}

