// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * RuleDescription for the new Rule.
 */
@Fluent
public final class CreateRuleBodyContentImpl implements XmlSerializable<CreateRuleBodyContentImpl> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * MIME type of content.
     */
    private String type;

    /*
     * Rule information to create.
     */
    private RuleDescriptionImpl ruleDescription;

    /**
     * Creates an instance of CreateRuleBodyContent class.
     */
    public CreateRuleBodyContentImpl() {
    }

    /**
     * Get the type property: MIME type of content.
     * 
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: MIME type of content.
     * 
     * @param type the type value to set.
     * @return the CreateRuleBodyContent object itself.
     */
    public CreateRuleBodyContentImpl setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the ruleDescription property: Rule information to create.
     * 
     * @return the ruleDescription value.
     */
    public RuleDescriptionImpl getRuleDescription() {
        return this.ruleDescription;
    }

    /**
     * Set the ruleDescription property: Rule information to create.
     * 
     * @param ruleDescription the ruleDescription value to set.
     * @return the CreateRuleBodyContent object itself.
     */
    public CreateRuleBodyContentImpl setRuleDescription(RuleDescriptionImpl ruleDescription) {
        this.ruleDescription = ruleDescription;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "CreateRuleBodyContent" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("type", this.type);
        xmlWriter.writeXml(this.ruleDescription, "RuleDescription");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of CreateRuleBodyContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of CreateRuleBodyContent if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the CreateRuleBodyContent.
     */
    public static CreateRuleBodyContentImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of CreateRuleBodyContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of CreateRuleBodyContent if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the CreateRuleBodyContent.
     */
    public static CreateRuleBodyContentImpl fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = CoreUtils.isNullOrEmpty(rootElementName) ? "CreateRuleBodyContent" : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            CreateRuleBodyContentImpl deserializedCreateRuleBodyContent = new CreateRuleBodyContentImpl();
            deserializedCreateRuleBodyContent.type = reader.getStringAttribute(null, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("RuleDescription".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCreateRuleBodyContent.ruleDescription
                        = RuleDescriptionImpl.fromXml(reader, "RuleDescription");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedCreateRuleBodyContent;
        });
    }
}
