// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of entities the namespace can contain.
 */
public final class NamespaceType extends ExpandableStringEnum<NamespaceType> {
    /**
     * Static value Messaging for NamespaceType.
     */
    public static final NamespaceType MESSAGING = fromString("Messaging");

    /**
     * Static value NotificationHub for NamespaceType.
     */
    public static final NamespaceType NOTIFICATION_HUB = fromString("NotificationHub");

    /**
     * Static value Mixed for NamespaceType.
     */
    public static final NamespaceType MIXED = fromString("Mixed");

    /**
     * Static value EventHub for NamespaceType.
     */
    public static final NamespaceType EVENT_HUB = fromString("EventHub");

    /**
     * Static value Relay for NamespaceType.
     */
    public static final NamespaceType RELAY = fromString("Relay");

    /**
     * Creates a new instance of NamespaceType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NamespaceType() {
    }

    /**
     * Creates or finds a NamespaceType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NamespaceType.
     */
    public static NamespaceType fromString(String name) {
        return fromString(name, NamespaceType.class);
    }

    /**
     * Gets known NamespaceType values.
     * 
     * @return known NamespaceType values.
     */
    public static Collection<NamespaceType> values() {
        return values(NamespaceType.class);
    }
}
