// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Description of a Service Bus queue resource.
 */
@Fluent
public final class QueueDescription implements XmlSerializable<QueueDescription> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other
     * receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
     */
    @Generated
    private Duration lockDuration;

    /*
     * The maximum size of the queue in megabytes, which is the size of memory allocated for the queue.
     */
    @Generated
    private Long maxSizeInMegabytes;

    /*
     * A value indicating if this queue requires duplicate detection.
     */
    @Generated
    private Boolean requiresDuplicateDetection;

    /*
     * A value that indicates whether the queue supports the concept of sessions.
     */
    @Generated
    private Boolean requiresSession;

    /*
     * ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting
     * from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a
     * message itself.
     */
    @Generated
    private Duration defaultMessageTimeToLive;

    /*
     * A value that indicates whether this queue has dead letter support when a message expires.
     */
    @Generated
    private Boolean deadLetteringOnMessageExpiration;

    /*
     * ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10
     * minutes.
     */
    @Generated
    private Duration duplicateDetectionHistoryTimeWindow;

    /*
     * The maximum delivery count. A message is automatically deadlettered after this number of deliveries. Default
     * value is 10.
     */
    @Generated
    private Integer maxDeliveryCount;

    /*
     * Value that indicates whether server-side batched operations are enabled.
     */
    @Generated
    private Boolean enableBatchedOperations;

    /*
     * The size of the queue, in bytes.
     */
    @Generated
    private Long sizeInBytes;

    /*
     * The number of messages in the queue.
     */
    @Generated
    private Integer messageCount;

    /*
     * A value indicating if the resource can be accessed without authorization.
     */
    @Generated
    private Boolean isAnonymousAccessible;

    /*
     * Authorization rules for resource.
     */
    @Generated
    private List<AuthorizationRule> authorizationRules;

    /*
     * Status of a Service Bus resource
     */
    @Generated
    private EntityStatus status;

    /*
     * The name of the recipient entity to which all the messages sent to the queue are forwarded to.
     */
    @Generated
    private String forwardTo;

    /*
     * Custom metadata that user can associate with the description. Max length is 1024 chars.
     */
    @Generated
    private String userMetadata;

    /*
     * The exact time the queue was created.
     */
    @Generated
    private OffsetDateTime createdAt;

    /*
     * The exact time the entity description was last updated.
     */
    @Generated
    private OffsetDateTime updatedAt;

    /*
     * Last time a message was sent, or the last time there was a receive request to this queue.
     */
    @Generated
    private OffsetDateTime accessedAt;

    /*
     * Indicates if messages are received in the same order they are sent. For queues, defaults to true and setting it
     * to false has no effect.
     */
    @Generated
    private Boolean supportOrdering;

    /*
     * Details about the message counts in entity.
     */
    @Generated
    private MessageCountDetails messageCountDetails;

    /*
     * ISO 8601 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5
     * minutes.
     */
    @Generated
    private Duration autoDeleteOnIdle;

    /*
     * A value that indicates whether the queue is to be partitioned across multiple message brokers.
     */
    @Generated
    private Boolean enablePartitioning;

    /*
     * Availability status of the entity
     */
    @Generated
    private EntityAvailabilityStatus entityAvailabilityStatus;

    /*
     * The name of the recipient entity to which all the dead-lettered messages of this subscription are forwarded to.
     */
    @Generated
    private String forwardDeadLetteredMessagesTo;

    /*
     * A value that indicates whether Express Entities are enabled. An express queue holds a message in memory
     * temporarily before writing it to persistent storage.
     */
    @Generated
    private Boolean enableExpress;

    /*
     * The maximum size in kilobytes of message payload that can be accepted by the queue.
     */
    @Generated
    private Long maxMessageSizeInKilobytes;

    /**
     * Creates an instance of QueueDescription class.
     */
    @Generated
    public QueueDescription() {
    }

    /**
     * Get the lockDuration property: ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the
     * message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1
     * minute.
     * 
     * @return the lockDuration value.
     */
    @Generated
    public Duration getLockDuration() {
        return this.lockDuration;
    }

    /**
     * Set the lockDuration property: ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the
     * message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1
     * minute.
     * 
     * @param lockDuration the lockDuration value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    /**
     * Get the maxSizeInMegabytes property: The maximum size of the queue in megabytes, which is the size of memory
     * allocated for the queue.
     * 
     * @return the maxSizeInMegabytes value.
     */
    @Generated
    public Long getMaxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    /**
     * Set the maxSizeInMegabytes property: The maximum size of the queue in megabytes, which is the size of memory
     * allocated for the queue.
     * 
     * @param maxSizeInMegabytes the maxSizeInMegabytes value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setMaxSizeInMegabytes(Long maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    /**
     * Get the requiresDuplicateDetection property: A value indicating if this queue requires duplicate detection.
     * 
     * @return the requiresDuplicateDetection value.
     */
    @Generated
    public Boolean isRequiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    /**
     * Set the requiresDuplicateDetection property: A value indicating if this queue requires duplicate detection.
     * 
     * @param requiresDuplicateDetection the requiresDuplicateDetection value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    /**
     * Get the requiresSession property: A value that indicates whether the queue supports the concept of sessions.
     * 
     * @return the requiresSession value.
     */
    @Generated
    public Boolean isRequiresSession() {
        return this.requiresSession;
    }

    /**
     * Set the requiresSession property: A value that indicates whether the queue supports the concept of sessions.
     * 
     * @param requiresSession the requiresSession value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    /**
     * Get the defaultMessageTimeToLive property: ISO 8601 default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default value
     * used when TimeToLive is not set on a message itself.
     * 
     * @return the defaultMessageTimeToLive value.
     */
    @Generated
    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    /**
     * Set the defaultMessageTimeToLive property: ISO 8601 default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default value
     * used when TimeToLive is not set on a message itself.
     * 
     * @param defaultMessageTimeToLive the defaultMessageTimeToLive value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    /**
     * Get the deadLetteringOnMessageExpiration property: A value that indicates whether this queue has dead letter
     * support when a message expires.
     * 
     * @return the deadLetteringOnMessageExpiration value.
     */
    @Generated
    public Boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    /**
     * Set the deadLetteringOnMessageExpiration property: A value that indicates whether this queue has dead letter
     * support when a message expires.
     * 
     * @param deadLetteringOnMessageExpiration the deadLetteringOnMessageExpiration value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    /**
     * Get the duplicateDetectionHistoryTimeWindow property: ISO 8601 timeSpan structure that defines the duration of
     * the duplicate detection history. The default value is 10 minutes.
     * 
     * @return the duplicateDetectionHistoryTimeWindow value.
     */
    @Generated
    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    /**
     * Set the duplicateDetectionHistoryTimeWindow property: ISO 8601 timeSpan structure that defines the duration of
     * the duplicate detection history. The default value is 10 minutes.
     * 
     * @param duplicateDetectionHistoryTimeWindow the duplicateDetectionHistoryTimeWindow value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    /**
     * Get the maxDeliveryCount property: The maximum delivery count. A message is automatically deadlettered after this
     * number of deliveries. Default value is 10.
     * 
     * @return the maxDeliveryCount value.
     */
    @Generated
    public Integer getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    /**
     * Set the maxDeliveryCount property: The maximum delivery count. A message is automatically deadlettered after this
     * number of deliveries. Default value is 10.
     * 
     * @param maxDeliveryCount the maxDeliveryCount value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    /**
     * Get the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     * 
     * @return the enableBatchedOperations value.
     */
    @Generated
    public Boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    /**
     * Set the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     * 
     * @param enableBatchedOperations the enableBatchedOperations value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    /**
     * Get the sizeInBytes property: The size of the queue, in bytes.
     * 
     * @return the sizeInBytes value.
     */
    @Generated
    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    /**
     * Set the sizeInBytes property: The size of the queue, in bytes.
     * 
     * @param sizeInBytes the sizeInBytes value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    /**
     * Get the messageCount property: The number of messages in the queue.
     * 
     * @return the messageCount value.
     */
    @Generated
    public Integer getMessageCount() {
        return this.messageCount;
    }

    /**
     * Set the messageCount property: The number of messages in the queue.
     * 
     * @param messageCount the messageCount value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    /**
     * Get the isAnonymousAccessible property: A value indicating if the resource can be accessed without authorization.
     * 
     * @return the isAnonymousAccessible value.
     */
    @Generated
    public Boolean isAnonymousAccessible() {
        return this.isAnonymousAccessible;
    }

    /**
     * Set the isAnonymousAccessible property: A value indicating if the resource can be accessed without authorization.
     * 
     * @param isAnonymousAccessible the isAnonymousAccessible value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setIsAnonymousAccessible(Boolean isAnonymousAccessible) {
        this.isAnonymousAccessible = isAnonymousAccessible;
        return this;
    }

    /**
     * Get the authorizationRules property: Authorization rules for resource.
     * 
     * @return the authorizationRules value.
     */
    @Generated
    public List<AuthorizationRule> getAuthorizationRules() {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList<>();
        }
        return this.authorizationRules;
    }

    /**
     * Set the authorizationRules property: Authorization rules for resource.
     * 
     * @param authorizationRules the authorizationRules value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setAuthorizationRules(List<AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    /**
     * Get the status property: Status of a Service Bus resource.
     * 
     * @return the status value.
     */
    @Generated
    public EntityStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Status of a Service Bus resource.
     * 
     * @param status the status value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the forwardTo property: The name of the recipient entity to which all the messages sent to the queue are
     * forwarded to.
     * 
     * @return the forwardTo value.
     */
    @Generated
    public String getForwardTo() {
        return this.forwardTo;
    }

    /**
     * Set the forwardTo property: The name of the recipient entity to which all the messages sent to the queue are
     * forwarded to.
     * 
     * @param forwardTo the forwardTo value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    /**
     * Get the userMetadata property: Custom metadata that user can associate with the description. Max length is 1024
     * chars.
     * 
     * @return the userMetadata value.
     */
    @Generated
    public String getUserMetadata() {
        return this.userMetadata;
    }

    /**
     * Set the userMetadata property: Custom metadata that user can associate with the description. Max length is 1024
     * chars.
     * 
     * @param userMetadata the userMetadata value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    /**
     * Get the createdAt property: The exact time the queue was created.
     * 
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    /**
     * Set the createdAt property: The exact time the queue was created.
     * 
     * @param createdAt the createdAt value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Get the updatedAt property: The exact time the entity description was last updated.
     * 
     * @return the updatedAt value.
     */
    @Generated
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * Set the updatedAt property: The exact time the entity description was last updated.
     * 
     * @param updatedAt the updatedAt value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * Get the accessedAt property: Last time a message was sent, or the last time there was a receive request to this
     * queue.
     * 
     * @return the accessedAt value.
     */
    @Generated
    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    /**
     * Set the accessedAt property: Last time a message was sent, or the last time there was a receive request to this
     * queue.
     * 
     * @param accessedAt the accessedAt value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setAccessedAt(OffsetDateTime accessedAt) {
        this.accessedAt = accessedAt;
        return this;
    }

    /**
     * Get the supportOrdering property: Indicates if messages are received in the same order they are sent. For queues,
     * defaults to true and setting it to false has no effect.
     * 
     * @return the supportOrdering value.
     */
    @Generated
    public Boolean isSupportOrdering() {
        return this.supportOrdering;
    }

    /**
     * Set the supportOrdering property: Indicates if messages are received in the same order they are sent. For queues,
     * defaults to true and setting it to false has no effect.
     * 
     * @param supportOrdering the supportOrdering value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setSupportOrdering(Boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    /**
     * Get the messageCountDetails property: Details about the message counts in entity.
     * 
     * @return the messageCountDetails value.
     */
    @Generated
    public MessageCountDetails getMessageCountDetails() {
        return this.messageCountDetails;
    }

    /**
     * Set the messageCountDetails property: Details about the message counts in entity.
     * 
     * @param messageCountDetails the messageCountDetails value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setMessageCountDetails(MessageCountDetails messageCountDetails) {
        this.messageCountDetails = messageCountDetails;
        return this;
    }

    /**
     * Get the autoDeleteOnIdle property: ISO 8601 timeSpan idle interval after which the queue is automatically
     * deleted. The minimum duration is 5 minutes.
     * 
     * @return the autoDeleteOnIdle value.
     */
    @Generated
    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    /**
     * Set the autoDeleteOnIdle property: ISO 8601 timeSpan idle interval after which the queue is automatically
     * deleted. The minimum duration is 5 minutes.
     * 
     * @param autoDeleteOnIdle the autoDeleteOnIdle value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    /**
     * Get the enablePartitioning property: A value that indicates whether the queue is to be partitioned across
     * multiple message brokers.
     * 
     * @return the enablePartitioning value.
     */
    @Generated
    public Boolean isEnablePartitioning() {
        return this.enablePartitioning;
    }

    /**
     * Set the enablePartitioning property: A value that indicates whether the queue is to be partitioned across
     * multiple message brokers.
     * 
     * @param enablePartitioning the enablePartitioning value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    /**
     * Get the entityAvailabilityStatus property: Availability status of the entity.
     * 
     * @return the entityAvailabilityStatus value.
     */
    @Generated
    public EntityAvailabilityStatus getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    /**
     * Set the entityAvailabilityStatus property: Availability status of the entity.
     * 
     * @param entityAvailabilityStatus the entityAvailabilityStatus value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setEntityAvailabilityStatus(EntityAvailabilityStatus entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    /**
     * Get the forwardDeadLetteredMessagesTo property: The name of the recipient entity to which all the dead-lettered
     * messages of this subscription are forwarded to.
     * 
     * @return the forwardDeadLetteredMessagesTo value.
     */
    @Generated
    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    /**
     * Set the forwardDeadLetteredMessagesTo property: The name of the recipient entity to which all the dead-lettered
     * messages of this subscription are forwarded to.
     * 
     * @param forwardDeadLetteredMessagesTo the forwardDeadLetteredMessagesTo value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    /**
     * Get the enableExpress property: A value that indicates whether Express Entities are enabled. An express queue
     * holds a message in memory temporarily before writing it to persistent storage.
     * 
     * @return the enableExpress value.
     */
    @Generated
    public Boolean isEnableExpress() {
        return this.enableExpress;
    }

    /**
     * Set the enableExpress property: A value that indicates whether Express Entities are enabled. An express queue
     * holds a message in memory temporarily before writing it to persistent storage.
     * 
     * @param enableExpress the enableExpress value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    /**
     * Get the maxMessageSizeInKilobytes property: The maximum size in kilobytes of message payload that can be accepted
     * by the queue.
     * 
     * @return the maxMessageSizeInKilobytes value.
     */
    @Generated
    public Long getMaxMessageSizeInKilobytes() {
        return this.maxMessageSizeInKilobytes;
    }

    /**
     * Set the maxMessageSizeInKilobytes property: The maximum size in kilobytes of message payload that can be accepted
     * by the queue.
     * 
     * @param maxMessageSizeInKilobytes the maxMessageSizeInKilobytes value to set.
     * @return the QueueDescription object itself.
     */
    @Generated
    public QueueDescription setMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        this.maxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "QueueDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "LockDuration",
            CoreUtils.durationToStringWithDays(this.lockDuration));
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxSizeInMegabytes",
            this.maxSizeInMegabytes);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresDuplicateDetection",
            this.requiresDuplicateDetection);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresSession",
            this.requiresSession);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DefaultMessageTimeToLive",
            CoreUtils.durationToStringWithDays(this.defaultMessageTimeToLive));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DeadLetteringOnMessageExpiration",
            this.deadLetteringOnMessageExpiration);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DuplicateDetectionHistoryTimeWindow",
            CoreUtils.durationToStringWithDays(this.duplicateDetectionHistoryTimeWindow));
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxDeliveryCount",
            this.maxDeliveryCount);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableBatchedOperations",
            this.enableBatchedOperations);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SizeInBytes", this.sizeInBytes);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessageCount", this.messageCount);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "IsAnonymousAccessible",
            this.isAnonymousAccessible);
        if (this.authorizationRules != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AuthorizationRules");
            for (AuthorizationRule element : this.authorizationRules) {
                xmlWriter.writeXml(element, "AuthorizationRule");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Status",
            this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardTo", this.forwardTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UserMetadata", this.userMetadata);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt",
            this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UpdatedAt",
            this.updatedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessedAt",
            this.accessedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.accessedAt));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SupportOrdering",
            this.supportOrdering);
        xmlWriter.writeXml(this.messageCountDetails, "CountDetails");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AutoDeleteOnIdle",
            CoreUtils.durationToStringWithDays(this.autoDeleteOnIdle));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnablePartitioning",
            this.enablePartitioning);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EntityAvailabilityStatus",
            this.entityAvailabilityStatus == null ? null : this.entityAvailabilityStatus.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardDeadLetteredMessagesTo",
            this.forwardDeadLetteredMessagesTo);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableExpress", this.enableExpress);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxMessageSizeInKilobytes",
            this.maxMessageSizeInKilobytes);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of QueueDescription from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of QueueDescription if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueDescription.
     */
    @Generated
    public static QueueDescription fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of QueueDescription from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of QueueDescription if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueDescription.
     */
    @Generated
    public static QueueDescription fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "QueueDescription" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            QueueDescription deserializedQueueDescription = new QueueDescription();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("LockDuration".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.lockDuration = reader.getNullableElement(Duration::parse);
                } else if ("MaxSizeInMegabytes".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.maxSizeInMegabytes = reader.getNullableElement(Long::parseLong);
                } else if ("RequiresDuplicateDetection".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.requiresDuplicateDetection
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("RequiresSession".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.requiresSession = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("DefaultMessageTimeToLive".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.defaultMessageTimeToLive = reader.getNullableElement(Duration::parse);
                } else if ("DeadLetteringOnMessageExpiration".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.deadLetteringOnMessageExpiration
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("DuplicateDetectionHistoryTimeWindow".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.duplicateDetectionHistoryTimeWindow
                        = reader.getNullableElement(Duration::parse);
                } else if ("MaxDeliveryCount".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.maxDeliveryCount = reader.getNullableElement(Integer::parseInt);
                } else if ("EnableBatchedOperations".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.enableBatchedOperations
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("SizeInBytes".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.sizeInBytes = reader.getNullableElement(Long::parseLong);
                } else if ("MessageCount".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.messageCount = reader.getNullableElement(Integer::parseInt);
                } else if ("IsAnonymousAccessible".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.isAnonymousAccessible
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("AuthorizationRules".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("AuthorizationRule".equals(elementName.getLocalPart())
                            && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedQueueDescription.authorizationRules == null) {
                                deserializedQueueDescription.authorizationRules = new ArrayList<>();
                            }
                            deserializedQueueDescription.authorizationRules
                                .add(AuthorizationRule.fromXml(reader, "AuthorizationRule"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else if ("Status".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.status = EntityStatus.fromString(reader.getStringElement());
                } else if ("ForwardTo".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.forwardTo = reader.getStringElement();
                } else if ("UserMetadata".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.userMetadata = reader.getStringElement();
                } else if ("CreatedAt".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.createdAt
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("UpdatedAt".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.updatedAt
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("AccessedAt".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.accessedAt
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("SupportOrdering".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.supportOrdering = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("CountDetails".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.messageCountDetails
                        = MessageCountDetails.fromXml(reader, "CountDetails");
                } else if ("AutoDeleteOnIdle".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.autoDeleteOnIdle = reader.getNullableElement(Duration::parse);
                } else if ("EnablePartitioning".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.enablePartitioning = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("EntityAvailabilityStatus".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.entityAvailabilityStatus
                        = EntityAvailabilityStatus.fromString(reader.getStringElement());
                } else if ("ForwardDeadLetteredMessagesTo".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.forwardDeadLetteredMessagesTo = reader.getStringElement();
                } else if ("EnableExpress".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.enableExpress = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("MaxMessageSizeInKilobytes".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.maxMessageSizeInKilobytes = reader.getNullableElement(Long::parseLong);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedQueueDescription;
        });
    }
}
