// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The SubscriptionDescription.
 */
@Fluent
public final class SubscriptionDescriptionEntryContent implements XmlSerializable<SubscriptionDescriptionEntryContent> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * Type of content in subscription response
     */
    @Generated
    private String type;

    /*
     * Description of a Service Bus subscription resource.
     */
    @Generated
    private SubscriptionDescription subscriptionDescription;

    /**
     * Creates an instance of SubscriptionDescriptionEntryContent class.
     */
    @Generated
    public SubscriptionDescriptionEntryContent() {
    }

    /**
     * Get the type property: Type of content in subscription response.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: Type of content in subscription response.
     * 
     * @param type the type value to set.
     * @return the SubscriptionDescriptionEntryContent object itself.
     */
    @Generated
    public SubscriptionDescriptionEntryContent setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the subscriptionDescription property: Description of a Service Bus subscription resource.
     * 
     * @return the subscriptionDescription value.
     */
    @Generated
    public SubscriptionDescription getSubscriptionDescription() {
        return this.subscriptionDescription;
    }

    /**
     * Set the subscriptionDescription property: Description of a Service Bus subscription resource.
     * 
     * @param subscriptionDescription the subscriptionDescription value to set.
     * @return the SubscriptionDescriptionEntryContent object itself.
     */
    @Generated
    public SubscriptionDescriptionEntryContent
        setSubscriptionDescription(SubscriptionDescription subscriptionDescription) {
        this.subscriptionDescription = subscriptionDescription;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty()
            ? "SubscriptionDescriptionEntryContent"
            : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("type", this.type);
        xmlWriter.writeXml(this.subscriptionDescription, "SubscriptionDescription");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of SubscriptionDescriptionEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of SubscriptionDescriptionEntryContent if the XmlReader was pointing to an instance of it, or
     * null if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the SubscriptionDescriptionEntryContent.
     */
    @Generated
    public static SubscriptionDescriptionEntryContent fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of SubscriptionDescriptionEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of SubscriptionDescriptionEntryContent if the XmlReader was pointing to an instance of it, or
     * null if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the SubscriptionDescriptionEntryContent.
     */
    @Generated
    public static SubscriptionDescriptionEntryContent fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty()
            ? "SubscriptionDescriptionEntryContent"
            : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            SubscriptionDescriptionEntryContent deserializedSubscriptionDescriptionEntryContent
                = new SubscriptionDescriptionEntryContent();
            deserializedSubscriptionDescriptionEntryContent.type = reader.getStringAttribute(null, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("SubscriptionDescription".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionEntryContent.subscriptionDescription
                        = SubscriptionDescription.fromXml(reader, "SubscriptionDescription");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedSubscriptionDescriptionEntryContent;
        });
    }
}
