// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlWriter;
import javax.xml.stream.XMLStreamException;

/**
 * The Title model.
 */
@Fluent
public final class Title implements XmlSerializable<Title> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    /*
     * The type of the title.
     */
    @Generated
    private String type;

    /*
     * The title.
     */
    @Generated
    private String content;

    /**
     * Creates an instance of Title class.
     */
    @Generated
    public Title() {
    }

    /**
     * Get the type property: The type of the title.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: The type of the title.
     * 
     * @param type the type value to set.
     * @return the Title object itself.
     */
    @Generated
    public Title setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the content property: The title.
     * 
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Set the content property: The title.
     * 
     * @param content the content value to set.
     * @return the Title object itself.
     */
    @Generated
    public Title setContent(String content) {
        this.content = content;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "title" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "type", this.type);
        xmlWriter.writeString(this.content);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of Title from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of Title if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the Title.
     */
    @Generated
    public static Title fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of Title from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of Title if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the Title.
     */
    @Generated
    public static Title fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "title" : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            Title deserializedTitle = new Title();
            deserializedTitle.type = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "type");
            deserializedTitle.content = reader.getStringElement();

            return deserializedTitle;
        });
    }
}
