/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.implementation.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescription;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.RuleAction;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.implementation.models.RuleFilter;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescription;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescription;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionFeed;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SharedAccessAuthorizationRule;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.xml.XmlReader;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public final class EntityHelper {
    private static final ClientLogger LOGGER = new ClientLogger(EntityHelper.class);
    public static final String QUEUES_ENTITY_TYPE = "queues";
    public static final String TOPICS_ENTITY_TYPE = "topics";
    public static final int NUMBER_OF_ELEMENTS = 100;
    private static QueueAccessor queueAccessor;
    private static SubscriptionAccessor subscriptionAccessor;
    private static TopicAccessor topicAccessor;
    private static RuleAccessor ruleAccessor;

    public static QueueDescription getQueueDescription(CreateQueueOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        QueueDescription description = new QueueDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDeadLetteringOnMessageExpiration(options.isDeadLetteringOnMessageExpiration()).setDuplicateDetectionHistoryTimeWindow(options.getDuplicateDetectionHistoryTimeWindow()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setEnablePartitioning(options.isPartitioningEnabled()).setForwardTo(options.getForwardTo()).setForwardDeadLetteredMessagesTo(options.getForwardDeadLetteredMessagesTo()).setLockDuration(options.getLockDuration()).setMaxDeliveryCount(options.getMaxDeliveryCount()).setMaxSizeInMegabytes(options.getMaxSizeInMegabytes()).setRequiresDuplicateDetection(options.isDuplicateDetectionRequired()).setRequiresSession(options.isSessionRequired()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
        if (!options.getAuthorizationRules().isEmpty()) {
            description.setAuthorizationRules(EntityHelper.toImplementation(options.getAuthorizationRules()));
        }
        if (options.getMaxMessageSizeInKilobytes() != 0L) {
            description.setMaxMessageSizeInKilobytes(options.getMaxMessageSizeInKilobytes());
        }
        return description;
    }

    public static SubscriptionDescription getSubscriptionDescription(CreateSubscriptionOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return new SubscriptionDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDeadLetteringOnFilterEvaluationExceptions(options.isDeadLetteringOnFilterEvaluationExceptions()).setDeadLetteringOnMessageExpiration(options.isDeadLetteringOnMessageExpiration()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setForwardTo(options.getForwardTo()).setForwardDeadLetteredMessagesTo(options.getForwardDeadLetteredMessagesTo()).setLockDuration(options.getLockDuration()).setMaxDeliveryCount(options.getMaxDeliveryCount()).setRequiresSession(options.isSessionRequired()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata()).setDefaultRuleDescription(options.getDefaultRule() != null ? EntityHelper.toImplementation(options.getDefaultRule()) : null);
    }

    public static TopicDescription getTopicDescription(CreateTopicOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        TopicDescription description = new TopicDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDuplicateDetectionHistoryTimeWindow(options.getDuplicateDetectionHistoryTimeWindow()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setEnablePartitioning(options.isPartitioningEnabled()).setMaxSizeInMegabytes(options.getMaxSizeInMegabytes()).setRequiresDuplicateDetection(options.isDuplicateDetectionRequired()).setSupportOrdering(options.isSupportOrdering()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
        if (!options.getAuthorizationRules().isEmpty()) {
            description.setAuthorizationRules(EntityHelper.toImplementation(options.getAuthorizationRules()));
        }
        if (options.getMaxMessageSizeInKilobytes() != 0L) {
            description.setMaxMessageSizeInKilobytes(options.getMaxMessageSizeInKilobytes());
        }
        return description;
    }

    public static QueueDescription toImplementation(QueueProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (queueAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        List<AuthorizationRule> rules = !properties.getAuthorizationRules().isEmpty() ? EntityHelper.toImplementation(properties.getAuthorizationRules()) : Collections.emptyList();
        return queueAccessor.toImplementation(properties, rules);
    }

    public static RuleAction toImplementation(com.azure.messaging.servicebus.administration.models.RuleAction properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static RuleDescription toImplementation(RuleProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static RuleFilter toImplementation(com.azure.messaging.servicebus.administration.models.RuleFilter properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static SubscriptionDescription toImplementation(SubscriptionProperties description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        return subscriptionAccessor.toImplementation(description);
    }

    public static TopicDescription toImplementation(TopicProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (topicAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        List<AuthorizationRule> rules = !properties.getAuthorizationRules().isEmpty() ? EntityHelper.toImplementation(properties.getAuthorizationRules()) : Collections.emptyList();
        return topicAccessor.toImplementation(properties, rules);
    }

    public static QueueProperties toModel(QueueDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (queueAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        return queueAccessor.toModel(description);
    }

    public static com.azure.messaging.servicebus.administration.models.RuleAction toModel(RuleAction description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static com.azure.messaging.servicebus.administration.models.RuleFilter toModel(RuleFilter description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static RuleProperties toModel(RuleDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static SubscriptionProperties toModel(SubscriptionDescription options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        return subscriptionAccessor.toModel(options);
    }

    public static TopicProperties toModel(TopicDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (topicAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        return topicAccessor.toModel(description);
    }

    public static void setQueueAccessor(QueueAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (queueAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'accessor' is already set."));
        }
        queueAccessor = accessor;
    }

    public static void setQueueName(QueueProperties queueProperties, String name) {
        if (queueAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        queueAccessor.setName(queueProperties, name);
    }

    public static void setRuleAccessor(RuleAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (ruleAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' is already set."));
        }
        ruleAccessor = accessor;
    }

    public static void setSubscriptionAccessor(SubscriptionAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (subscriptionAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' is already set."));
        }
        subscriptionAccessor = accessor;
    }

    public static void setSubscriptionName(SubscriptionProperties subscription, String subscriptionName) {
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        subscriptionAccessor.setSubscriptionName(subscription, subscriptionName);
    }

    public static void setTopicAccessor(TopicAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (topicAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' is already set."));
        }
        topicAccessor = accessor;
    }

    public static void setTopicName(SubscriptionProperties subscription, String topicName) {
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        subscriptionAccessor.setTopicName(subscription, topicName);
    }

    public static void setTopicName(TopicProperties topicProperties, String topicName) {
        if (topicAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        topicAccessor.setName(topicProperties, topicName);
    }

    private static List<AuthorizationRule> toImplementation(List<com.azure.messaging.servicebus.administration.models.AuthorizationRule> rules) {
        return rules.stream().map(rule -> {
            AuthorizationRule implementation = new AuthorizationRule().setClaimType(rule.getClaimType()).setClaimValue(rule.getClaimValue()).setCreatedTime(rule.getCreatedAt()).setKeyName(rule.getKeyName()).setModifiedTime(rule.getModifiedAt()).setPrimaryKey(rule.getPrimaryKey()).setSecondaryKey(rule.getSecondaryKey()).setRights(rule.getAccessRights());
            if (rule instanceof SharedAccessAuthorizationRule) {
                implementation.setType("SharedAccessAuthorizationRule");
            } else {
                String className = rule.getClass().getName();
                LOGGER.atWarning().addKeyValue("type", className).log("AuthorizationRule type is unknown.");
                implementation.setType(className);
            }
            return implementation;
        }).collect(Collectors.toList());
    }

    public static Response<QueueDescriptionFeed> deserializeQueueFeed(Response<Object> response, ClientLogger logger) {
        SimpleResponse simpleResponse;
        block18: {
            String responseBody = response.getValue().toString();
            XmlReader xmlReader = XmlReader.fromString((String)responseBody);
            try {
                QueueDescriptionFeed entry = QueueDescriptionFeed.fromXml(xmlReader);
                simpleResponse = new SimpleResponse(response, (Object)entry);
                if (xmlReader == null) break block18;
            }
            catch (Throwable entry) {
                try {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Throwable throwable) {
                            entry.addSuppressed(throwable);
                        }
                    }
                    throw entry;
                }
                catch (IllegalStateException ex) {
                    SimpleResponse simpleResponse2;
                    block19: {
                        XmlReader xmlReader2 = XmlReader.fromString((String)responseBody);
                        try {
                            TopicDescriptionFeed entryTopic = TopicDescriptionFeed.fromXml(xmlReader2);
                            logger.atWarning().addKeyValue("entityName", (Object)entryTopic.getTitle()).log("Expected queue feed, but it is a topic feed.");
                            simpleResponse2 = new SimpleResponse(response, null);
                            if (xmlReader2 == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (xmlReader2 != null) {
                                    try {
                                        xmlReader2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IllegalStateException ignored) {
                                return new SimpleResponse(response, null);
                            }
                            catch (XMLStreamException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        xmlReader2.close();
                    }
                    return simpleResponse2;
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
            xmlReader.close();
        }
        return simpleResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Response<QueueProperties> deserializeQueue(Response<Object> response, ClientLogger logger) {
        String responseBody = response.getValue().toString();
        try (XmlReader xmlReader = XmlReader.fromString((String)responseBody);){
            QueueDescriptionEntry entry = QueueDescriptionEntry.fromXml(xmlReader);
            if (entry == null) {
                SimpleResponse simpleResponse = new SimpleResponse(response, null);
                return simpleResponse;
            }
            if (entry.getContent() == null) {
                logger.atInfo().addKeyValue("entry", (Object)entry).log("The entry content is null. The entity may not exist.");
                SimpleResponse simpleResponse = new SimpleResponse(response, null);
                return simpleResponse;
            }
            QueueProperties result = EntityHelper.toModel(entry.getContent().getQueueDescription());
            String queueName = entry.getTitle().getContent();
            EntityHelper.setQueueName(result, queueName);
            SimpleResponse simpleResponse = new SimpleResponse(response, (Object)result);
            return simpleResponse;
        }
        catch (IllegalStateException ex) {
            try (XmlReader xmlReader2 = XmlReader.fromString((String)responseBody);){
                TopicDescriptionEntry entryTopic = TopicDescriptionEntry.fromXml(xmlReader2);
                logger.atWarning().addKeyValue("entityName", (Object)entryTopic.getTitle()).log("Expected queue, but it is a topic.");
                SimpleResponse simpleResponse = new SimpleResponse(response, null);
                return simpleResponse;
            }
            catch (IllegalStateException ignored) {
                return new SimpleResponse(response, null);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public static Response<TopicDescriptionFeed> deserializeTopicFeed(Response<Object> response, ClientLogger logger) {
        SimpleResponse simpleResponse;
        block18: {
            String responseBody = response.getValue().toString();
            XmlReader xmlReader = XmlReader.fromString((String)responseBody);
            try {
                TopicDescriptionFeed entry = TopicDescriptionFeed.fromXml(xmlReader);
                simpleResponse = new SimpleResponse(response, (Object)entry);
                if (xmlReader == null) break block18;
            }
            catch (Throwable entry) {
                try {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Throwable throwable) {
                            entry.addSuppressed(throwable);
                        }
                    }
                    throw entry;
                }
                catch (IllegalStateException ex) {
                    SimpleResponse simpleResponse2;
                    block19: {
                        XmlReader xmlReader2 = XmlReader.fromString((String)responseBody);
                        try {
                            QueueDescriptionFeed entryTopic = QueueDescriptionFeed.fromXml(xmlReader2);
                            logger.atWarning().addKeyValue("entityName", (Object)entryTopic.getTitle()).log("Expected topic feed, but it is a queue feed.");
                            simpleResponse2 = new SimpleResponse(response, null);
                            if (xmlReader2 == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (xmlReader2 != null) {
                                    try {
                                        xmlReader2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IllegalStateException ignored) {
                                return new SimpleResponse(response, null);
                            }
                            catch (XMLStreamException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        xmlReader2.close();
                    }
                    return simpleResponse2;
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
            xmlReader.close();
        }
        return simpleResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Response<TopicProperties> deserializeTopic(Response<Object> response, ClientLogger logger) {
        String responseBody = response.getValue().toString();
        try (XmlReader xmlReader = XmlReader.fromString((String)responseBody);){
            TopicDescriptionEntry entry = TopicDescriptionEntry.fromXml(xmlReader);
            if (entry == null) {
                SimpleResponse simpleResponse = new SimpleResponse(response, null);
                return simpleResponse;
            }
            if (entry.getContent() == null) {
                logger.atWarning().addKeyValue("entry", (Object)entry).log("The entry content is null. The entity may not exist.");
                SimpleResponse simpleResponse = new SimpleResponse(response, null);
                return simpleResponse;
            }
            TopicProperties result = EntityHelper.toModel(entry.getContent().getTopicDescription());
            String topicName = entry.getTitle().getContent();
            EntityHelper.setTopicName(result, topicName);
            SimpleResponse simpleResponse = new SimpleResponse(response, (Object)result);
            return simpleResponse;
        }
        catch (IllegalStateException ex) {
            try (XmlReader xmlReader2 = XmlReader.fromString((String)responseBody);){
                QueueDescriptionEntry entryQueue = QueueDescriptionEntry.fromXml(xmlReader2);
                logger.atWarning().addKeyValue("entityName", (Object)entryQueue.getTitle()).log("Expected topic, but it is a queue.");
                SimpleResponse simpleResponse = new SimpleResponse(response, null);
                return simpleResponse;
            }
            catch (IllegalStateException ignored) {
                return new SimpleResponse(response, null);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public static OffsetDateTime parseOffsetDateTimeBest(String datetimeString) {
        TemporalAccessor temporal = DateTimeFormatter.ISO_DATE_TIME.parseBest(datetimeString, OffsetDateTime::from, LocalDateTime::from);
        return temporal.query(TemporalQueries.offset()) == null ? LocalDateTime.from(temporal).atOffset(ZoneOffset.UTC) : OffsetDateTime.from(temporal);
    }

    static {
        try {
            Class.forName(QueueProperties.class.getName(), true, QueueProperties.class.getClassLoader());
            Class.forName(SubscriptionProperties.class.getName(), true, SubscriptionProperties.class.getClassLoader());
            Class.forName(TopicProperties.class.getName(), true, TopicProperties.class.getClassLoader());
            Class.forName(RuleProperties.class.getName(), true, RuleProperties.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public static interface QueueAccessor {
        public QueueDescription toImplementation(QueueProperties var1, List<AuthorizationRule> var2);

        public QueueProperties toModel(QueueDescription var1);

        public void setName(QueueProperties var1, String var2);
    }

    public static interface RuleAccessor {
        public RuleProperties toModel(RuleDescription var1);

        public com.azure.messaging.servicebus.administration.models.RuleAction toModel(RuleAction var1);

        public com.azure.messaging.servicebus.administration.models.RuleFilter toModel(RuleFilter var1);

        public RuleDescription toImplementation(RuleProperties var1);

        public RuleAction toImplementation(com.azure.messaging.servicebus.administration.models.RuleAction var1);

        public RuleFilter toImplementation(com.azure.messaging.servicebus.administration.models.RuleFilter var1);
    }

    public static interface SubscriptionAccessor {
        public SubscriptionProperties toModel(SubscriptionDescription var1);

        public SubscriptionDescription toImplementation(SubscriptionProperties var1);

        public void setTopicName(SubscriptionProperties var1, String var2);

        public void setSubscriptionName(SubscriptionProperties var1, String var2);
    }

    public static interface TopicAccessor {
        public TopicDescription toImplementation(TopicProperties var1, List<AuthorizationRule> var2);

        public TopicProperties toModel(TopicDescription var1);

        public void setName(TopicProperties var1, String var2);
    }
}

