/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.models.AccessRights;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class AuthorizationRule
implements XmlSerializable<AuthorizationRule> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private String type;
    private String claimType;
    private String claimValue;
    private List<AccessRights> rights;
    private OffsetDateTime createdTime;
    private OffsetDateTime modifiedTime;
    private String keyName;
    private String primaryKey;
    private String secondaryKey;

    public String getType() {
        return this.type;
    }

    public AuthorizationRule setType(String type) {
        this.type = type;
        return this;
    }

    public String getClaimType() {
        return this.claimType;
    }

    public AuthorizationRule setClaimType(String claimType) {
        this.claimType = claimType;
        return this;
    }

    public String getClaimValue() {
        return this.claimValue;
    }

    public AuthorizationRule setClaimValue(String claimValue) {
        this.claimValue = claimValue;
        return this;
    }

    public List<AccessRights> getRights() {
        if (this.rights == null) {
            this.rights = new ArrayList<AccessRights>();
        }
        return this.rights;
    }

    public AuthorizationRule setRights(List<AccessRights> rights) {
        this.rights = rights;
        return this;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public AuthorizationRule setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public OffsetDateTime getModifiedTime() {
        return this.modifiedTime;
    }

    public AuthorizationRule setModifiedTime(OffsetDateTime modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public AuthorizationRule setKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public AuthorizationRule setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    public AuthorizationRule setSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "AuthorizationRule" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("i", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", this.type);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ClaimType", this.claimType);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ClaimValue", this.claimValue);
        if (this.rights != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Rights");
            for (AccessRights element : this.rights) {
                xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessRights", element == null ? null : element.toString());
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedTime", this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ModifiedTime", this.modifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.modifiedTime));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "KeyName", this.keyName);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "PrimaryKey", this.primaryKey);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SecondaryKey", this.secondaryKey);
        return xmlWriter.writeEndElement();
    }

    public static AuthorizationRule fromXml(XmlReader xmlReader) throws XMLStreamException {
        return AuthorizationRule.fromXml(xmlReader, null);
    }

    public static AuthorizationRule fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "AuthorizationRule" : rootElementName;
        return (AuthorizationRule)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            AuthorizationRule deserializedAuthorizationRule = new AuthorizationRule();
            deserializedAuthorizationRule.type = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("ClaimType".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.claimType = reader.getStringElement();
                    continue;
                }
                if ("ClaimValue".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.claimValue = reader.getStringElement();
                    continue;
                }
                if ("Rights".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("AccessRights".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedAuthorizationRule.rights == null) {
                                deserializedAuthorizationRule.rights = new ArrayList<AccessRights>();
                            }
                            deserializedAuthorizationRule.rights.add(AccessRights.fromString(reader.getStringElement()));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("CreatedTime".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.createdTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("ModifiedTime".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.modifiedTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("KeyName".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.keyName = reader.getStringElement();
                    continue;
                }
                if ("PrimaryKey".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.primaryKey = reader.getStringElement();
                    continue;
                }
                if ("SecondaryKey".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.secondaryKey = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedAuthorizationRule;
        });
    }
}

