/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.Title;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class RuleDescriptionFeed
implements XmlSerializable<RuleDescriptionFeed> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String id;
    private Title title;
    private OffsetDateTime updated;
    private List<ResponseLink> link = new ArrayList<ResponseLink>();
    private List<RuleDescriptionEntry> entry = new ArrayList<RuleDescriptionEntry>();

    public String getId() {
        return this.id;
    }

    public RuleDescriptionFeed setId(String id) {
        this.id = id;
        return this;
    }

    public Title getTitle() {
        return this.title;
    }

    public RuleDescriptionFeed setTitle(Title title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public RuleDescriptionFeed setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public List<ResponseLink> getLink() {
        return this.link;
    }

    public RuleDescriptionFeed setLink(List<ResponseLink> link) {
        this.link = link;
        return this;
    }

    public List<RuleDescriptionEntry> getEntry() {
        return this.entry;
    }

    public RuleDescriptionFeed setEntry(List<RuleDescriptionEntry> entry) {
        this.entry = entry;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "feed" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        if (this.link != null) {
            for (ResponseLink responseLink : this.link) {
                xmlWriter.writeXml((XmlSerializable)responseLink, "link");
            }
        }
        if (this.entry != null) {
            for (RuleDescriptionEntry ruleDescriptionEntry : this.entry) {
                xmlWriter.writeXml((XmlSerializable)ruleDescriptionEntry, "entry");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static RuleDescriptionFeed fromXml(XmlReader xmlReader) throws XMLStreamException {
        return RuleDescriptionFeed.fromXml(xmlReader, null);
    }

    public static RuleDescriptionFeed fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "feed" : rootElementName;
        return (RuleDescriptionFeed)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            RuleDescriptionFeed deserializedRuleDescriptionFeed = new RuleDescriptionFeed();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionFeed.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionFeed.title = Title.fromXml(reader, "title");
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionFeed.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("link".equals(elementName.getLocalPart())) {
                    deserializedRuleDescriptionFeed.link.add(ResponseLink.fromXml(reader, "link"));
                    continue;
                }
                if ("entry".equals(elementName.getLocalPart())) {
                    deserializedRuleDescriptionFeed.entry.add(RuleDescriptionEntry.fromXml(reader, "entry"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedRuleDescriptionFeed;
        });
    }
}

