// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementClient;
import com.azure.resourcemanager.apimanagement.implementation.AllPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiDiagnosticsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiExportsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiGatewayConfigConnectionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiGatewaysImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiIssueAttachmentsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiIssueCommentsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiIssuesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientBuilder;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementGatewaySkusImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementOperationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementServiceSkusImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementServicesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementSkusImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementWorkspaceLinkOperationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementWorkspaceLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiOperationPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiOperationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiProductsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiReleasesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiRevisionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiSchemasImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiTagDescriptionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiVersionSetsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiWikisImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiWikisOperationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApisImpl;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationAccessPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationLoginLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationProvidersImpl;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationServersImpl;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.BackendsImpl;
import com.azure.resourcemanager.apimanagement.implementation.CachesImpl;
import com.azure.resourcemanager.apimanagement.implementation.CertificatesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ContentItemsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ContentTypesImpl;
import com.azure.resourcemanager.apimanagement.implementation.DelegationSettingsImpl;
import com.azure.resourcemanager.apimanagement.implementation.DeletedServicesImpl;
import com.azure.resourcemanager.apimanagement.implementation.DiagnosticsImpl;
import com.azure.resourcemanager.apimanagement.implementation.DocumentationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.EmailTemplatesImpl;
import com.azure.resourcemanager.apimanagement.implementation.GatewayApisImpl;
import com.azure.resourcemanager.apimanagement.implementation.GatewayCertificateAuthoritiesImpl;
import com.azure.resourcemanager.apimanagement.implementation.GatewayHostnameConfigurationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.GatewaysImpl;
import com.azure.resourcemanager.apimanagement.implementation.GlobalSchemasImpl;
import com.azure.resourcemanager.apimanagement.implementation.GraphQLApiResolverPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.GraphQLApiResolversImpl;
import com.azure.resourcemanager.apimanagement.implementation.GroupUsersImpl;
import com.azure.resourcemanager.apimanagement.implementation.GroupsImpl;
import com.azure.resourcemanager.apimanagement.implementation.IdentityProvidersImpl;
import com.azure.resourcemanager.apimanagement.implementation.IssuesImpl;
import com.azure.resourcemanager.apimanagement.implementation.LoggersImpl;
import com.azure.resourcemanager.apimanagement.implementation.NamedValuesImpl;
import com.azure.resourcemanager.apimanagement.implementation.NetworkStatusImpl;
import com.azure.resourcemanager.apimanagement.implementation.NotificationRecipientEmailsImpl;
import com.azure.resourcemanager.apimanagement.implementation.NotificationRecipientUsersImpl;
import com.azure.resourcemanager.apimanagement.implementation.NotificationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.OpenIdConnectProvidersImpl;
import com.azure.resourcemanager.apimanagement.implementation.OperationStatusImpl;
import com.azure.resourcemanager.apimanagement.implementation.OperationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.OperationsResultsImpl;
import com.azure.resourcemanager.apimanagement.implementation.OutboundNetworkDependenciesEndpointsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.PolicyDescriptionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PolicyFragmentsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PolicyRestrictionValidationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PolicyRestrictionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PortalConfigsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PortalRevisionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PortalSettingsImpl;
import com.azure.resourcemanager.apimanagement.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductApiLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductApisImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductGroupLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductGroupsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductSubscriptionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductWikisImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductWikisOperationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ProductsImpl;
import com.azure.resourcemanager.apimanagement.implementation.QuotaByCounterKeysImpl;
import com.azure.resourcemanager.apimanagement.implementation.QuotaByPeriodKeysImpl;
import com.azure.resourcemanager.apimanagement.implementation.RegionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ReportsImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.apimanagement.implementation.SignInSettingsImpl;
import com.azure.resourcemanager.apimanagement.implementation.SignUpSettingsImpl;
import com.azure.resourcemanager.apimanagement.implementation.SubscriptionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.TagApiLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.TagOperationLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.TagProductLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.TagResourcesImpl;
import com.azure.resourcemanager.apimanagement.implementation.TagsImpl;
import com.azure.resourcemanager.apimanagement.implementation.TenantAccessGitsImpl;
import com.azure.resourcemanager.apimanagement.implementation.TenantAccessImpl;
import com.azure.resourcemanager.apimanagement.implementation.TenantConfigurationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.TenantSettingsImpl;
import com.azure.resourcemanager.apimanagement.implementation.UserConfirmationPasswordsImpl;
import com.azure.resourcemanager.apimanagement.implementation.UserGroupsImpl;
import com.azure.resourcemanager.apimanagement.implementation.UserIdentitiesImpl;
import com.azure.resourcemanager.apimanagement.implementation.UserSubscriptionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.UsersImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiDiagnosticsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiExportsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiOperationPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiOperationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiReleasesImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiRevisionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiSchemasImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApiVersionSetsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceApisImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceBackendsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceCertificatesImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceDiagnosticsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceGlobalSchemasImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceGroupUsersImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceGroupsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceLoggersImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceNamedValuesImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceNotificationRecipientEmailsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceNotificationRecipientUsersImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceNotificationsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspacePoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspacePolicyFragmentsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceProductApiLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceProductGroupLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceProductPoliciesImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceProductsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceSubscriptionsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceTagApiLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceTagOperationLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceTagProductLinksImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspaceTagsImpl;
import com.azure.resourcemanager.apimanagement.implementation.WorkspacesImpl;
import com.azure.resourcemanager.apimanagement.models.AllPolicies;
import com.azure.resourcemanager.apimanagement.models.ApiDiagnostics;
import com.azure.resourcemanager.apimanagement.models.ApiExports;
import com.azure.resourcemanager.apimanagement.models.ApiGatewayConfigConnections;
import com.azure.resourcemanager.apimanagement.models.ApiGateways;
import com.azure.resourcemanager.apimanagement.models.ApiIssueAttachments;
import com.azure.resourcemanager.apimanagement.models.ApiIssueComments;
import com.azure.resourcemanager.apimanagement.models.ApiIssues;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkus;
import com.azure.resourcemanager.apimanagement.models.ApiManagementOperations;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkus;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServices;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkus;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinkOperations;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinks;
import com.azure.resourcemanager.apimanagement.models.ApiOperationPolicies;
import com.azure.resourcemanager.apimanagement.models.ApiOperations;
import com.azure.resourcemanager.apimanagement.models.ApiPolicies;
import com.azure.resourcemanager.apimanagement.models.ApiProducts;
import com.azure.resourcemanager.apimanagement.models.ApiReleases;
import com.azure.resourcemanager.apimanagement.models.ApiRevisions;
import com.azure.resourcemanager.apimanagement.models.ApiSchemas;
import com.azure.resourcemanager.apimanagement.models.ApiTagDescriptions;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSets;
import com.azure.resourcemanager.apimanagement.models.ApiWikis;
import com.azure.resourcemanager.apimanagement.models.ApiWikisOperations;
import com.azure.resourcemanager.apimanagement.models.Apis;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPolicies;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginLinks;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviders;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServers;
import com.azure.resourcemanager.apimanagement.models.Authorizations;
import com.azure.resourcemanager.apimanagement.models.Backends;
import com.azure.resourcemanager.apimanagement.models.Caches;
import com.azure.resourcemanager.apimanagement.models.Certificates;
import com.azure.resourcemanager.apimanagement.models.ContentItems;
import com.azure.resourcemanager.apimanagement.models.ContentTypes;
import com.azure.resourcemanager.apimanagement.models.DelegationSettings;
import com.azure.resourcemanager.apimanagement.models.DeletedServices;
import com.azure.resourcemanager.apimanagement.models.Diagnostics;
import com.azure.resourcemanager.apimanagement.models.Documentations;
import com.azure.resourcemanager.apimanagement.models.EmailTemplates;
import com.azure.resourcemanager.apimanagement.models.GatewayApis;
import com.azure.resourcemanager.apimanagement.models.GatewayCertificateAuthorities;
import com.azure.resourcemanager.apimanagement.models.GatewayHostnameConfigurations;
import com.azure.resourcemanager.apimanagement.models.Gateways;
import com.azure.resourcemanager.apimanagement.models.GlobalSchemas;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPolicies;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolvers;
import com.azure.resourcemanager.apimanagement.models.GroupUsers;
import com.azure.resourcemanager.apimanagement.models.Groups;
import com.azure.resourcemanager.apimanagement.models.IdentityProviders;
import com.azure.resourcemanager.apimanagement.models.Issues;
import com.azure.resourcemanager.apimanagement.models.Loggers;
import com.azure.resourcemanager.apimanagement.models.NamedValues;
import com.azure.resourcemanager.apimanagement.models.NetworkStatus;
import com.azure.resourcemanager.apimanagement.models.NotificationRecipientEmails;
import com.azure.resourcemanager.apimanagement.models.NotificationRecipientUsers;
import com.azure.resourcemanager.apimanagement.models.Notifications;
import com.azure.resourcemanager.apimanagement.models.OpenIdConnectProviders;
import com.azure.resourcemanager.apimanagement.models.OperationStatus;
import com.azure.resourcemanager.apimanagement.models.Operations;
import com.azure.resourcemanager.apimanagement.models.OperationsResults;
import com.azure.resourcemanager.apimanagement.models.OutboundNetworkDependenciesEndpoints;
import com.azure.resourcemanager.apimanagement.models.Policies;
import com.azure.resourcemanager.apimanagement.models.PolicyDescriptions;
import com.azure.resourcemanager.apimanagement.models.PolicyFragments;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionValidations;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictions;
import com.azure.resourcemanager.apimanagement.models.PortalConfigs;
import com.azure.resourcemanager.apimanagement.models.PortalRevisions;
import com.azure.resourcemanager.apimanagement.models.PortalSettings;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnections;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinks;
import com.azure.resourcemanager.apimanagement.models.ProductApis;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinks;
import com.azure.resourcemanager.apimanagement.models.ProductGroups;
import com.azure.resourcemanager.apimanagement.models.ProductPolicies;
import com.azure.resourcemanager.apimanagement.models.ProductSubscriptions;
import com.azure.resourcemanager.apimanagement.models.ProductWikis;
import com.azure.resourcemanager.apimanagement.models.ProductWikisOperations;
import com.azure.resourcemanager.apimanagement.models.Products;
import com.azure.resourcemanager.apimanagement.models.QuotaByCounterKeys;
import com.azure.resourcemanager.apimanagement.models.QuotaByPeriodKeys;
import com.azure.resourcemanager.apimanagement.models.Regions;
import com.azure.resourcemanager.apimanagement.models.Reports;
import com.azure.resourcemanager.apimanagement.models.ResourceProviders;
import com.azure.resourcemanager.apimanagement.models.SignInSettings;
import com.azure.resourcemanager.apimanagement.models.SignUpSettings;
import com.azure.resourcemanager.apimanagement.models.Subscriptions;
import com.azure.resourcemanager.apimanagement.models.TagApiLinks;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinks;
import com.azure.resourcemanager.apimanagement.models.TagProductLinks;
import com.azure.resourcemanager.apimanagement.models.TagResources;
import com.azure.resourcemanager.apimanagement.models.Tags;
import com.azure.resourcemanager.apimanagement.models.TenantAccess;
import com.azure.resourcemanager.apimanagement.models.TenantAccessGits;
import com.azure.resourcemanager.apimanagement.models.TenantConfigurations;
import com.azure.resourcemanager.apimanagement.models.TenantSettings;
import com.azure.resourcemanager.apimanagement.models.UserConfirmationPasswords;
import com.azure.resourcemanager.apimanagement.models.UserGroups;
import com.azure.resourcemanager.apimanagement.models.UserIdentities;
import com.azure.resourcemanager.apimanagement.models.UserSubscriptions;
import com.azure.resourcemanager.apimanagement.models.Users;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiDiagnostics;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiExports;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationPolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperations;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiPolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiReleases;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiRevisions;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiSchemas;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiVersionSets;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApis;
import com.azure.resourcemanager.apimanagement.models.WorkspaceBackends;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificates;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnostics;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGlobalSchemas;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupUsers;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroups;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLoggers;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNamedValues;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNotificationRecipientEmails;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNotificationRecipientUsers;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNotifications;
import com.azure.resourcemanager.apimanagement.models.WorkspacePolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspacePolicyFragments;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductApiLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductGroupLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductPolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProducts;
import com.azure.resourcemanager.apimanagement.models.WorkspaceSubscriptions;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagApiLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagOperationLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagProductLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTags;
import com.azure.resourcemanager.apimanagement.models.Workspaces;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Entry point to ApiManagementManager.
 * ApiManagement Client.
 */
public final class ApiManagementManager {
    private ApiGateways apiGateways;

    private ApiManagementGatewaySkus apiManagementGatewaySkus;

    private AllPolicies allPolicies;

    private Apis apis;

    private ApiRevisions apiRevisions;

    private ApiReleases apiReleases;

    private ApiOperations apiOperations;

    private ApiOperationPolicies apiOperationPolicies;

    private Tags tags;

    private GraphQLApiResolvers graphQLApiResolvers;

    private GraphQLApiResolverPolicies graphQLApiResolverPolicies;

    private ApiProducts apiProducts;

    private ApiPolicies apiPolicies;

    private ApiSchemas apiSchemas;

    private ApiDiagnostics apiDiagnostics;

    private ApiIssues apiIssues;

    private ApiIssueComments apiIssueComments;

    private ApiIssueAttachments apiIssueAttachments;

    private ApiTagDescriptions apiTagDescriptions;

    private Operations operations;

    private ApiWikis apiWikis;

    private ApiWikisOperations apiWikisOperations;

    private ApiExports apiExports;

    private ApiVersionSets apiVersionSets;

    private AuthorizationProviders authorizationProviders;

    private Authorizations authorizations;

    private AuthorizationLoginLinks authorizationLoginLinks;

    private AuthorizationAccessPolicies authorizationAccessPolicies;

    private AuthorizationServers authorizationServers;

    private Backends backends;

    private Caches caches;

    private Certificates certificates;

    private ResourceProviders resourceProviders;

    private ContentTypes contentTypes;

    private ContentItems contentItems;

    private DeletedServices deletedServices;

    private ApiManagementOperations apiManagementOperations;

    private ApiManagementServiceSkus apiManagementServiceSkus;

    private ApiManagementServices apiManagementServices;

    private Diagnostics diagnostics;

    private Documentations documentations;

    private EmailTemplates emailTemplates;

    private ApiGatewayConfigConnections apiGatewayConfigConnections;

    private Gateways gateways;

    private GatewayHostnameConfigurations gatewayHostnameConfigurations;

    private GatewayApis gatewayApis;

    private GatewayCertificateAuthorities gatewayCertificateAuthorities;

    private Groups groups;

    private GroupUsers groupUsers;

    private IdentityProviders identityProviders;

    private Issues issues;

    private Loggers loggers;

    private NamedValues namedValues;

    private NetworkStatus networkStatus;

    private Notifications notifications;

    private NotificationRecipientUsers notificationRecipientUsers;

    private NotificationRecipientEmails notificationRecipientEmails;

    private OpenIdConnectProviders openIdConnectProviders;

    private OutboundNetworkDependenciesEndpoints outboundNetworkDependenciesEndpoints;

    private Policies policies;

    private PolicyDescriptions policyDescriptions;

    private PolicyFragments policyFragments;

    private PolicyRestrictions policyRestrictions;

    private PolicyRestrictionValidations policyRestrictionValidations;

    private PortalConfigs portalConfigs;

    private PortalRevisions portalRevisions;

    private PortalSettings portalSettings;

    private SignInSettings signInSettings;

    private SignUpSettings signUpSettings;

    private DelegationSettings delegationSettings;

    private PrivateEndpointConnections privateEndpointConnections;

    private Products products;

    private ProductApis productApis;

    private ProductGroups productGroups;

    private ProductSubscriptions productSubscriptions;

    private ProductPolicies productPolicies;

    private ProductWikis productWikis;

    private ProductWikisOperations productWikisOperations;

    private ProductApiLinks productApiLinks;

    private ProductGroupLinks productGroupLinks;

    private QuotaByCounterKeys quotaByCounterKeys;

    private QuotaByPeriodKeys quotaByPeriodKeys;

    private Regions regions;

    private Reports reports;

    private GlobalSchemas globalSchemas;

    private TenantSettings tenantSettings;

    private ApiManagementSkus apiManagementSkus;

    private Subscriptions subscriptions;

    private TagResources tagResources;

    private TagApiLinks tagApiLinks;

    private TagOperationLinks tagOperationLinks;

    private TagProductLinks tagProductLinks;

    private TenantAccess tenantAccess;

    private TenantAccessGits tenantAccessGits;

    private TenantConfigurations tenantConfigurations;

    private Users users;

    private UserGroups userGroups;

    private UserSubscriptions userSubscriptions;

    private UserIdentities userIdentities;

    private UserConfirmationPasswords userConfirmationPasswords;

    private WorkspaceBackends workspaceBackends;

    private WorkspaceCertificates workspaceCertificates;

    private WorkspaceDiagnostics workspaceDiagnostics;

    private WorkspaceApiDiagnostics workspaceApiDiagnostics;

    private ApiManagementWorkspaceLinks apiManagementWorkspaceLinks;

    private ApiManagementWorkspaceLinkOperations apiManagementWorkspaceLinkOperations;

    private WorkspaceLoggers workspaceLoggers;

    private Workspaces workspaces;

    private WorkspacePolicies workspacePolicies;

    private WorkspaceNamedValues workspaceNamedValues;

    private WorkspaceGlobalSchemas workspaceGlobalSchemas;

    private WorkspaceNotifications workspaceNotifications;

    private WorkspaceNotificationRecipientUsers workspaceNotificationRecipientUsers;

    private WorkspaceNotificationRecipientEmails workspaceNotificationRecipientEmails;

    private WorkspacePolicyFragments workspacePolicyFragments;

    private WorkspaceGroups workspaceGroups;

    private WorkspaceGroupUsers workspaceGroupUsers;

    private WorkspaceSubscriptions workspaceSubscriptions;

    private WorkspaceApiVersionSets workspaceApiVersionSets;

    private WorkspaceApis workspaceApis;

    private WorkspaceApiRevisions workspaceApiRevisions;

    private WorkspaceApiReleases workspaceApiReleases;

    private WorkspaceApiOperations workspaceApiOperations;

    private WorkspaceApiOperationPolicies workspaceApiOperationPolicies;

    private WorkspaceApiPolicies workspaceApiPolicies;

    private WorkspaceApiSchemas workspaceApiSchemas;

    private WorkspaceProducts workspaceProducts;

    private WorkspaceProductApiLinks workspaceProductApiLinks;

    private WorkspaceProductGroupLinks workspaceProductGroupLinks;

    private WorkspaceProductPolicies workspaceProductPolicies;

    private WorkspaceTags workspaceTags;

    private WorkspaceTagApiLinks workspaceTagApiLinks;

    private WorkspaceTagOperationLinks workspaceTagOperationLinks;

    private WorkspaceTagProductLinks workspaceTagProductLinks;

    private WorkspaceApiExports workspaceApiExports;

    private OperationStatus operationStatus;

    private OperationsResults operationsResults;

    private final ApiManagementClient clientObject;

    private ApiManagementManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new ApiManagementClientBuilder().pipeline(httpPipeline)
            .endpoint(profile.getEnvironment().getResourceManagerEndpoint())
            .subscriptionId(profile.getSubscriptionId())
            .defaultPollInterval(defaultPollInterval)
            .buildClient();
    }

    /**
     * Creates an instance of ApiManagement service API entry point.
     * 
     * @param credential the credential to use.
     * @param profile the Azure profile for client.
     * @return the ApiManagement service API instance.
     */
    public static ApiManagementManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return configure().authenticate(credential, profile);
    }

    /**
     * Creates an instance of ApiManagement service API entry point.
     * 
     * @param httpPipeline the {@link HttpPipeline} configured with Azure authentication credential.
     * @param profile the Azure profile for client.
     * @return the ApiManagement service API instance.
     */
    public static ApiManagementManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ApiManagementManager(httpPipeline, profile, null);
    }

    /**
     * Gets a Configurable instance that can be used to create ApiManagementManager with optional configuration.
     * 
     * @return the Configurable instance allowing configurations.
     */
    public static Configurable configure() {
        return new ApiManagementManager.Configurable();
    }

    /**
     * The Configurable allowing configurations to be set.
     */
    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES
            = CoreUtils.getProperties("azure-resourcemanager-apimanagement.properties");

        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<>();
        private final List<String> scopes = new ArrayList<>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        /**
         * Sets the http client.
         *
         * @param httpClient the HTTP client.
         * @return the configurable object itself.
         */
        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        /**
         * Sets the logging options to the HTTP pipeline.
         *
         * @param httpLogOptions the HTTP log options.
         * @return the configurable object itself.
         */
        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        /**
         * Adds the pipeline policy to the HTTP pipeline.
         *
         * @param policy the HTTP pipeline policy.
         * @return the configurable object itself.
         */
        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        /**
         * Adds the scope to permission sets.
         *
         * @param scope the scope.
         * @return the configurable object itself.
         */
        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        /**
         * Sets the retry policy to the HTTP pipeline.
         *
         * @param retryPolicy the HTTP pipeline retry policy.
         * @return the configurable object itself.
         */
        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        /**
         * Sets the retry options for the HTTP pipeline retry policy.
         * <p>
         * This setting has no effect, if retry policy is set via {@link #withRetryPolicy(RetryPolicy)}.
         *
         * @param retryOptions the retry options for the HTTP pipeline retry policy.
         * @return the configurable object itself.
         */
        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        /**
         * Sets the default poll interval, used when service does not provide "Retry-After" header.
         *
         * @param defaultPollInterval the default poll interval.
         * @return the configurable object itself.
         */
        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval
                = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER
                    .logExceptionAsError(new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        /**
         * Creates an instance of ApiManagement service API entry point.
         *
         * @param credential the credential to use.
         * @param profile the Azure profile for client.
         * @return the ApiManagement service API instance.
         */
        public ApiManagementManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");

            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");

            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java")
                .append("-")
                .append("com.azure.resourcemanager.apimanagement")
                .append("/")
                .append(clientVersion);
            if (!Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", false)) {
                userAgentBuilder.append(" (")
                    .append(Configuration.getGlobalConfiguration().get("java.version"))
                    .append("; ")
                    .append(Configuration.getGlobalConfiguration().get("os.name"))
                    .append("; ")
                    .append(Configuration.getGlobalConfiguration().get("os.version"))
                    .append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }

            if (scopes.isEmpty()) {
                scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (retryPolicy == null) {
                if (retryOptions != null) {
                    retryPolicy = new RetryPolicy(retryOptions);
                } else {
                    retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
                }
            }
            List<HttpPipelinePolicy> policies = new ArrayList<>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream()
                .filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL)
                .collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream()
                .filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY)
                .collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(httpClient)
                .policies(policies.toArray(new HttpPipelinePolicy[0]))
                .build();
            return new ApiManagementManager(httpPipeline, profile, defaultPollInterval);
        }
    }

    /**
     * Gets the resource collection API of ApiGateways. It manages ApiManagementGatewayResource.
     * 
     * @return Resource collection API of ApiGateways.
     */
    public ApiGateways apiGateways() {
        if (this.apiGateways == null) {
            this.apiGateways = new ApiGatewaysImpl(clientObject.getApiGateways(), this);
        }
        return apiGateways;
    }

    /**
     * Gets the resource collection API of ApiManagementGatewaySkus.
     * 
     * @return Resource collection API of ApiManagementGatewaySkus.
     */
    public ApiManagementGatewaySkus apiManagementGatewaySkus() {
        if (this.apiManagementGatewaySkus == null) {
            this.apiManagementGatewaySkus
                = new ApiManagementGatewaySkusImpl(clientObject.getApiManagementGatewaySkus(), this);
        }
        return apiManagementGatewaySkus;
    }

    /**
     * Gets the resource collection API of AllPolicies.
     * 
     * @return Resource collection API of AllPolicies.
     */
    public AllPolicies allPolicies() {
        if (this.allPolicies == null) {
            this.allPolicies = new AllPoliciesImpl(clientObject.getAllPolicies(), this);
        }
        return allPolicies;
    }

    /**
     * Gets the resource collection API of Apis. It manages ApiContract.
     * 
     * @return Resource collection API of Apis.
     */
    public Apis apis() {
        if (this.apis == null) {
            this.apis = new ApisImpl(clientObject.getApis(), this);
        }
        return apis;
    }

    /**
     * Gets the resource collection API of ApiRevisions.
     * 
     * @return Resource collection API of ApiRevisions.
     */
    public ApiRevisions apiRevisions() {
        if (this.apiRevisions == null) {
            this.apiRevisions = new ApiRevisionsImpl(clientObject.getApiRevisions(), this);
        }
        return apiRevisions;
    }

    /**
     * Gets the resource collection API of ApiReleases. It manages ApiReleaseContract.
     * 
     * @return Resource collection API of ApiReleases.
     */
    public ApiReleases apiReleases() {
        if (this.apiReleases == null) {
            this.apiReleases = new ApiReleasesImpl(clientObject.getApiReleases(), this);
        }
        return apiReleases;
    }

    /**
     * Gets the resource collection API of ApiOperations. It manages OperationContract.
     * 
     * @return Resource collection API of ApiOperations.
     */
    public ApiOperations apiOperations() {
        if (this.apiOperations == null) {
            this.apiOperations = new ApiOperationsImpl(clientObject.getApiOperations(), this);
        }
        return apiOperations;
    }

    /**
     * Gets the resource collection API of ApiOperationPolicies. It manages PolicyContract.
     * 
     * @return Resource collection API of ApiOperationPolicies.
     */
    public ApiOperationPolicies apiOperationPolicies() {
        if (this.apiOperationPolicies == null) {
            this.apiOperationPolicies = new ApiOperationPoliciesImpl(clientObject.getApiOperationPolicies(), this);
        }
        return apiOperationPolicies;
    }

    /**
     * Gets the resource collection API of Tags. It manages TagContract.
     * 
     * @return Resource collection API of Tags.
     */
    public Tags tags() {
        if (this.tags == null) {
            this.tags = new TagsImpl(clientObject.getTags(), this);
        }
        return tags;
    }

    /**
     * Gets the resource collection API of GraphQLApiResolvers. It manages ResolverContract.
     * 
     * @return Resource collection API of GraphQLApiResolvers.
     */
    public GraphQLApiResolvers graphQLApiResolvers() {
        if (this.graphQLApiResolvers == null) {
            this.graphQLApiResolvers = new GraphQLApiResolversImpl(clientObject.getGraphQLApiResolvers(), this);
        }
        return graphQLApiResolvers;
    }

    /**
     * Gets the resource collection API of GraphQLApiResolverPolicies.
     * 
     * @return Resource collection API of GraphQLApiResolverPolicies.
     */
    public GraphQLApiResolverPolicies graphQLApiResolverPolicies() {
        if (this.graphQLApiResolverPolicies == null) {
            this.graphQLApiResolverPolicies
                = new GraphQLApiResolverPoliciesImpl(clientObject.getGraphQLApiResolverPolicies(), this);
        }
        return graphQLApiResolverPolicies;
    }

    /**
     * Gets the resource collection API of ApiProducts.
     * 
     * @return Resource collection API of ApiProducts.
     */
    public ApiProducts apiProducts() {
        if (this.apiProducts == null) {
            this.apiProducts = new ApiProductsImpl(clientObject.getApiProducts(), this);
        }
        return apiProducts;
    }

    /**
     * Gets the resource collection API of ApiPolicies.
     * 
     * @return Resource collection API of ApiPolicies.
     */
    public ApiPolicies apiPolicies() {
        if (this.apiPolicies == null) {
            this.apiPolicies = new ApiPoliciesImpl(clientObject.getApiPolicies(), this);
        }
        return apiPolicies;
    }

    /**
     * Gets the resource collection API of ApiSchemas. It manages SchemaContract.
     * 
     * @return Resource collection API of ApiSchemas.
     */
    public ApiSchemas apiSchemas() {
        if (this.apiSchemas == null) {
            this.apiSchemas = new ApiSchemasImpl(clientObject.getApiSchemas(), this);
        }
        return apiSchemas;
    }

    /**
     * Gets the resource collection API of ApiDiagnostics. It manages DiagnosticContract.
     * 
     * @return Resource collection API of ApiDiagnostics.
     */
    public ApiDiagnostics apiDiagnostics() {
        if (this.apiDiagnostics == null) {
            this.apiDiagnostics = new ApiDiagnosticsImpl(clientObject.getApiDiagnostics(), this);
        }
        return apiDiagnostics;
    }

    /**
     * Gets the resource collection API of ApiIssues. It manages IssueContract.
     * 
     * @return Resource collection API of ApiIssues.
     */
    public ApiIssues apiIssues() {
        if (this.apiIssues == null) {
            this.apiIssues = new ApiIssuesImpl(clientObject.getApiIssues(), this);
        }
        return apiIssues;
    }

    /**
     * Gets the resource collection API of ApiIssueComments. It manages IssueCommentContract.
     * 
     * @return Resource collection API of ApiIssueComments.
     */
    public ApiIssueComments apiIssueComments() {
        if (this.apiIssueComments == null) {
            this.apiIssueComments = new ApiIssueCommentsImpl(clientObject.getApiIssueComments(), this);
        }
        return apiIssueComments;
    }

    /**
     * Gets the resource collection API of ApiIssueAttachments. It manages IssueAttachmentContract.
     * 
     * @return Resource collection API of ApiIssueAttachments.
     */
    public ApiIssueAttachments apiIssueAttachments() {
        if (this.apiIssueAttachments == null) {
            this.apiIssueAttachments = new ApiIssueAttachmentsImpl(clientObject.getApiIssueAttachments(), this);
        }
        return apiIssueAttachments;
    }

    /**
     * Gets the resource collection API of ApiTagDescriptions. It manages TagDescriptionContract.
     * 
     * @return Resource collection API of ApiTagDescriptions.
     */
    public ApiTagDescriptions apiTagDescriptions() {
        if (this.apiTagDescriptions == null) {
            this.apiTagDescriptions = new ApiTagDescriptionsImpl(clientObject.getApiTagDescriptions(), this);
        }
        return apiTagDescriptions;
    }

    /**
     * Gets the resource collection API of Operations.
     * 
     * @return Resource collection API of Operations.
     */
    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(clientObject.getOperations(), this);
        }
        return operations;
    }

    /**
     * Gets the resource collection API of ApiWikis.
     * 
     * @return Resource collection API of ApiWikis.
     */
    public ApiWikis apiWikis() {
        if (this.apiWikis == null) {
            this.apiWikis = new ApiWikisImpl(clientObject.getApiWikis(), this);
        }
        return apiWikis;
    }

    /**
     * Gets the resource collection API of ApiWikisOperations.
     * 
     * @return Resource collection API of ApiWikisOperations.
     */
    public ApiWikisOperations apiWikisOperations() {
        if (this.apiWikisOperations == null) {
            this.apiWikisOperations = new ApiWikisOperationsImpl(clientObject.getApiWikisOperations(), this);
        }
        return apiWikisOperations;
    }

    /**
     * Gets the resource collection API of ApiExports.
     * 
     * @return Resource collection API of ApiExports.
     */
    public ApiExports apiExports() {
        if (this.apiExports == null) {
            this.apiExports = new ApiExportsImpl(clientObject.getApiExports(), this);
        }
        return apiExports;
    }

    /**
     * Gets the resource collection API of ApiVersionSets. It manages ApiVersionSetContract.
     * 
     * @return Resource collection API of ApiVersionSets.
     */
    public ApiVersionSets apiVersionSets() {
        if (this.apiVersionSets == null) {
            this.apiVersionSets = new ApiVersionSetsImpl(clientObject.getApiVersionSets(), this);
        }
        return apiVersionSets;
    }

    /**
     * Gets the resource collection API of AuthorizationProviders. It manages AuthorizationProviderContract.
     * 
     * @return Resource collection API of AuthorizationProviders.
     */
    public AuthorizationProviders authorizationProviders() {
        if (this.authorizationProviders == null) {
            this.authorizationProviders
                = new AuthorizationProvidersImpl(clientObject.getAuthorizationProviders(), this);
        }
        return authorizationProviders;
    }

    /**
     * Gets the resource collection API of Authorizations. It manages AuthorizationContract.
     * 
     * @return Resource collection API of Authorizations.
     */
    public Authorizations authorizations() {
        if (this.authorizations == null) {
            this.authorizations = new AuthorizationsImpl(clientObject.getAuthorizations(), this);
        }
        return authorizations;
    }

    /**
     * Gets the resource collection API of AuthorizationLoginLinks.
     * 
     * @return Resource collection API of AuthorizationLoginLinks.
     */
    public AuthorizationLoginLinks authorizationLoginLinks() {
        if (this.authorizationLoginLinks == null) {
            this.authorizationLoginLinks
                = new AuthorizationLoginLinksImpl(clientObject.getAuthorizationLoginLinks(), this);
        }
        return authorizationLoginLinks;
    }

    /**
     * Gets the resource collection API of AuthorizationAccessPolicies. It manages AuthorizationAccessPolicyContract.
     * 
     * @return Resource collection API of AuthorizationAccessPolicies.
     */
    public AuthorizationAccessPolicies authorizationAccessPolicies() {
        if (this.authorizationAccessPolicies == null) {
            this.authorizationAccessPolicies
                = new AuthorizationAccessPoliciesImpl(clientObject.getAuthorizationAccessPolicies(), this);
        }
        return authorizationAccessPolicies;
    }

    /**
     * Gets the resource collection API of AuthorizationServers. It manages AuthorizationServerContract.
     * 
     * @return Resource collection API of AuthorizationServers.
     */
    public AuthorizationServers authorizationServers() {
        if (this.authorizationServers == null) {
            this.authorizationServers = new AuthorizationServersImpl(clientObject.getAuthorizationServers(), this);
        }
        return authorizationServers;
    }

    /**
     * Gets the resource collection API of Backends. It manages BackendContract.
     * 
     * @return Resource collection API of Backends.
     */
    public Backends backends() {
        if (this.backends == null) {
            this.backends = new BackendsImpl(clientObject.getBackends(), this);
        }
        return backends;
    }

    /**
     * Gets the resource collection API of Caches. It manages CacheContract.
     * 
     * @return Resource collection API of Caches.
     */
    public Caches caches() {
        if (this.caches == null) {
            this.caches = new CachesImpl(clientObject.getCaches(), this);
        }
        return caches;
    }

    /**
     * Gets the resource collection API of Certificates. It manages CertificateContract.
     * 
     * @return Resource collection API of Certificates.
     */
    public Certificates certificates() {
        if (this.certificates == null) {
            this.certificates = new CertificatesImpl(clientObject.getCertificates(), this);
        }
        return certificates;
    }

    /**
     * Gets the resource collection API of ResourceProviders.
     * 
     * @return Resource collection API of ResourceProviders.
     */
    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(clientObject.getResourceProviders(), this);
        }
        return resourceProviders;
    }

    /**
     * Gets the resource collection API of ContentTypes. It manages ContentTypeContract.
     * 
     * @return Resource collection API of ContentTypes.
     */
    public ContentTypes contentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new ContentTypesImpl(clientObject.getContentTypes(), this);
        }
        return contentTypes;
    }

    /**
     * Gets the resource collection API of ContentItems. It manages ContentItemContract.
     * 
     * @return Resource collection API of ContentItems.
     */
    public ContentItems contentItems() {
        if (this.contentItems == null) {
            this.contentItems = new ContentItemsImpl(clientObject.getContentItems(), this);
        }
        return contentItems;
    }

    /**
     * Gets the resource collection API of DeletedServices.
     * 
     * @return Resource collection API of DeletedServices.
     */
    public DeletedServices deletedServices() {
        if (this.deletedServices == null) {
            this.deletedServices = new DeletedServicesImpl(clientObject.getDeletedServices(), this);
        }
        return deletedServices;
    }

    /**
     * Gets the resource collection API of ApiManagementOperations.
     * 
     * @return Resource collection API of ApiManagementOperations.
     */
    public ApiManagementOperations apiManagementOperations() {
        if (this.apiManagementOperations == null) {
            this.apiManagementOperations
                = new ApiManagementOperationsImpl(clientObject.getApiManagementOperations(), this);
        }
        return apiManagementOperations;
    }

    /**
     * Gets the resource collection API of ApiManagementServiceSkus.
     * 
     * @return Resource collection API of ApiManagementServiceSkus.
     */
    public ApiManagementServiceSkus apiManagementServiceSkus() {
        if (this.apiManagementServiceSkus == null) {
            this.apiManagementServiceSkus
                = new ApiManagementServiceSkusImpl(clientObject.getApiManagementServiceSkus(), this);
        }
        return apiManagementServiceSkus;
    }

    /**
     * Gets the resource collection API of ApiManagementServices. It manages ApiManagementServiceResource.
     * 
     * @return Resource collection API of ApiManagementServices.
     */
    public ApiManagementServices apiManagementServices() {
        if (this.apiManagementServices == null) {
            this.apiManagementServices = new ApiManagementServicesImpl(clientObject.getApiManagementServices(), this);
        }
        return apiManagementServices;
    }

    /**
     * Gets the resource collection API of Diagnostics.
     * 
     * @return Resource collection API of Diagnostics.
     */
    public Diagnostics diagnostics() {
        if (this.diagnostics == null) {
            this.diagnostics = new DiagnosticsImpl(clientObject.getDiagnostics(), this);
        }
        return diagnostics;
    }

    /**
     * Gets the resource collection API of Documentations. It manages DocumentationContract.
     * 
     * @return Resource collection API of Documentations.
     */
    public Documentations documentations() {
        if (this.documentations == null) {
            this.documentations = new DocumentationsImpl(clientObject.getDocumentations(), this);
        }
        return documentations;
    }

    /**
     * Gets the resource collection API of EmailTemplates. It manages EmailTemplateContract.
     * 
     * @return Resource collection API of EmailTemplates.
     */
    public EmailTemplates emailTemplates() {
        if (this.emailTemplates == null) {
            this.emailTemplates = new EmailTemplatesImpl(clientObject.getEmailTemplates(), this);
        }
        return emailTemplates;
    }

    /**
     * Gets the resource collection API of ApiGatewayConfigConnections. It manages
     * ApiManagementGatewayConfigConnectionResource.
     * 
     * @return Resource collection API of ApiGatewayConfigConnections.
     */
    public ApiGatewayConfigConnections apiGatewayConfigConnections() {
        if (this.apiGatewayConfigConnections == null) {
            this.apiGatewayConfigConnections
                = new ApiGatewayConfigConnectionsImpl(clientObject.getApiGatewayConfigConnections(), this);
        }
        return apiGatewayConfigConnections;
    }

    /**
     * Gets the resource collection API of Gateways. It manages GatewayContract.
     * 
     * @return Resource collection API of Gateways.
     */
    public Gateways gateways() {
        if (this.gateways == null) {
            this.gateways = new GatewaysImpl(clientObject.getGateways(), this);
        }
        return gateways;
    }

    /**
     * Gets the resource collection API of GatewayHostnameConfigurations. It manages
     * GatewayHostnameConfigurationContract.
     * 
     * @return Resource collection API of GatewayHostnameConfigurations.
     */
    public GatewayHostnameConfigurations gatewayHostnameConfigurations() {
        if (this.gatewayHostnameConfigurations == null) {
            this.gatewayHostnameConfigurations
                = new GatewayHostnameConfigurationsImpl(clientObject.getGatewayHostnameConfigurations(), this);
        }
        return gatewayHostnameConfigurations;
    }

    /**
     * Gets the resource collection API of GatewayApis.
     * 
     * @return Resource collection API of GatewayApis.
     */
    public GatewayApis gatewayApis() {
        if (this.gatewayApis == null) {
            this.gatewayApis = new GatewayApisImpl(clientObject.getGatewayApis(), this);
        }
        return gatewayApis;
    }

    /**
     * Gets the resource collection API of GatewayCertificateAuthorities. It manages
     * GatewayCertificateAuthorityContract.
     * 
     * @return Resource collection API of GatewayCertificateAuthorities.
     */
    public GatewayCertificateAuthorities gatewayCertificateAuthorities() {
        if (this.gatewayCertificateAuthorities == null) {
            this.gatewayCertificateAuthorities
                = new GatewayCertificateAuthoritiesImpl(clientObject.getGatewayCertificateAuthorities(), this);
        }
        return gatewayCertificateAuthorities;
    }

    /**
     * Gets the resource collection API of Groups. It manages GroupContract.
     * 
     * @return Resource collection API of Groups.
     */
    public Groups groups() {
        if (this.groups == null) {
            this.groups = new GroupsImpl(clientObject.getGroups(), this);
        }
        return groups;
    }

    /**
     * Gets the resource collection API of GroupUsers.
     * 
     * @return Resource collection API of GroupUsers.
     */
    public GroupUsers groupUsers() {
        if (this.groupUsers == null) {
            this.groupUsers = new GroupUsersImpl(clientObject.getGroupUsers(), this);
        }
        return groupUsers;
    }

    /**
     * Gets the resource collection API of IdentityProviders. It manages IdentityProviderContract.
     * 
     * @return Resource collection API of IdentityProviders.
     */
    public IdentityProviders identityProviders() {
        if (this.identityProviders == null) {
            this.identityProviders = new IdentityProvidersImpl(clientObject.getIdentityProviders(), this);
        }
        return identityProviders;
    }

    /**
     * Gets the resource collection API of Issues.
     * 
     * @return Resource collection API of Issues.
     */
    public Issues issues() {
        if (this.issues == null) {
            this.issues = new IssuesImpl(clientObject.getIssues(), this);
        }
        return issues;
    }

    /**
     * Gets the resource collection API of Loggers. It manages LoggerContract.
     * 
     * @return Resource collection API of Loggers.
     */
    public Loggers loggers() {
        if (this.loggers == null) {
            this.loggers = new LoggersImpl(clientObject.getLoggers(), this);
        }
        return loggers;
    }

    /**
     * Gets the resource collection API of NamedValues. It manages NamedValueContract.
     * 
     * @return Resource collection API of NamedValues.
     */
    public NamedValues namedValues() {
        if (this.namedValues == null) {
            this.namedValues = new NamedValuesImpl(clientObject.getNamedValues(), this);
        }
        return namedValues;
    }

    /**
     * Gets the resource collection API of NetworkStatus.
     * 
     * @return Resource collection API of NetworkStatus.
     */
    public NetworkStatus networkStatus() {
        if (this.networkStatus == null) {
            this.networkStatus = new NetworkStatusImpl(clientObject.getNetworkStatus(), this);
        }
        return networkStatus;
    }

    /**
     * Gets the resource collection API of Notifications.
     * 
     * @return Resource collection API of Notifications.
     */
    public Notifications notifications() {
        if (this.notifications == null) {
            this.notifications = new NotificationsImpl(clientObject.getNotifications(), this);
        }
        return notifications;
    }

    /**
     * Gets the resource collection API of NotificationRecipientUsers.
     * 
     * @return Resource collection API of NotificationRecipientUsers.
     */
    public NotificationRecipientUsers notificationRecipientUsers() {
        if (this.notificationRecipientUsers == null) {
            this.notificationRecipientUsers
                = new NotificationRecipientUsersImpl(clientObject.getNotificationRecipientUsers(), this);
        }
        return notificationRecipientUsers;
    }

    /**
     * Gets the resource collection API of NotificationRecipientEmails.
     * 
     * @return Resource collection API of NotificationRecipientEmails.
     */
    public NotificationRecipientEmails notificationRecipientEmails() {
        if (this.notificationRecipientEmails == null) {
            this.notificationRecipientEmails
                = new NotificationRecipientEmailsImpl(clientObject.getNotificationRecipientEmails(), this);
        }
        return notificationRecipientEmails;
    }

    /**
     * Gets the resource collection API of OpenIdConnectProviders. It manages OpenidConnectProviderContract.
     * 
     * @return Resource collection API of OpenIdConnectProviders.
     */
    public OpenIdConnectProviders openIdConnectProviders() {
        if (this.openIdConnectProviders == null) {
            this.openIdConnectProviders
                = new OpenIdConnectProvidersImpl(clientObject.getOpenIdConnectProviders(), this);
        }
        return openIdConnectProviders;
    }

    /**
     * Gets the resource collection API of OutboundNetworkDependenciesEndpoints.
     * 
     * @return Resource collection API of OutboundNetworkDependenciesEndpoints.
     */
    public OutboundNetworkDependenciesEndpoints outboundNetworkDependenciesEndpoints() {
        if (this.outboundNetworkDependenciesEndpoints == null) {
            this.outboundNetworkDependenciesEndpoints = new OutboundNetworkDependenciesEndpointsImpl(
                clientObject.getOutboundNetworkDependenciesEndpoints(), this);
        }
        return outboundNetworkDependenciesEndpoints;
    }

    /**
     * Gets the resource collection API of Policies.
     * 
     * @return Resource collection API of Policies.
     */
    public Policies policies() {
        if (this.policies == null) {
            this.policies = new PoliciesImpl(clientObject.getPolicies(), this);
        }
        return policies;
    }

    /**
     * Gets the resource collection API of PolicyDescriptions.
     * 
     * @return Resource collection API of PolicyDescriptions.
     */
    public PolicyDescriptions policyDescriptions() {
        if (this.policyDescriptions == null) {
            this.policyDescriptions = new PolicyDescriptionsImpl(clientObject.getPolicyDescriptions(), this);
        }
        return policyDescriptions;
    }

    /**
     * Gets the resource collection API of PolicyFragments. It manages PolicyFragmentContract.
     * 
     * @return Resource collection API of PolicyFragments.
     */
    public PolicyFragments policyFragments() {
        if (this.policyFragments == null) {
            this.policyFragments = new PolicyFragmentsImpl(clientObject.getPolicyFragments(), this);
        }
        return policyFragments;
    }

    /**
     * Gets the resource collection API of PolicyRestrictions. It manages PolicyRestrictionContract.
     * 
     * @return Resource collection API of PolicyRestrictions.
     */
    public PolicyRestrictions policyRestrictions() {
        if (this.policyRestrictions == null) {
            this.policyRestrictions = new PolicyRestrictionsImpl(clientObject.getPolicyRestrictions(), this);
        }
        return policyRestrictions;
    }

    /**
     * Gets the resource collection API of PolicyRestrictionValidations.
     * 
     * @return Resource collection API of PolicyRestrictionValidations.
     */
    public PolicyRestrictionValidations policyRestrictionValidations() {
        if (this.policyRestrictionValidations == null) {
            this.policyRestrictionValidations
                = new PolicyRestrictionValidationsImpl(clientObject.getPolicyRestrictionValidations(), this);
        }
        return policyRestrictionValidations;
    }

    /**
     * Gets the resource collection API of PortalConfigs. It manages PortalConfigContract.
     * 
     * @return Resource collection API of PortalConfigs.
     */
    public PortalConfigs portalConfigs() {
        if (this.portalConfigs == null) {
            this.portalConfigs = new PortalConfigsImpl(clientObject.getPortalConfigs(), this);
        }
        return portalConfigs;
    }

    /**
     * Gets the resource collection API of PortalRevisions. It manages PortalRevisionContract.
     * 
     * @return Resource collection API of PortalRevisions.
     */
    public PortalRevisions portalRevisions() {
        if (this.portalRevisions == null) {
            this.portalRevisions = new PortalRevisionsImpl(clientObject.getPortalRevisions(), this);
        }
        return portalRevisions;
    }

    /**
     * Gets the resource collection API of PortalSettings.
     * 
     * @return Resource collection API of PortalSettings.
     */
    public PortalSettings portalSettings() {
        if (this.portalSettings == null) {
            this.portalSettings = new PortalSettingsImpl(clientObject.getPortalSettings(), this);
        }
        return portalSettings;
    }

    /**
     * Gets the resource collection API of SignInSettings.
     * 
     * @return Resource collection API of SignInSettings.
     */
    public SignInSettings signInSettings() {
        if (this.signInSettings == null) {
            this.signInSettings = new SignInSettingsImpl(clientObject.getSignInSettings(), this);
        }
        return signInSettings;
    }

    /**
     * Gets the resource collection API of SignUpSettings.
     * 
     * @return Resource collection API of SignUpSettings.
     */
    public SignUpSettings signUpSettings() {
        if (this.signUpSettings == null) {
            this.signUpSettings = new SignUpSettingsImpl(clientObject.getSignUpSettings(), this);
        }
        return signUpSettings;
    }

    /**
     * Gets the resource collection API of DelegationSettings.
     * 
     * @return Resource collection API of DelegationSettings.
     */
    public DelegationSettings delegationSettings() {
        if (this.delegationSettings == null) {
            this.delegationSettings = new DelegationSettingsImpl(clientObject.getDelegationSettings(), this);
        }
        return delegationSettings;
    }

    /**
     * Gets the resource collection API of PrivateEndpointConnections. It manages PrivateEndpointConnection.
     * 
     * @return Resource collection API of PrivateEndpointConnections.
     */
    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections
                = new PrivateEndpointConnectionsImpl(clientObject.getPrivateEndpointConnections(), this);
        }
        return privateEndpointConnections;
    }

    /**
     * Gets the resource collection API of Products. It manages ProductContract.
     * 
     * @return Resource collection API of Products.
     */
    public Products products() {
        if (this.products == null) {
            this.products = new ProductsImpl(clientObject.getProducts(), this);
        }
        return products;
    }

    /**
     * Gets the resource collection API of ProductApis.
     * 
     * @return Resource collection API of ProductApis.
     */
    public ProductApis productApis() {
        if (this.productApis == null) {
            this.productApis = new ProductApisImpl(clientObject.getProductApis(), this);
        }
        return productApis;
    }

    /**
     * Gets the resource collection API of ProductGroups.
     * 
     * @return Resource collection API of ProductGroups.
     */
    public ProductGroups productGroups() {
        if (this.productGroups == null) {
            this.productGroups = new ProductGroupsImpl(clientObject.getProductGroups(), this);
        }
        return productGroups;
    }

    /**
     * Gets the resource collection API of ProductSubscriptions.
     * 
     * @return Resource collection API of ProductSubscriptions.
     */
    public ProductSubscriptions productSubscriptions() {
        if (this.productSubscriptions == null) {
            this.productSubscriptions = new ProductSubscriptionsImpl(clientObject.getProductSubscriptions(), this);
        }
        return productSubscriptions;
    }

    /**
     * Gets the resource collection API of ProductPolicies.
     * 
     * @return Resource collection API of ProductPolicies.
     */
    public ProductPolicies productPolicies() {
        if (this.productPolicies == null) {
            this.productPolicies = new ProductPoliciesImpl(clientObject.getProductPolicies(), this);
        }
        return productPolicies;
    }

    /**
     * Gets the resource collection API of ProductWikis.
     * 
     * @return Resource collection API of ProductWikis.
     */
    public ProductWikis productWikis() {
        if (this.productWikis == null) {
            this.productWikis = new ProductWikisImpl(clientObject.getProductWikis(), this);
        }
        return productWikis;
    }

    /**
     * Gets the resource collection API of ProductWikisOperations.
     * 
     * @return Resource collection API of ProductWikisOperations.
     */
    public ProductWikisOperations productWikisOperations() {
        if (this.productWikisOperations == null) {
            this.productWikisOperations
                = new ProductWikisOperationsImpl(clientObject.getProductWikisOperations(), this);
        }
        return productWikisOperations;
    }

    /**
     * Gets the resource collection API of ProductApiLinks. It manages ProductApiLinkContract.
     * 
     * @return Resource collection API of ProductApiLinks.
     */
    public ProductApiLinks productApiLinks() {
        if (this.productApiLinks == null) {
            this.productApiLinks = new ProductApiLinksImpl(clientObject.getProductApiLinks(), this);
        }
        return productApiLinks;
    }

    /**
     * Gets the resource collection API of ProductGroupLinks. It manages ProductGroupLinkContract.
     * 
     * @return Resource collection API of ProductGroupLinks.
     */
    public ProductGroupLinks productGroupLinks() {
        if (this.productGroupLinks == null) {
            this.productGroupLinks = new ProductGroupLinksImpl(clientObject.getProductGroupLinks(), this);
        }
        return productGroupLinks;
    }

    /**
     * Gets the resource collection API of QuotaByCounterKeys.
     * 
     * @return Resource collection API of QuotaByCounterKeys.
     */
    public QuotaByCounterKeys quotaByCounterKeys() {
        if (this.quotaByCounterKeys == null) {
            this.quotaByCounterKeys = new QuotaByCounterKeysImpl(clientObject.getQuotaByCounterKeys(), this);
        }
        return quotaByCounterKeys;
    }

    /**
     * Gets the resource collection API of QuotaByPeriodKeys.
     * 
     * @return Resource collection API of QuotaByPeriodKeys.
     */
    public QuotaByPeriodKeys quotaByPeriodKeys() {
        if (this.quotaByPeriodKeys == null) {
            this.quotaByPeriodKeys = new QuotaByPeriodKeysImpl(clientObject.getQuotaByPeriodKeys(), this);
        }
        return quotaByPeriodKeys;
    }

    /**
     * Gets the resource collection API of Regions.
     * 
     * @return Resource collection API of Regions.
     */
    public Regions regions() {
        if (this.regions == null) {
            this.regions = new RegionsImpl(clientObject.getRegions(), this);
        }
        return regions;
    }

    /**
     * Gets the resource collection API of Reports.
     * 
     * @return Resource collection API of Reports.
     */
    public Reports reports() {
        if (this.reports == null) {
            this.reports = new ReportsImpl(clientObject.getReports(), this);
        }
        return reports;
    }

    /**
     * Gets the resource collection API of GlobalSchemas. It manages GlobalSchemaContract.
     * 
     * @return Resource collection API of GlobalSchemas.
     */
    public GlobalSchemas globalSchemas() {
        if (this.globalSchemas == null) {
            this.globalSchemas = new GlobalSchemasImpl(clientObject.getGlobalSchemas(), this);
        }
        return globalSchemas;
    }

    /**
     * Gets the resource collection API of TenantSettings.
     * 
     * @return Resource collection API of TenantSettings.
     */
    public TenantSettings tenantSettings() {
        if (this.tenantSettings == null) {
            this.tenantSettings = new TenantSettingsImpl(clientObject.getTenantSettings(), this);
        }
        return tenantSettings;
    }

    /**
     * Gets the resource collection API of ApiManagementSkus.
     * 
     * @return Resource collection API of ApiManagementSkus.
     */
    public ApiManagementSkus apiManagementSkus() {
        if (this.apiManagementSkus == null) {
            this.apiManagementSkus = new ApiManagementSkusImpl(clientObject.getApiManagementSkus(), this);
        }
        return apiManagementSkus;
    }

    /**
     * Gets the resource collection API of Subscriptions.
     * 
     * @return Resource collection API of Subscriptions.
     */
    public Subscriptions subscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new SubscriptionsImpl(clientObject.getSubscriptions(), this);
        }
        return subscriptions;
    }

    /**
     * Gets the resource collection API of TagResources.
     * 
     * @return Resource collection API of TagResources.
     */
    public TagResources tagResources() {
        if (this.tagResources == null) {
            this.tagResources = new TagResourcesImpl(clientObject.getTagResources(), this);
        }
        return tagResources;
    }

    /**
     * Gets the resource collection API of TagApiLinks. It manages TagApiLinkContract.
     * 
     * @return Resource collection API of TagApiLinks.
     */
    public TagApiLinks tagApiLinks() {
        if (this.tagApiLinks == null) {
            this.tagApiLinks = new TagApiLinksImpl(clientObject.getTagApiLinks(), this);
        }
        return tagApiLinks;
    }

    /**
     * Gets the resource collection API of TagOperationLinks. It manages TagOperationLinkContract.
     * 
     * @return Resource collection API of TagOperationLinks.
     */
    public TagOperationLinks tagOperationLinks() {
        if (this.tagOperationLinks == null) {
            this.tagOperationLinks = new TagOperationLinksImpl(clientObject.getTagOperationLinks(), this);
        }
        return tagOperationLinks;
    }

    /**
     * Gets the resource collection API of TagProductLinks. It manages TagProductLinkContract.
     * 
     * @return Resource collection API of TagProductLinks.
     */
    public TagProductLinks tagProductLinks() {
        if (this.tagProductLinks == null) {
            this.tagProductLinks = new TagProductLinksImpl(clientObject.getTagProductLinks(), this);
        }
        return tagProductLinks;
    }

    /**
     * Gets the resource collection API of TenantAccess. It manages AccessInformationContract.
     * 
     * @return Resource collection API of TenantAccess.
     */
    public TenantAccess tenantAccess() {
        if (this.tenantAccess == null) {
            this.tenantAccess = new TenantAccessImpl(clientObject.getTenantAccess(), this);
        }
        return tenantAccess;
    }

    /**
     * Gets the resource collection API of TenantAccessGits.
     * 
     * @return Resource collection API of TenantAccessGits.
     */
    public TenantAccessGits tenantAccessGits() {
        if (this.tenantAccessGits == null) {
            this.tenantAccessGits = new TenantAccessGitsImpl(clientObject.getTenantAccessGits(), this);
        }
        return tenantAccessGits;
    }

    /**
     * Gets the resource collection API of TenantConfigurations.
     * 
     * @return Resource collection API of TenantConfigurations.
     */
    public TenantConfigurations tenantConfigurations() {
        if (this.tenantConfigurations == null) {
            this.tenantConfigurations = new TenantConfigurationsImpl(clientObject.getTenantConfigurations(), this);
        }
        return tenantConfigurations;
    }

    /**
     * Gets the resource collection API of Users. It manages UserContract.
     * 
     * @return Resource collection API of Users.
     */
    public Users users() {
        if (this.users == null) {
            this.users = new UsersImpl(clientObject.getUsers(), this);
        }
        return users;
    }

    /**
     * Gets the resource collection API of UserGroups.
     * 
     * @return Resource collection API of UserGroups.
     */
    public UserGroups userGroups() {
        if (this.userGroups == null) {
            this.userGroups = new UserGroupsImpl(clientObject.getUserGroups(), this);
        }
        return userGroups;
    }

    /**
     * Gets the resource collection API of UserSubscriptions.
     * 
     * @return Resource collection API of UserSubscriptions.
     */
    public UserSubscriptions userSubscriptions() {
        if (this.userSubscriptions == null) {
            this.userSubscriptions = new UserSubscriptionsImpl(clientObject.getUserSubscriptions(), this);
        }
        return userSubscriptions;
    }

    /**
     * Gets the resource collection API of UserIdentities.
     * 
     * @return Resource collection API of UserIdentities.
     */
    public UserIdentities userIdentities() {
        if (this.userIdentities == null) {
            this.userIdentities = new UserIdentitiesImpl(clientObject.getUserIdentities(), this);
        }
        return userIdentities;
    }

    /**
     * Gets the resource collection API of UserConfirmationPasswords.
     * 
     * @return Resource collection API of UserConfirmationPasswords.
     */
    public UserConfirmationPasswords userConfirmationPasswords() {
        if (this.userConfirmationPasswords == null) {
            this.userConfirmationPasswords
                = new UserConfirmationPasswordsImpl(clientObject.getUserConfirmationPasswords(), this);
        }
        return userConfirmationPasswords;
    }

    /**
     * Gets the resource collection API of WorkspaceBackends.
     * 
     * @return Resource collection API of WorkspaceBackends.
     */
    public WorkspaceBackends workspaceBackends() {
        if (this.workspaceBackends == null) {
            this.workspaceBackends = new WorkspaceBackendsImpl(clientObject.getWorkspaceBackends(), this);
        }
        return workspaceBackends;
    }

    /**
     * Gets the resource collection API of WorkspaceCertificates.
     * 
     * @return Resource collection API of WorkspaceCertificates.
     */
    public WorkspaceCertificates workspaceCertificates() {
        if (this.workspaceCertificates == null) {
            this.workspaceCertificates = new WorkspaceCertificatesImpl(clientObject.getWorkspaceCertificates(), this);
        }
        return workspaceCertificates;
    }

    /**
     * Gets the resource collection API of WorkspaceDiagnostics.
     * 
     * @return Resource collection API of WorkspaceDiagnostics.
     */
    public WorkspaceDiagnostics workspaceDiagnostics() {
        if (this.workspaceDiagnostics == null) {
            this.workspaceDiagnostics = new WorkspaceDiagnosticsImpl(clientObject.getWorkspaceDiagnostics(), this);
        }
        return workspaceDiagnostics;
    }

    /**
     * Gets the resource collection API of WorkspaceApiDiagnostics.
     * 
     * @return Resource collection API of WorkspaceApiDiagnostics.
     */
    public WorkspaceApiDiagnostics workspaceApiDiagnostics() {
        if (this.workspaceApiDiagnostics == null) {
            this.workspaceApiDiagnostics
                = new WorkspaceApiDiagnosticsImpl(clientObject.getWorkspaceApiDiagnostics(), this);
        }
        return workspaceApiDiagnostics;
    }

    /**
     * Gets the resource collection API of ApiManagementWorkspaceLinks.
     * 
     * @return Resource collection API of ApiManagementWorkspaceLinks.
     */
    public ApiManagementWorkspaceLinks apiManagementWorkspaceLinks() {
        if (this.apiManagementWorkspaceLinks == null) {
            this.apiManagementWorkspaceLinks
                = new ApiManagementWorkspaceLinksImpl(clientObject.getApiManagementWorkspaceLinks(), this);
        }
        return apiManagementWorkspaceLinks;
    }

    /**
     * Gets the resource collection API of ApiManagementWorkspaceLinkOperations.
     * 
     * @return Resource collection API of ApiManagementWorkspaceLinkOperations.
     */
    public ApiManagementWorkspaceLinkOperations apiManagementWorkspaceLinkOperations() {
        if (this.apiManagementWorkspaceLinkOperations == null) {
            this.apiManagementWorkspaceLinkOperations = new ApiManagementWorkspaceLinkOperationsImpl(
                clientObject.getApiManagementWorkspaceLinkOperations(), this);
        }
        return apiManagementWorkspaceLinkOperations;
    }

    /**
     * Gets the resource collection API of WorkspaceLoggers.
     * 
     * @return Resource collection API of WorkspaceLoggers.
     */
    public WorkspaceLoggers workspaceLoggers() {
        if (this.workspaceLoggers == null) {
            this.workspaceLoggers = new WorkspaceLoggersImpl(clientObject.getWorkspaceLoggers(), this);
        }
        return workspaceLoggers;
    }

    /**
     * Gets the resource collection API of Workspaces. It manages WorkspaceContract.
     * 
     * @return Resource collection API of Workspaces.
     */
    public Workspaces workspaces() {
        if (this.workspaces == null) {
            this.workspaces = new WorkspacesImpl(clientObject.getWorkspaces(), this);
        }
        return workspaces;
    }

    /**
     * Gets the resource collection API of WorkspacePolicies.
     * 
     * @return Resource collection API of WorkspacePolicies.
     */
    public WorkspacePolicies workspacePolicies() {
        if (this.workspacePolicies == null) {
            this.workspacePolicies = new WorkspacePoliciesImpl(clientObject.getWorkspacePolicies(), this);
        }
        return workspacePolicies;
    }

    /**
     * Gets the resource collection API of WorkspaceNamedValues.
     * 
     * @return Resource collection API of WorkspaceNamedValues.
     */
    public WorkspaceNamedValues workspaceNamedValues() {
        if (this.workspaceNamedValues == null) {
            this.workspaceNamedValues = new WorkspaceNamedValuesImpl(clientObject.getWorkspaceNamedValues(), this);
        }
        return workspaceNamedValues;
    }

    /**
     * Gets the resource collection API of WorkspaceGlobalSchemas.
     * 
     * @return Resource collection API of WorkspaceGlobalSchemas.
     */
    public WorkspaceGlobalSchemas workspaceGlobalSchemas() {
        if (this.workspaceGlobalSchemas == null) {
            this.workspaceGlobalSchemas
                = new WorkspaceGlobalSchemasImpl(clientObject.getWorkspaceGlobalSchemas(), this);
        }
        return workspaceGlobalSchemas;
    }

    /**
     * Gets the resource collection API of WorkspaceNotifications.
     * 
     * @return Resource collection API of WorkspaceNotifications.
     */
    public WorkspaceNotifications workspaceNotifications() {
        if (this.workspaceNotifications == null) {
            this.workspaceNotifications
                = new WorkspaceNotificationsImpl(clientObject.getWorkspaceNotifications(), this);
        }
        return workspaceNotifications;
    }

    /**
     * Gets the resource collection API of WorkspaceNotificationRecipientUsers.
     * 
     * @return Resource collection API of WorkspaceNotificationRecipientUsers.
     */
    public WorkspaceNotificationRecipientUsers workspaceNotificationRecipientUsers() {
        if (this.workspaceNotificationRecipientUsers == null) {
            this.workspaceNotificationRecipientUsers = new WorkspaceNotificationRecipientUsersImpl(
                clientObject.getWorkspaceNotificationRecipientUsers(), this);
        }
        return workspaceNotificationRecipientUsers;
    }

    /**
     * Gets the resource collection API of WorkspaceNotificationRecipientEmails.
     * 
     * @return Resource collection API of WorkspaceNotificationRecipientEmails.
     */
    public WorkspaceNotificationRecipientEmails workspaceNotificationRecipientEmails() {
        if (this.workspaceNotificationRecipientEmails == null) {
            this.workspaceNotificationRecipientEmails = new WorkspaceNotificationRecipientEmailsImpl(
                clientObject.getWorkspaceNotificationRecipientEmails(), this);
        }
        return workspaceNotificationRecipientEmails;
    }

    /**
     * Gets the resource collection API of WorkspacePolicyFragments.
     * 
     * @return Resource collection API of WorkspacePolicyFragments.
     */
    public WorkspacePolicyFragments workspacePolicyFragments() {
        if (this.workspacePolicyFragments == null) {
            this.workspacePolicyFragments
                = new WorkspacePolicyFragmentsImpl(clientObject.getWorkspacePolicyFragments(), this);
        }
        return workspacePolicyFragments;
    }

    /**
     * Gets the resource collection API of WorkspaceGroups.
     * 
     * @return Resource collection API of WorkspaceGroups.
     */
    public WorkspaceGroups workspaceGroups() {
        if (this.workspaceGroups == null) {
            this.workspaceGroups = new WorkspaceGroupsImpl(clientObject.getWorkspaceGroups(), this);
        }
        return workspaceGroups;
    }

    /**
     * Gets the resource collection API of WorkspaceGroupUsers.
     * 
     * @return Resource collection API of WorkspaceGroupUsers.
     */
    public WorkspaceGroupUsers workspaceGroupUsers() {
        if (this.workspaceGroupUsers == null) {
            this.workspaceGroupUsers = new WorkspaceGroupUsersImpl(clientObject.getWorkspaceGroupUsers(), this);
        }
        return workspaceGroupUsers;
    }

    /**
     * Gets the resource collection API of WorkspaceSubscriptions.
     * 
     * @return Resource collection API of WorkspaceSubscriptions.
     */
    public WorkspaceSubscriptions workspaceSubscriptions() {
        if (this.workspaceSubscriptions == null) {
            this.workspaceSubscriptions
                = new WorkspaceSubscriptionsImpl(clientObject.getWorkspaceSubscriptions(), this);
        }
        return workspaceSubscriptions;
    }

    /**
     * Gets the resource collection API of WorkspaceApiVersionSets.
     * 
     * @return Resource collection API of WorkspaceApiVersionSets.
     */
    public WorkspaceApiVersionSets workspaceApiVersionSets() {
        if (this.workspaceApiVersionSets == null) {
            this.workspaceApiVersionSets
                = new WorkspaceApiVersionSetsImpl(clientObject.getWorkspaceApiVersionSets(), this);
        }
        return workspaceApiVersionSets;
    }

    /**
     * Gets the resource collection API of WorkspaceApis.
     * 
     * @return Resource collection API of WorkspaceApis.
     */
    public WorkspaceApis workspaceApis() {
        if (this.workspaceApis == null) {
            this.workspaceApis = new WorkspaceApisImpl(clientObject.getWorkspaceApis(), this);
        }
        return workspaceApis;
    }

    /**
     * Gets the resource collection API of WorkspaceApiRevisions.
     * 
     * @return Resource collection API of WorkspaceApiRevisions.
     */
    public WorkspaceApiRevisions workspaceApiRevisions() {
        if (this.workspaceApiRevisions == null) {
            this.workspaceApiRevisions = new WorkspaceApiRevisionsImpl(clientObject.getWorkspaceApiRevisions(), this);
        }
        return workspaceApiRevisions;
    }

    /**
     * Gets the resource collection API of WorkspaceApiReleases.
     * 
     * @return Resource collection API of WorkspaceApiReleases.
     */
    public WorkspaceApiReleases workspaceApiReleases() {
        if (this.workspaceApiReleases == null) {
            this.workspaceApiReleases = new WorkspaceApiReleasesImpl(clientObject.getWorkspaceApiReleases(), this);
        }
        return workspaceApiReleases;
    }

    /**
     * Gets the resource collection API of WorkspaceApiOperations.
     * 
     * @return Resource collection API of WorkspaceApiOperations.
     */
    public WorkspaceApiOperations workspaceApiOperations() {
        if (this.workspaceApiOperations == null) {
            this.workspaceApiOperations
                = new WorkspaceApiOperationsImpl(clientObject.getWorkspaceApiOperations(), this);
        }
        return workspaceApiOperations;
    }

    /**
     * Gets the resource collection API of WorkspaceApiOperationPolicies.
     * 
     * @return Resource collection API of WorkspaceApiOperationPolicies.
     */
    public WorkspaceApiOperationPolicies workspaceApiOperationPolicies() {
        if (this.workspaceApiOperationPolicies == null) {
            this.workspaceApiOperationPolicies
                = new WorkspaceApiOperationPoliciesImpl(clientObject.getWorkspaceApiOperationPolicies(), this);
        }
        return workspaceApiOperationPolicies;
    }

    /**
     * Gets the resource collection API of WorkspaceApiPolicies.
     * 
     * @return Resource collection API of WorkspaceApiPolicies.
     */
    public WorkspaceApiPolicies workspaceApiPolicies() {
        if (this.workspaceApiPolicies == null) {
            this.workspaceApiPolicies = new WorkspaceApiPoliciesImpl(clientObject.getWorkspaceApiPolicies(), this);
        }
        return workspaceApiPolicies;
    }

    /**
     * Gets the resource collection API of WorkspaceApiSchemas.
     * 
     * @return Resource collection API of WorkspaceApiSchemas.
     */
    public WorkspaceApiSchemas workspaceApiSchemas() {
        if (this.workspaceApiSchemas == null) {
            this.workspaceApiSchemas = new WorkspaceApiSchemasImpl(clientObject.getWorkspaceApiSchemas(), this);
        }
        return workspaceApiSchemas;
    }

    /**
     * Gets the resource collection API of WorkspaceProducts.
     * 
     * @return Resource collection API of WorkspaceProducts.
     */
    public WorkspaceProducts workspaceProducts() {
        if (this.workspaceProducts == null) {
            this.workspaceProducts = new WorkspaceProductsImpl(clientObject.getWorkspaceProducts(), this);
        }
        return workspaceProducts;
    }

    /**
     * Gets the resource collection API of WorkspaceProductApiLinks.
     * 
     * @return Resource collection API of WorkspaceProductApiLinks.
     */
    public WorkspaceProductApiLinks workspaceProductApiLinks() {
        if (this.workspaceProductApiLinks == null) {
            this.workspaceProductApiLinks
                = new WorkspaceProductApiLinksImpl(clientObject.getWorkspaceProductApiLinks(), this);
        }
        return workspaceProductApiLinks;
    }

    /**
     * Gets the resource collection API of WorkspaceProductGroupLinks.
     * 
     * @return Resource collection API of WorkspaceProductGroupLinks.
     */
    public WorkspaceProductGroupLinks workspaceProductGroupLinks() {
        if (this.workspaceProductGroupLinks == null) {
            this.workspaceProductGroupLinks
                = new WorkspaceProductGroupLinksImpl(clientObject.getWorkspaceProductGroupLinks(), this);
        }
        return workspaceProductGroupLinks;
    }

    /**
     * Gets the resource collection API of WorkspaceProductPolicies.
     * 
     * @return Resource collection API of WorkspaceProductPolicies.
     */
    public WorkspaceProductPolicies workspaceProductPolicies() {
        if (this.workspaceProductPolicies == null) {
            this.workspaceProductPolicies
                = new WorkspaceProductPoliciesImpl(clientObject.getWorkspaceProductPolicies(), this);
        }
        return workspaceProductPolicies;
    }

    /**
     * Gets the resource collection API of WorkspaceTags.
     * 
     * @return Resource collection API of WorkspaceTags.
     */
    public WorkspaceTags workspaceTags() {
        if (this.workspaceTags == null) {
            this.workspaceTags = new WorkspaceTagsImpl(clientObject.getWorkspaceTags(), this);
        }
        return workspaceTags;
    }

    /**
     * Gets the resource collection API of WorkspaceTagApiLinks.
     * 
     * @return Resource collection API of WorkspaceTagApiLinks.
     */
    public WorkspaceTagApiLinks workspaceTagApiLinks() {
        if (this.workspaceTagApiLinks == null) {
            this.workspaceTagApiLinks = new WorkspaceTagApiLinksImpl(clientObject.getWorkspaceTagApiLinks(), this);
        }
        return workspaceTagApiLinks;
    }

    /**
     * Gets the resource collection API of WorkspaceTagOperationLinks.
     * 
     * @return Resource collection API of WorkspaceTagOperationLinks.
     */
    public WorkspaceTagOperationLinks workspaceTagOperationLinks() {
        if (this.workspaceTagOperationLinks == null) {
            this.workspaceTagOperationLinks
                = new WorkspaceTagOperationLinksImpl(clientObject.getWorkspaceTagOperationLinks(), this);
        }
        return workspaceTagOperationLinks;
    }

    /**
     * Gets the resource collection API of WorkspaceTagProductLinks.
     * 
     * @return Resource collection API of WorkspaceTagProductLinks.
     */
    public WorkspaceTagProductLinks workspaceTagProductLinks() {
        if (this.workspaceTagProductLinks == null) {
            this.workspaceTagProductLinks
                = new WorkspaceTagProductLinksImpl(clientObject.getWorkspaceTagProductLinks(), this);
        }
        return workspaceTagProductLinks;
    }

    /**
     * Gets the resource collection API of WorkspaceApiExports.
     * 
     * @return Resource collection API of WorkspaceApiExports.
     */
    public WorkspaceApiExports workspaceApiExports() {
        if (this.workspaceApiExports == null) {
            this.workspaceApiExports = new WorkspaceApiExportsImpl(clientObject.getWorkspaceApiExports(), this);
        }
        return workspaceApiExports;
    }

    /**
     * Gets the resource collection API of OperationStatus.
     * 
     * @return Resource collection API of OperationStatus.
     */
    public OperationStatus operationStatus() {
        if (this.operationStatus == null) {
            this.operationStatus = new OperationStatusImpl(clientObject.getOperationStatus(), this);
        }
        return operationStatus;
    }

    /**
     * Gets the resource collection API of OperationsResults.
     * 
     * @return Resource collection API of OperationsResults.
     */
    public OperationsResults operationsResults() {
        if (this.operationsResults == null) {
            this.operationsResults = new OperationsResultsImpl(clientObject.getOperationsResults(), this);
        }
        return operationsResults;
    }

    /**
     * Gets wrapped service client ApiManagementClient providing direct access to the underlying auto-generated API
     * implementation, based on Azure REST API.
     * 
     * @return Wrapped service client ApiManagementClient.
     */
    public ApiManagementClient serviceClient() {
        return this.clientObject;
    }
}
