// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayConfigConnectionResourceInner;

/**
 * An instance of this class provides access to all the operations defined in ApiGatewayConfigConnectionsClient.
 */
public interface ApiGatewayConfigConnectionsClient {
    /**
     * List all API Management gateway config connections within a gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiManagementGatewayConfigConnectionResourceInner> listByGateway(String resourceGroupName,
        String gatewayName);

    /**
     * List all API Management gateway config connections within a gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiManagementGatewayConfigConnectionResourceInner> listByGateway(String resourceGroupName,
        String gatewayName, Context context);

    /**
     * Gets an API Management gateway config connection resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway config connection resource description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApiManagementGatewayConfigConnectionResourceInner> getWithResponse(String resourceGroupName,
        String gatewayName, String configConnectionName, Context context);

    /**
     * Gets an API Management gateway config connection resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway config connection resource description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayConfigConnectionResourceInner get(String resourceGroupName, String gatewayName,
        String configConnectionName);

    /**
     * Creates or updates an API Management gateway config connection. This is long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway config connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayConfigConnectionResourceInner>, ApiManagementGatewayConfigConnectionResourceInner>
        beginCreateOrUpdate(String resourceGroupName, String gatewayName, String configConnectionName,
            ApiManagementGatewayConfigConnectionResourceInner parameters);

    /**
     * Creates or updates an API Management gateway config connection. This is long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway config connection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayConfigConnectionResourceInner>, ApiManagementGatewayConfigConnectionResourceInner>
        beginCreateOrUpdate(String resourceGroupName, String gatewayName, String configConnectionName,
            ApiManagementGatewayConfigConnectionResourceInner parameters, Context context);

    /**
     * Creates or updates an API Management gateway config connection. This is long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway config connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayConfigConnectionResourceInner createOrUpdate(String resourceGroupName, String gatewayName,
        String configConnectionName, ApiManagementGatewayConfigConnectionResourceInner parameters);

    /**
     * Creates or updates an API Management gateway config connection. This is long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway config connection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayConfigConnectionResourceInner createOrUpdate(String resourceGroupName, String gatewayName,
        String configConnectionName, ApiManagementGatewayConfigConnectionResourceInner parameters, Context context);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String gatewayName,
        String configConnectionName, String ifMatch);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String gatewayName,
        String configConnectionName, String ifMatch, Context context);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch,
        Context context);
}
