// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayUpdateParameters;

/**
 * An instance of this class provides access to all the operations defined in ApiGatewaysClient.
 */
public interface ApiGatewaysClient {
    /**
     * Creates or updates an API Management gateway. This is long running operation and could take several minutes to
     * complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayResourceInner>, ApiManagementGatewayResourceInner>
        beginCreateOrUpdate(String resourceGroupName, String gatewayName, ApiManagementGatewayResourceInner parameters);

    /**
     * Creates or updates an API Management gateway. This is long running operation and could take several minutes to
     * complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayResourceInner>, ApiManagementGatewayResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String gatewayName, ApiManagementGatewayResourceInner parameters, Context context);

    /**
     * Creates or updates an API Management gateway. This is long running operation and could take several minutes to
     * complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayResourceInner createOrUpdate(String resourceGroupName, String gatewayName,
        ApiManagementGatewayResourceInner parameters);

    /**
     * Creates or updates an API Management gateway. This is long running operation and could take several minutes to
     * complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayResourceInner createOrUpdate(String resourceGroupName, String gatewayName,
        ApiManagementGatewayResourceInner parameters, Context context);

    /**
     * Updates an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayResourceInner>, ApiManagementGatewayResourceInner>
        beginUpdate(String resourceGroupName, String gatewayName, ApiManagementGatewayUpdateParameters parameters);

    /**
     * Updates an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayResourceInner>, ApiManagementGatewayResourceInner> beginUpdate(
        String resourceGroupName, String gatewayName, ApiManagementGatewayUpdateParameters parameters, Context context);

    /**
     * Updates an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayResourceInner update(String resourceGroupName, String gatewayName,
        ApiManagementGatewayUpdateParameters parameters);

    /**
     * Updates an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param parameters Parameters supplied to the CreateOrUpdate API Management gateway operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayResourceInner update(String resourceGroupName, String gatewayName,
        ApiManagementGatewayUpdateParameters parameters, Context context);

    /**
     * Gets an API Management gateway resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway resource description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApiManagementGatewayResourceInner> getByResourceGroupWithResponse(String resourceGroupName,
        String gatewayName, Context context);

    /**
     * Gets an API Management gateway resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway resource description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayResourceInner getByResourceGroup(String resourceGroupName, String gatewayName);

    /**
     * Deletes an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayResourceInner>, ApiManagementGatewayResourceInner>
        beginDelete(String resourceGroupName, String gatewayName);

    /**
     * Deletes an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiManagementGatewayResourceInner>, ApiManagementGatewayResourceInner>
        beginDelete(String resourceGroupName, String gatewayName, Context context);

    /**
     * Deletes an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayResourceInner delete(String resourceGroupName, String gatewayName);

    /**
     * Deletes an existing API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management gateway resource in List or Get response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiManagementGatewayResourceInner delete(String resourceGroupName, String gatewayName, Context context);

    /**
     * List all API Management gateways within a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiManagementGatewayResourceInner> listByResourceGroup(String resourceGroupName);

    /**
     * List all API Management gateways within a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiManagementGatewayResourceInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * List all API Management gateways within a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiManagementGatewayResourceInner> list();

    /**
     * List all API Management gateways within a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiManagementGatewayResourceInner> list(Context context);
}
