// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/**
 * The interface for ApiManagementClient class.
 */
public interface ApiManagementClient {
    /**
     * Gets The ID of the target subscription. The value must be an UUID.
     * 
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the ApiGatewaysClient object to access its operations.
     * 
     * @return the ApiGatewaysClient object.
     */
    ApiGatewaysClient getApiGateways();

    /**
     * Gets the ApiManagementGatewaySkusClient object to access its operations.
     * 
     * @return the ApiManagementGatewaySkusClient object.
     */
    ApiManagementGatewaySkusClient getApiManagementGatewaySkus();

    /**
     * Gets the AllPoliciesClient object to access its operations.
     * 
     * @return the AllPoliciesClient object.
     */
    AllPoliciesClient getAllPolicies();

    /**
     * Gets the ApisClient object to access its operations.
     * 
     * @return the ApisClient object.
     */
    ApisClient getApis();

    /**
     * Gets the ApiRevisionsClient object to access its operations.
     * 
     * @return the ApiRevisionsClient object.
     */
    ApiRevisionsClient getApiRevisions();

    /**
     * Gets the ApiReleasesClient object to access its operations.
     * 
     * @return the ApiReleasesClient object.
     */
    ApiReleasesClient getApiReleases();

    /**
     * Gets the ApiOperationsClient object to access its operations.
     * 
     * @return the ApiOperationsClient object.
     */
    ApiOperationsClient getApiOperations();

    /**
     * Gets the ApiOperationPoliciesClient object to access its operations.
     * 
     * @return the ApiOperationPoliciesClient object.
     */
    ApiOperationPoliciesClient getApiOperationPolicies();

    /**
     * Gets the TagsClient object to access its operations.
     * 
     * @return the TagsClient object.
     */
    TagsClient getTags();

    /**
     * Gets the GraphQLApiResolversClient object to access its operations.
     * 
     * @return the GraphQLApiResolversClient object.
     */
    GraphQLApiResolversClient getGraphQLApiResolvers();

    /**
     * Gets the GraphQLApiResolverPoliciesClient object to access its operations.
     * 
     * @return the GraphQLApiResolverPoliciesClient object.
     */
    GraphQLApiResolverPoliciesClient getGraphQLApiResolverPolicies();

    /**
     * Gets the ApiProductsClient object to access its operations.
     * 
     * @return the ApiProductsClient object.
     */
    ApiProductsClient getApiProducts();

    /**
     * Gets the ApiPoliciesClient object to access its operations.
     * 
     * @return the ApiPoliciesClient object.
     */
    ApiPoliciesClient getApiPolicies();

    /**
     * Gets the ApiSchemasClient object to access its operations.
     * 
     * @return the ApiSchemasClient object.
     */
    ApiSchemasClient getApiSchemas();

    /**
     * Gets the ApiDiagnosticsClient object to access its operations.
     * 
     * @return the ApiDiagnosticsClient object.
     */
    ApiDiagnosticsClient getApiDiagnostics();

    /**
     * Gets the ApiIssuesClient object to access its operations.
     * 
     * @return the ApiIssuesClient object.
     */
    ApiIssuesClient getApiIssues();

    /**
     * Gets the ApiIssueCommentsClient object to access its operations.
     * 
     * @return the ApiIssueCommentsClient object.
     */
    ApiIssueCommentsClient getApiIssueComments();

    /**
     * Gets the ApiIssueAttachmentsClient object to access its operations.
     * 
     * @return the ApiIssueAttachmentsClient object.
     */
    ApiIssueAttachmentsClient getApiIssueAttachments();

    /**
     * Gets the ApiTagDescriptionsClient object to access its operations.
     * 
     * @return the ApiTagDescriptionsClient object.
     */
    ApiTagDescriptionsClient getApiTagDescriptions();

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the ApiWikisClient object to access its operations.
     * 
     * @return the ApiWikisClient object.
     */
    ApiWikisClient getApiWikis();

    /**
     * Gets the ApiWikisOperationsClient object to access its operations.
     * 
     * @return the ApiWikisOperationsClient object.
     */
    ApiWikisOperationsClient getApiWikisOperations();

    /**
     * Gets the ApiExportsClient object to access its operations.
     * 
     * @return the ApiExportsClient object.
     */
    ApiExportsClient getApiExports();

    /**
     * Gets the ApiVersionSetsClient object to access its operations.
     * 
     * @return the ApiVersionSetsClient object.
     */
    ApiVersionSetsClient getApiVersionSets();

    /**
     * Gets the AuthorizationProvidersClient object to access its operations.
     * 
     * @return the AuthorizationProvidersClient object.
     */
    AuthorizationProvidersClient getAuthorizationProviders();

    /**
     * Gets the AuthorizationsClient object to access its operations.
     * 
     * @return the AuthorizationsClient object.
     */
    AuthorizationsClient getAuthorizations();

    /**
     * Gets the AuthorizationLoginLinksClient object to access its operations.
     * 
     * @return the AuthorizationLoginLinksClient object.
     */
    AuthorizationLoginLinksClient getAuthorizationLoginLinks();

    /**
     * Gets the AuthorizationAccessPoliciesClient object to access its operations.
     * 
     * @return the AuthorizationAccessPoliciesClient object.
     */
    AuthorizationAccessPoliciesClient getAuthorizationAccessPolicies();

    /**
     * Gets the AuthorizationServersClient object to access its operations.
     * 
     * @return the AuthorizationServersClient object.
     */
    AuthorizationServersClient getAuthorizationServers();

    /**
     * Gets the BackendsClient object to access its operations.
     * 
     * @return the BackendsClient object.
     */
    BackendsClient getBackends();

    /**
     * Gets the CachesClient object to access its operations.
     * 
     * @return the CachesClient object.
     */
    CachesClient getCaches();

    /**
     * Gets the CertificatesClient object to access its operations.
     * 
     * @return the CertificatesClient object.
     */
    CertificatesClient getCertificates();

    /**
     * Gets the ResourceProvidersClient object to access its operations.
     * 
     * @return the ResourceProvidersClient object.
     */
    ResourceProvidersClient getResourceProviders();

    /**
     * Gets the ContentTypesClient object to access its operations.
     * 
     * @return the ContentTypesClient object.
     */
    ContentTypesClient getContentTypes();

    /**
     * Gets the ContentItemsClient object to access its operations.
     * 
     * @return the ContentItemsClient object.
     */
    ContentItemsClient getContentItems();

    /**
     * Gets the DeletedServicesClient object to access its operations.
     * 
     * @return the DeletedServicesClient object.
     */
    DeletedServicesClient getDeletedServices();

    /**
     * Gets the ApiManagementOperationsClient object to access its operations.
     * 
     * @return the ApiManagementOperationsClient object.
     */
    ApiManagementOperationsClient getApiManagementOperations();

    /**
     * Gets the ApiManagementServiceSkusClient object to access its operations.
     * 
     * @return the ApiManagementServiceSkusClient object.
     */
    ApiManagementServiceSkusClient getApiManagementServiceSkus();

    /**
     * Gets the ApiManagementServicesClient object to access its operations.
     * 
     * @return the ApiManagementServicesClient object.
     */
    ApiManagementServicesClient getApiManagementServices();

    /**
     * Gets the DiagnosticsClient object to access its operations.
     * 
     * @return the DiagnosticsClient object.
     */
    DiagnosticsClient getDiagnostics();

    /**
     * Gets the DocumentationsClient object to access its operations.
     * 
     * @return the DocumentationsClient object.
     */
    DocumentationsClient getDocumentations();

    /**
     * Gets the EmailTemplatesClient object to access its operations.
     * 
     * @return the EmailTemplatesClient object.
     */
    EmailTemplatesClient getEmailTemplates();

    /**
     * Gets the ApiGatewayConfigConnectionsClient object to access its operations.
     * 
     * @return the ApiGatewayConfigConnectionsClient object.
     */
    ApiGatewayConfigConnectionsClient getApiGatewayConfigConnections();

    /**
     * Gets the GatewaysClient object to access its operations.
     * 
     * @return the GatewaysClient object.
     */
    GatewaysClient getGateways();

    /**
     * Gets the GatewayHostnameConfigurationsClient object to access its operations.
     * 
     * @return the GatewayHostnameConfigurationsClient object.
     */
    GatewayHostnameConfigurationsClient getGatewayHostnameConfigurations();

    /**
     * Gets the GatewayApisClient object to access its operations.
     * 
     * @return the GatewayApisClient object.
     */
    GatewayApisClient getGatewayApis();

    /**
     * Gets the GatewayCertificateAuthoritiesClient object to access its operations.
     * 
     * @return the GatewayCertificateAuthoritiesClient object.
     */
    GatewayCertificateAuthoritiesClient getGatewayCertificateAuthorities();

    /**
     * Gets the GroupsClient object to access its operations.
     * 
     * @return the GroupsClient object.
     */
    GroupsClient getGroups();

    /**
     * Gets the GroupUsersClient object to access its operations.
     * 
     * @return the GroupUsersClient object.
     */
    GroupUsersClient getGroupUsers();

    /**
     * Gets the IdentityProvidersClient object to access its operations.
     * 
     * @return the IdentityProvidersClient object.
     */
    IdentityProvidersClient getIdentityProviders();

    /**
     * Gets the IssuesClient object to access its operations.
     * 
     * @return the IssuesClient object.
     */
    IssuesClient getIssues();

    /**
     * Gets the LoggersClient object to access its operations.
     * 
     * @return the LoggersClient object.
     */
    LoggersClient getLoggers();

    /**
     * Gets the NamedValuesClient object to access its operations.
     * 
     * @return the NamedValuesClient object.
     */
    NamedValuesClient getNamedValues();

    /**
     * Gets the NetworkStatusClient object to access its operations.
     * 
     * @return the NetworkStatusClient object.
     */
    NetworkStatusClient getNetworkStatus();

    /**
     * Gets the NotificationsClient object to access its operations.
     * 
     * @return the NotificationsClient object.
     */
    NotificationsClient getNotifications();

    /**
     * Gets the NotificationRecipientUsersClient object to access its operations.
     * 
     * @return the NotificationRecipientUsersClient object.
     */
    NotificationRecipientUsersClient getNotificationRecipientUsers();

    /**
     * Gets the NotificationRecipientEmailsClient object to access its operations.
     * 
     * @return the NotificationRecipientEmailsClient object.
     */
    NotificationRecipientEmailsClient getNotificationRecipientEmails();

    /**
     * Gets the OpenIdConnectProvidersClient object to access its operations.
     * 
     * @return the OpenIdConnectProvidersClient object.
     */
    OpenIdConnectProvidersClient getOpenIdConnectProviders();

    /**
     * Gets the OutboundNetworkDependenciesEndpointsClient object to access its operations.
     * 
     * @return the OutboundNetworkDependenciesEndpointsClient object.
     */
    OutboundNetworkDependenciesEndpointsClient getOutboundNetworkDependenciesEndpoints();

    /**
     * Gets the PoliciesClient object to access its operations.
     * 
     * @return the PoliciesClient object.
     */
    PoliciesClient getPolicies();

    /**
     * Gets the PolicyDescriptionsClient object to access its operations.
     * 
     * @return the PolicyDescriptionsClient object.
     */
    PolicyDescriptionsClient getPolicyDescriptions();

    /**
     * Gets the PolicyFragmentsClient object to access its operations.
     * 
     * @return the PolicyFragmentsClient object.
     */
    PolicyFragmentsClient getPolicyFragments();

    /**
     * Gets the PolicyRestrictionsClient object to access its operations.
     * 
     * @return the PolicyRestrictionsClient object.
     */
    PolicyRestrictionsClient getPolicyRestrictions();

    /**
     * Gets the PolicyRestrictionValidationsClient object to access its operations.
     * 
     * @return the PolicyRestrictionValidationsClient object.
     */
    PolicyRestrictionValidationsClient getPolicyRestrictionValidations();

    /**
     * Gets the PortalConfigsClient object to access its operations.
     * 
     * @return the PortalConfigsClient object.
     */
    PortalConfigsClient getPortalConfigs();

    /**
     * Gets the PortalRevisionsClient object to access its operations.
     * 
     * @return the PortalRevisionsClient object.
     */
    PortalRevisionsClient getPortalRevisions();

    /**
     * Gets the PortalSettingsClient object to access its operations.
     * 
     * @return the PortalSettingsClient object.
     */
    PortalSettingsClient getPortalSettings();

    /**
     * Gets the SignInSettingsClient object to access its operations.
     * 
     * @return the SignInSettingsClient object.
     */
    SignInSettingsClient getSignInSettings();

    /**
     * Gets the SignUpSettingsClient object to access its operations.
     * 
     * @return the SignUpSettingsClient object.
     */
    SignUpSettingsClient getSignUpSettings();

    /**
     * Gets the DelegationSettingsClient object to access its operations.
     * 
     * @return the DelegationSettingsClient object.
     */
    DelegationSettingsClient getDelegationSettings();

    /**
     * Gets the PrivateEndpointConnectionsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionsClient object.
     */
    PrivateEndpointConnectionsClient getPrivateEndpointConnections();

    /**
     * Gets the ProductsClient object to access its operations.
     * 
     * @return the ProductsClient object.
     */
    ProductsClient getProducts();

    /**
     * Gets the ProductApisClient object to access its operations.
     * 
     * @return the ProductApisClient object.
     */
    ProductApisClient getProductApis();

    /**
     * Gets the ProductGroupsClient object to access its operations.
     * 
     * @return the ProductGroupsClient object.
     */
    ProductGroupsClient getProductGroups();

    /**
     * Gets the ProductSubscriptionsClient object to access its operations.
     * 
     * @return the ProductSubscriptionsClient object.
     */
    ProductSubscriptionsClient getProductSubscriptions();

    /**
     * Gets the ProductPoliciesClient object to access its operations.
     * 
     * @return the ProductPoliciesClient object.
     */
    ProductPoliciesClient getProductPolicies();

    /**
     * Gets the ProductWikisClient object to access its operations.
     * 
     * @return the ProductWikisClient object.
     */
    ProductWikisClient getProductWikis();

    /**
     * Gets the ProductWikisOperationsClient object to access its operations.
     * 
     * @return the ProductWikisOperationsClient object.
     */
    ProductWikisOperationsClient getProductWikisOperations();

    /**
     * Gets the ProductApiLinksClient object to access its operations.
     * 
     * @return the ProductApiLinksClient object.
     */
    ProductApiLinksClient getProductApiLinks();

    /**
     * Gets the ProductGroupLinksClient object to access its operations.
     * 
     * @return the ProductGroupLinksClient object.
     */
    ProductGroupLinksClient getProductGroupLinks();

    /**
     * Gets the QuotaByCounterKeysClient object to access its operations.
     * 
     * @return the QuotaByCounterKeysClient object.
     */
    QuotaByCounterKeysClient getQuotaByCounterKeys();

    /**
     * Gets the QuotaByPeriodKeysClient object to access its operations.
     * 
     * @return the QuotaByPeriodKeysClient object.
     */
    QuotaByPeriodKeysClient getQuotaByPeriodKeys();

    /**
     * Gets the RegionsClient object to access its operations.
     * 
     * @return the RegionsClient object.
     */
    RegionsClient getRegions();

    /**
     * Gets the ReportsClient object to access its operations.
     * 
     * @return the ReportsClient object.
     */
    ReportsClient getReports();

    /**
     * Gets the GlobalSchemasClient object to access its operations.
     * 
     * @return the GlobalSchemasClient object.
     */
    GlobalSchemasClient getGlobalSchemas();

    /**
     * Gets the TenantSettingsClient object to access its operations.
     * 
     * @return the TenantSettingsClient object.
     */
    TenantSettingsClient getTenantSettings();

    /**
     * Gets the ApiManagementSkusClient object to access its operations.
     * 
     * @return the ApiManagementSkusClient object.
     */
    ApiManagementSkusClient getApiManagementSkus();

    /**
     * Gets the SubscriptionsClient object to access its operations.
     * 
     * @return the SubscriptionsClient object.
     */
    SubscriptionsClient getSubscriptions();

    /**
     * Gets the TagResourcesClient object to access its operations.
     * 
     * @return the TagResourcesClient object.
     */
    TagResourcesClient getTagResources();

    /**
     * Gets the TagApiLinksClient object to access its operations.
     * 
     * @return the TagApiLinksClient object.
     */
    TagApiLinksClient getTagApiLinks();

    /**
     * Gets the TagOperationLinksClient object to access its operations.
     * 
     * @return the TagOperationLinksClient object.
     */
    TagOperationLinksClient getTagOperationLinks();

    /**
     * Gets the TagProductLinksClient object to access its operations.
     * 
     * @return the TagProductLinksClient object.
     */
    TagProductLinksClient getTagProductLinks();

    /**
     * Gets the TenantAccessClient object to access its operations.
     * 
     * @return the TenantAccessClient object.
     */
    TenantAccessClient getTenantAccess();

    /**
     * Gets the TenantAccessGitsClient object to access its operations.
     * 
     * @return the TenantAccessGitsClient object.
     */
    TenantAccessGitsClient getTenantAccessGits();

    /**
     * Gets the TenantConfigurationsClient object to access its operations.
     * 
     * @return the TenantConfigurationsClient object.
     */
    TenantConfigurationsClient getTenantConfigurations();

    /**
     * Gets the UsersClient object to access its operations.
     * 
     * @return the UsersClient object.
     */
    UsersClient getUsers();

    /**
     * Gets the UserGroupsClient object to access its operations.
     * 
     * @return the UserGroupsClient object.
     */
    UserGroupsClient getUserGroups();

    /**
     * Gets the UserSubscriptionsClient object to access its operations.
     * 
     * @return the UserSubscriptionsClient object.
     */
    UserSubscriptionsClient getUserSubscriptions();

    /**
     * Gets the UserIdentitiesClient object to access its operations.
     * 
     * @return the UserIdentitiesClient object.
     */
    UserIdentitiesClient getUserIdentities();

    /**
     * Gets the UserConfirmationPasswordsClient object to access its operations.
     * 
     * @return the UserConfirmationPasswordsClient object.
     */
    UserConfirmationPasswordsClient getUserConfirmationPasswords();

    /**
     * Gets the WorkspaceBackendsClient object to access its operations.
     * 
     * @return the WorkspaceBackendsClient object.
     */
    WorkspaceBackendsClient getWorkspaceBackends();

    /**
     * Gets the WorkspaceCertificatesClient object to access its operations.
     * 
     * @return the WorkspaceCertificatesClient object.
     */
    WorkspaceCertificatesClient getWorkspaceCertificates();

    /**
     * Gets the WorkspaceDiagnosticsClient object to access its operations.
     * 
     * @return the WorkspaceDiagnosticsClient object.
     */
    WorkspaceDiagnosticsClient getWorkspaceDiagnostics();

    /**
     * Gets the WorkspaceApiDiagnosticsClient object to access its operations.
     * 
     * @return the WorkspaceApiDiagnosticsClient object.
     */
    WorkspaceApiDiagnosticsClient getWorkspaceApiDiagnostics();

    /**
     * Gets the ApiManagementWorkspaceLinksClient object to access its operations.
     * 
     * @return the ApiManagementWorkspaceLinksClient object.
     */
    ApiManagementWorkspaceLinksClient getApiManagementWorkspaceLinks();

    /**
     * Gets the ApiManagementWorkspaceLinkOperationsClient object to access its operations.
     * 
     * @return the ApiManagementWorkspaceLinkOperationsClient object.
     */
    ApiManagementWorkspaceLinkOperationsClient getApiManagementWorkspaceLinkOperations();

    /**
     * Gets the WorkspaceLoggersClient object to access its operations.
     * 
     * @return the WorkspaceLoggersClient object.
     */
    WorkspaceLoggersClient getWorkspaceLoggers();

    /**
     * Gets the WorkspacesClient object to access its operations.
     * 
     * @return the WorkspacesClient object.
     */
    WorkspacesClient getWorkspaces();

    /**
     * Gets the WorkspacePoliciesClient object to access its operations.
     * 
     * @return the WorkspacePoliciesClient object.
     */
    WorkspacePoliciesClient getWorkspacePolicies();

    /**
     * Gets the WorkspaceNamedValuesClient object to access its operations.
     * 
     * @return the WorkspaceNamedValuesClient object.
     */
    WorkspaceNamedValuesClient getWorkspaceNamedValues();

    /**
     * Gets the WorkspaceGlobalSchemasClient object to access its operations.
     * 
     * @return the WorkspaceGlobalSchemasClient object.
     */
    WorkspaceGlobalSchemasClient getWorkspaceGlobalSchemas();

    /**
     * Gets the WorkspaceNotificationsClient object to access its operations.
     * 
     * @return the WorkspaceNotificationsClient object.
     */
    WorkspaceNotificationsClient getWorkspaceNotifications();

    /**
     * Gets the WorkspaceNotificationRecipientUsersClient object to access its operations.
     * 
     * @return the WorkspaceNotificationRecipientUsersClient object.
     */
    WorkspaceNotificationRecipientUsersClient getWorkspaceNotificationRecipientUsers();

    /**
     * Gets the WorkspaceNotificationRecipientEmailsClient object to access its operations.
     * 
     * @return the WorkspaceNotificationRecipientEmailsClient object.
     */
    WorkspaceNotificationRecipientEmailsClient getWorkspaceNotificationRecipientEmails();

    /**
     * Gets the WorkspacePolicyFragmentsClient object to access its operations.
     * 
     * @return the WorkspacePolicyFragmentsClient object.
     */
    WorkspacePolicyFragmentsClient getWorkspacePolicyFragments();

    /**
     * Gets the WorkspaceGroupsClient object to access its operations.
     * 
     * @return the WorkspaceGroupsClient object.
     */
    WorkspaceGroupsClient getWorkspaceGroups();

    /**
     * Gets the WorkspaceGroupUsersClient object to access its operations.
     * 
     * @return the WorkspaceGroupUsersClient object.
     */
    WorkspaceGroupUsersClient getWorkspaceGroupUsers();

    /**
     * Gets the WorkspaceSubscriptionsClient object to access its operations.
     * 
     * @return the WorkspaceSubscriptionsClient object.
     */
    WorkspaceSubscriptionsClient getWorkspaceSubscriptions();

    /**
     * Gets the WorkspaceApiVersionSetsClient object to access its operations.
     * 
     * @return the WorkspaceApiVersionSetsClient object.
     */
    WorkspaceApiVersionSetsClient getWorkspaceApiVersionSets();

    /**
     * Gets the WorkspaceApisClient object to access its operations.
     * 
     * @return the WorkspaceApisClient object.
     */
    WorkspaceApisClient getWorkspaceApis();

    /**
     * Gets the WorkspaceApiRevisionsClient object to access its operations.
     * 
     * @return the WorkspaceApiRevisionsClient object.
     */
    WorkspaceApiRevisionsClient getWorkspaceApiRevisions();

    /**
     * Gets the WorkspaceApiReleasesClient object to access its operations.
     * 
     * @return the WorkspaceApiReleasesClient object.
     */
    WorkspaceApiReleasesClient getWorkspaceApiReleases();

    /**
     * Gets the WorkspaceApiOperationsClient object to access its operations.
     * 
     * @return the WorkspaceApiOperationsClient object.
     */
    WorkspaceApiOperationsClient getWorkspaceApiOperations();

    /**
     * Gets the WorkspaceApiOperationPoliciesClient object to access its operations.
     * 
     * @return the WorkspaceApiOperationPoliciesClient object.
     */
    WorkspaceApiOperationPoliciesClient getWorkspaceApiOperationPolicies();

    /**
     * Gets the WorkspaceApiPoliciesClient object to access its operations.
     * 
     * @return the WorkspaceApiPoliciesClient object.
     */
    WorkspaceApiPoliciesClient getWorkspaceApiPolicies();

    /**
     * Gets the WorkspaceApiSchemasClient object to access its operations.
     * 
     * @return the WorkspaceApiSchemasClient object.
     */
    WorkspaceApiSchemasClient getWorkspaceApiSchemas();

    /**
     * Gets the WorkspaceProductsClient object to access its operations.
     * 
     * @return the WorkspaceProductsClient object.
     */
    WorkspaceProductsClient getWorkspaceProducts();

    /**
     * Gets the WorkspaceProductApiLinksClient object to access its operations.
     * 
     * @return the WorkspaceProductApiLinksClient object.
     */
    WorkspaceProductApiLinksClient getWorkspaceProductApiLinks();

    /**
     * Gets the WorkspaceProductGroupLinksClient object to access its operations.
     * 
     * @return the WorkspaceProductGroupLinksClient object.
     */
    WorkspaceProductGroupLinksClient getWorkspaceProductGroupLinks();

    /**
     * Gets the WorkspaceProductPoliciesClient object to access its operations.
     * 
     * @return the WorkspaceProductPoliciesClient object.
     */
    WorkspaceProductPoliciesClient getWorkspaceProductPolicies();

    /**
     * Gets the WorkspaceTagsClient object to access its operations.
     * 
     * @return the WorkspaceTagsClient object.
     */
    WorkspaceTagsClient getWorkspaceTags();

    /**
     * Gets the WorkspaceTagApiLinksClient object to access its operations.
     * 
     * @return the WorkspaceTagApiLinksClient object.
     */
    WorkspaceTagApiLinksClient getWorkspaceTagApiLinks();

    /**
     * Gets the WorkspaceTagOperationLinksClient object to access its operations.
     * 
     * @return the WorkspaceTagOperationLinksClient object.
     */
    WorkspaceTagOperationLinksClient getWorkspaceTagOperationLinks();

    /**
     * Gets the WorkspaceTagProductLinksClient object to access its operations.
     * 
     * @return the WorkspaceTagProductLinksClient object.
     */
    WorkspaceTagProductLinksClient getWorkspaceTagProductLinks();

    /**
     * Gets the WorkspaceApiExportsClient object to access its operations.
     * 
     * @return the WorkspaceApiExportsClient object.
     */
    WorkspaceApiExportsClient getWorkspaceApiExports();

    /**
     * Gets the OperationStatusClient object to access its operations.
     * 
     * @return the OperationStatusClient object.
     */
    OperationStatusClient getOperationStatus();

    /**
     * Gets the OperationsResultsClient object to access its operations.
     * 
     * @return the OperationsResultsClient object.
     */
    OperationsResultsClient getOperationsResults();
}
