// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationLoginResponseContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginLinksPostResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginRequestContract;

/**
 * An instance of this class provides access to all the operations defined in AuthorizationLoginLinksClient.
 */
public interface AuthorizationLoginLinksClient {
    /**
     * Gets authorization login links.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param parameters Create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization login links.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AuthorizationLoginLinksPostResponse postWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters,
        Context context);

    /**
     * Gets authorization login links.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization login links.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AuthorizationLoginResponseContractInner post(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters);
}
