// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationConfirmConsentCodeRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsConfirmConsentCodeResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsGetResponse;

/**
 * An instance of this class provides access to all the operations defined in AuthorizationsClient.
 */
public interface AuthorizationsClient {
    /**
     * Lists a collection of authorization providers defined within a authorization provider.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AuthorizationContractInner> listByAuthorizationProvider(String resourceGroupName, String serviceName,
        String authorizationProviderId);

    /**
     * Lists a collection of authorization providers defined within a authorization provider.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne,
     * gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt
     * | substringof, contains, startswith, endswith |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AuthorizationContractInner> listByAuthorizationProvider(String resourceGroupName, String serviceName,
        String authorizationProviderId, String filter, Integer top, Integer skip, Context context);

    /**
     * Gets the details of the authorization specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the authorization specified by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AuthorizationsGetResponse getWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, Context context);

    /**
     * Gets the details of the authorization specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the authorization specified by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AuthorizationContractInner get(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId);

    /**
     * Creates or updates authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param parameters Create parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AuthorizationsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, AuthorizationContractInner parameters, String ifMatch,
        Context context);

    /**
     * Creates or updates authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AuthorizationContractInner createOrUpdate(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, AuthorizationContractInner parameters);

    /**
     * Deletes specific Authorization from the Authorization provider.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId, String ifMatch, Context context);

    /**
     * Deletes specific Authorization from the Authorization provider.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId,
        String ifMatch);

    /**
     * Confirm valid consent code to suppress Authorizations anti-phishing page.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param parameters Create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AuthorizationsConfirmConsentCodeResponse confirmConsentCodeWithResponse(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId,
        AuthorizationConfirmConsentCodeRequestContract parameters, Context context);

    /**
     * Confirm valid consent code to suppress Authorizations anti-phishing page.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void confirmConsentCode(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId, AuthorizationConfirmConsentCodeRequestContract parameters);
}
