// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentItemContractInner;
import com.azure.resourcemanager.apimanagement.models.ContentItemsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.ContentItemsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ContentItemsGetResponse;

/**
 * An instance of this class provides access to all the operations defined in ContentItemsClient.
 */
public interface ContentItemsClient {
    /**
     * Lists developer portal's content items specified by the provided content type.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged list of content items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContentItemContractInner> listByService(String resourceGroupName, String serviceName,
        String contentTypeId);

    /**
     * Lists developer portal's content items specified by the provided content type.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged list of content items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContentItemContractInner> listByService(String resourceGroupName, String serviceName,
        String contentTypeId, Context context);

    /**
     * Returns the entity state (ETag) version of the developer portal's content item specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentItemsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String contentTypeId, String contentItemId, Context context);

    /**
     * Returns the entity state (ETag) version of the developer portal's content item specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void getEntityTag(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId);

    /**
     * Returns the developer portal's content item specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return content type contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentItemsGetResponse getWithResponse(String resourceGroupName, String serviceName, String contentTypeId,
        String contentItemId, Context context);

    /**
     * Returns the developer portal's content item specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return content type contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentItemContractInner get(String resourceGroupName, String serviceName, String contentTypeId,
        String contentItemId);

    /**
     * Creates a new developer portal's content item specified by the provided content type.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @param parameters Create or update parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return content type contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentItemsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String contentTypeId, String contentItemId, ContentItemContractInner parameters, String ifMatch,
        Context context);

    /**
     * Creates a new developer portal's content item specified by the provided content type.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @param parameters Create or update parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return content type contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentItemContractInner createOrUpdate(String resourceGroupName, String serviceName, String contentTypeId,
        String contentItemId, ContentItemContractInner parameters);

    /**
     * Removes the specified developer portal's content item.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String contentTypeId,
        String contentItemId, String ifMatch, Context context);

    /**
     * Removes the specified developer portal's content item.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param contentItemId Content item identifier.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId,
        String ifMatch);
}
