// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentTypeContractInner;
import com.azure.resourcemanager.apimanagement.models.ContentTypesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.ContentTypesGetResponse;

/**
 * An instance of this class provides access to all the operations defined in ContentTypesClient.
 */
public interface ContentTypesClient {
    /**
     * Lists the developer portal's content types. Content types describe content items' properties, validation rules,
     * and constraints.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged list of content types as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContentTypeContractInner> listByService(String resourceGroupName, String serviceName);

    /**
     * Lists the developer portal's content types. Content types describe content items' properties, validation rules,
     * and constraints.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged list of content types as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContentTypeContractInner> listByService(String resourceGroupName, String serviceName,
        Context context);

    /**
     * Gets the details of the developer portal's content type. Content types describe content items' properties,
     * validation rules, and constraints.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the developer portal's content type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentTypesGetResponse getWithResponse(String resourceGroupName, String serviceName, String contentTypeId,
        Context context);

    /**
     * Gets the details of the developer portal's content type. Content types describe content items' properties,
     * validation rules, and constraints.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the developer portal's content type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentTypeContractInner get(String resourceGroupName, String serviceName, String contentTypeId);

    /**
     * Creates or updates the developer portal's content type. Content types describe content items' properties,
     * validation rules, and constraints. Custom content types' identifiers need to start with the `c-` prefix. Built-in
     * content types can't be modified.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param parameters Create or update parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return content type contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentTypesCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String contentTypeId, ContentTypeContractInner parameters, String ifMatch, Context context);

    /**
     * Creates or updates the developer portal's content type. Content types describe content items' properties,
     * validation rules, and constraints. Custom content types' identifiers need to start with the `c-` prefix. Built-in
     * content types can't be modified.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param parameters Create or update parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return content type contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContentTypeContractInner createOrUpdate(String resourceGroupName, String serviceName, String contentTypeId,
        ContentTypeContractInner parameters);

    /**
     * Removes the specified developer portal's content type. Content types describe content items' properties,
     * validation rules, and constraints. Built-in content types (with identifiers starting with the `c-` prefix) can't
     * be removed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String contentTypeId,
        String ifMatch, Context context);

    /**
     * Removes the specified developer portal's content type. Content types describe content items' properties,
     * validation rules, and constraints. Built-in content types (with identifiers starting with the `c-` prefix) can't
     * be removed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param contentTypeId Content type identifier.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String contentTypeId, String ifMatch);
}
