// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.DocumentationContractInner;
import com.azure.resourcemanager.apimanagement.models.DocumentationUpdateContract;
import com.azure.resourcemanager.apimanagement.models.DocumentationsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.DocumentationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.DocumentationsGetResponse;
import com.azure.resourcemanager.apimanagement.models.DocumentationsUpdateResponse;

/**
 * An instance of this class provides access to all the operations defined in DocumentationsClient.
 */
public interface DocumentationsClient {
    /**
     * Lists all Documentations of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Documentation list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DocumentationContractInner> listByService(String resourceGroupName, String serviceName);

    /**
     * Lists all Documentations of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | eq | contains
     * |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Documentation list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DocumentationContractInner> listByService(String resourceGroupName, String serviceName, String filter,
        Integer top, Integer skip, Context context);

    /**
     * Gets the entity state (Etag) version of the Documentation by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entity state (Etag) version of the Documentation by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DocumentationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String documentationId, Context context);

    /**
     * Gets the entity state (Etag) version of the Documentation by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void getEntityTag(String resourceGroupName, String serviceName, String documentationId);

    /**
     * Gets the details of the Documentation specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the Documentation specified by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DocumentationsGetResponse getWithResponse(String resourceGroupName, String serviceName, String documentationId,
        Context context);

    /**
     * Gets the details of the Documentation specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the Documentation specified by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DocumentationContractInner get(String resourceGroupName, String serviceName, String documentationId);

    /**
     * Creates a new Documentation or updates an existing one.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param parameters Create parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return markdown documentation details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DocumentationsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String documentationId, DocumentationContractInner parameters, String ifMatch, Context context);

    /**
     * Creates a new Documentation or updates an existing one.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return markdown documentation details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DocumentationContractInner createOrUpdate(String resourceGroupName, String serviceName, String documentationId,
        DocumentationContractInner parameters);

    /**
     * Updates the details of the Documentation for an API specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Documentation Update parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return markdown documentation details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DocumentationsUpdateResponse updateWithResponse(String resourceGroupName, String serviceName,
        String documentationId, String ifMatch, DocumentationUpdateContract parameters, Context context);

    /**
     * Updates the details of the Documentation for an API specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Documentation Update parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return markdown documentation details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DocumentationContractInner update(String resourceGroupName, String serviceName, String documentationId,
        String ifMatch, DocumentationUpdateContract parameters);

    /**
     * Deletes the specified Documentation from an API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String documentationId,
        String ifMatch, Context context);

    /**
     * Deletes the specified Documentation from an API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param documentationId Documentation identifier. Must be unique in the current API Management service instance.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String documentationId, String ifMatch);
}
