// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyRestrictionContractInner;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionUpdateContract;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionsGetResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionsUpdateResponse;

/**
 * An instance of this class provides access to all the operations defined in PolicyRestrictionsClient.
 */
public interface PolicyRestrictionsClient {
    /**
     * Gets all policy restrictions of API Management services.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all policy restrictions of API Management services as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyRestrictionContractInner> listByService(String resourceGroupName, String serviceName);

    /**
     * Gets all policy restrictions of API Management services.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all policy restrictions of API Management services as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyRestrictionContractInner> listByService(String resourceGroupName, String serviceName,
        Context context);

    /**
     * Gets the entity state (Etag) version of the policy restriction in the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entity state (Etag) version of the policy restriction in the Api Management service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyRestrictionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String policyRestrictionId, Context context);

    /**
     * Gets the entity state (Etag) version of the policy restriction in the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void getEntityTag(String resourceGroupName, String serviceName, String policyRestrictionId);

    /**
     * Get the policy restriction of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy restriction of the Api Management service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyRestrictionsGetResponse getWithResponse(String resourceGroupName, String serviceName,
        String policyRestrictionId, Context context);

    /**
     * Get the policy restriction of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy restriction of the Api Management service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyRestrictionContractInner get(String resourceGroupName, String serviceName, String policyRestrictionId);

    /**
     * Creates or updates the policy restriction configuration of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param parameters The policy restriction to apply.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return policy restriction contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyRestrictionsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String policyRestrictionId, PolicyRestrictionContractInner parameters, String ifMatch, Context context);

    /**
     * Creates or updates the policy restriction configuration of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param parameters The policy restriction to apply.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return policy restriction contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyRestrictionContractInner createOrUpdate(String resourceGroupName, String serviceName,
        String policyRestrictionId, PolicyRestrictionContractInner parameters);

    /**
     * Updates the policy restriction configuration of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters The policy restriction to apply.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return policy restriction contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyRestrictionsUpdateResponse updateWithResponse(String resourceGroupName, String serviceName,
        String policyRestrictionId, String ifMatch, PolicyRestrictionUpdateContract parameters, Context context);

    /**
     * Updates the policy restriction configuration of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters The policy restriction to apply.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return policy restriction contract details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyRestrictionContractInner update(String resourceGroupName, String serviceName, String policyRestrictionId,
        String ifMatch, PolicyRestrictionUpdateContract parameters);

    /**
     * Deletes the policy restriction configuration of the Api Management Service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String policyRestrictionId,
        String ifMatch, Context context);

    /**
     * Deletes the policy restriction configuration of the Api Management Service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String policyRestrictionId);
}
