// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.apimanagement.fluent.models.ConnectivityCheckResponseInner;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckRequest;

/**
 * An instance of this class provides access to all the operations defined in ResourceProvidersClient.
 */
public interface ResourceProvidersClient {
    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner>
        beginPerformConnectivityCheckAsync(String resourceGroupName, String serviceName,
            ConnectivityCheckRequest connectivityCheckRequestParams);

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner>
        beginPerformConnectivityCheckAsync(String resourceGroupName, String serviceName,
            ConnectivityCheckRequest connectivityCheckRequestParams, Context context);

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectivityCheckResponseInner performConnectivityCheckAsync(String resourceGroupName, String serviceName,
        ConnectivityCheckRequest connectivityCheckRequestParams);

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectivityCheckResponseInner performConnectivityCheckAsync(String resourceGroupName, String serviceName,
        ConnectivityCheckRequest connectivityCheckRequestParams, Context context);
}
