// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSignupSettingsInner;
import com.azure.resourcemanager.apimanagement.models.SignUpSettingsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.SignUpSettingsGetResponse;

/**
 * An instance of this class provides access to all the operations defined in SignUpSettingsClient.
 */
public interface SignUpSettingsClient {
    /**
     * Gets the entity state (Etag) version of the SignUpSettings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entity state (Etag) version of the SignUpSettings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SignUpSettingsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        Context context);

    /**
     * Gets the entity state (Etag) version of the SignUpSettings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void getEntityTag(String resourceGroupName, String serviceName);

    /**
     * Get Sign Up Settings for the Portal.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sign Up Settings for the Portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SignUpSettingsGetResponse getWithResponse(String resourceGroupName, String serviceName, Context context);

    /**
     * Get Sign Up Settings for the Portal.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sign Up Settings for the Portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PortalSignupSettingsInner get(String resourceGroupName, String serviceName);

    /**
     * Update Sign-Up settings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Update Sign-Up settings.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateWithResponse(String resourceGroupName, String serviceName, String ifMatch,
        PortalSignupSettingsInner parameters, Context context);

    /**
     * Update Sign-Up settings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Update Sign-Up settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void update(String resourceGroupName, String serviceName, String ifMatch, PortalSignupSettingsInner parameters);

    /**
     * Create or Update Sign-Up settings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Create or update parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sign-Up settings for a developer portal along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PortalSignupSettingsInner> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        PortalSignupSettingsInner parameters, String ifMatch, Context context);

    /**
     * Create or Update Sign-Up settings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Create or update parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sign-Up settings for a developer portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PortalSignupSettingsInner createOrUpdate(String resourceGroupName, String serviceName,
        PortalSignupSettingsInner parameters);
}
