// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.SubscriptionContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.SubscriptionKeysContractInner;
import com.azure.resourcemanager.apimanagement.models.AppType;
import com.azure.resourcemanager.apimanagement.models.SubscriptionCreateParameters;
import com.azure.resourcemanager.apimanagement.models.SubscriptionUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsGetResponse;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsListSecretsResponse;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsUpdateResponse;

/**
 * An instance of this class provides access to all the operations defined in SubscriptionsClient.
 */
public interface SubscriptionsClient {
    /**
     * Lists all subscriptions of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Subscriptions list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SubscriptionContractInner> list(String resourceGroupName, String serviceName);

    /**
     * Lists all subscriptions of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne,
     * gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt
     * | substringof, contains, startswith, endswith |&lt;/br&gt;| stateComment | filter | ge, le, eq, ne, gt, lt |
     * substringof, contains, startswith, endswith |&lt;/br&gt;| ownerId | filter | ge, le, eq, ne, gt, lt |
     * substringof, contains, startswith, endswith |&lt;/br&gt;| scope | filter | ge, le, eq, ne, gt, lt | substringof,
     * contains, startswith, endswith |&lt;/br&gt;| userId | filter | ge, le, eq, ne, gt, lt | substringof, contains,
     * startswith, endswith |&lt;/br&gt;| productId | filter | ge, le, eq, ne, gt, lt | substringof, contains,
     * startswith, endswith |&lt;/br&gt;| state | filter | eq | |&lt;/br&gt;| user | expand | | |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Subscriptions list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SubscriptionContractInner> list(String resourceGroupName, String serviceName, String filter,
        Integer top, Integer skip, Context context);

    /**
     * Gets the entity state (Etag) version of the apimanagement subscription specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entity state (Etag) version of the apimanagement subscription specified by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String sid,
        Context context);

    /**
     * Gets the entity state (Etag) version of the apimanagement subscription specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void getEntityTag(String resourceGroupName, String serviceName, String sid);

    /**
     * Gets the specified Subscription entity.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Subscription entity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionsGetResponse getWithResponse(String resourceGroupName, String serviceName, String sid, Context context);

    /**
     * Gets the specified Subscription entity.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Subscription entity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionContractInner get(String resourceGroupName, String serviceName, String sid);

    /**
     * Creates or updates the subscription of specified user to the specified product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param parameters Create parameters.
     * @param notify Notify change in Subscription State.
     * - If false, do not send any email notification for change of state of subscription
     * - If true, send email notification of change of state of subscription.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param appType Determines the type of application which send the create user request. Default is legacy publisher
     * portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscription details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String sid, SubscriptionCreateParameters parameters, Boolean notify, String ifMatch, AppType appType,
        Context context);

    /**
     * Creates or updates the subscription of specified user to the specified product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscription details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionContractInner createOrUpdate(String resourceGroupName, String serviceName, String sid,
        SubscriptionCreateParameters parameters);

    /**
     * Updates the details of a subscription specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Update parameters.
     * @param notify Notify change in Subscription State.
     * - If false, do not send any email notification for change of state of subscription
     * - If true, send email notification of change of state of subscription.
     * @param appType Determines the type of application which send the create user request. Default is legacy publisher
     * portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscription details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionsUpdateResponse updateWithResponse(String resourceGroupName, String serviceName, String sid,
        String ifMatch, SubscriptionUpdateParameters parameters, Boolean notify, AppType appType, Context context);

    /**
     * Updates the details of a subscription specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Update parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscription details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionContractInner update(String resourceGroupName, String serviceName, String sid, String ifMatch,
        SubscriptionUpdateParameters parameters);

    /**
     * Deletes the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String sid, String ifMatch,
        Context context);

    /**
     * Deletes the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String sid, String ifMatch);

    /**
     * Regenerates primary key of existing subscription of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> regeneratePrimaryKeyWithResponse(String resourceGroupName, String serviceName, String sid,
        Context context);

    /**
     * Regenerates primary key of existing subscription of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void regeneratePrimaryKey(String resourceGroupName, String serviceName, String sid);

    /**
     * Regenerates secondary key of existing subscription of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> regenerateSecondaryKeyWithResponse(String resourceGroupName, String serviceName, String sid,
        Context context);

    /**
     * Regenerates secondary key of existing subscription of the API Management service instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void regenerateSecondaryKey(String resourceGroupName, String serviceName, String sid);

    /**
     * Gets the specified Subscription keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Subscription keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionsListSecretsResponse listSecretsWithResponse(String resourceGroupName, String serviceName, String sid,
        Context context);

    /**
     * Gets the specified Subscription keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param sid Subscription entity Identifier. The entity represents the association between a user and a product in
     * API Management.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Subscription keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SubscriptionKeysContractInner listSecrets(String resourceGroupName, String serviceName, String sid);
}
