// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AccessInformationContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.AccessInformationSecretsContractInner;
import com.azure.resourcemanager.apimanagement.models.AccessIdName;
import com.azure.resourcemanager.apimanagement.models.AccessInformationCreateParameters;
import com.azure.resourcemanager.apimanagement.models.AccessInformationUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.TenantAccessCreateResponse;
import com.azure.resourcemanager.apimanagement.models.TenantAccessGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.TenantAccessGetResponse;
import com.azure.resourcemanager.apimanagement.models.TenantAccessListSecretsResponse;
import com.azure.resourcemanager.apimanagement.models.TenantAccessUpdateResponse;

/**
 * An instance of this class provides access to all the operations defined in TenantAccessClient.
 */
public interface TenantAccessClient {
    /**
     * Returns list of access infos - for Git and Management endpoints.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged AccessInformation list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AccessInformationContractInner> listByService(String resourceGroupName, String serviceName);

    /**
     * Returns list of access infos - for Git and Management endpoints.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter Not used.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged AccessInformation list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AccessInformationContractInner> listByService(String resourceGroupName, String serviceName,
        String filter, Context context);

    /**
     * Tenant access metadata.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TenantAccessGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        AccessIdName accessName, Context context);

    /**
     * Tenant access metadata.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void getEntityTag(String resourceGroupName, String serviceName, AccessIdName accessName);

    /**
     * Get tenant access information details without secrets.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant access information details without secrets.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TenantAccessGetResponse getWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName,
        Context context);

    /**
     * Get tenant access information details without secrets.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant access information details without secrets.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AccessInformationContractInner get(String resourceGroupName, String serviceName, AccessIdName accessName);

    /**
     * Update tenant access information details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Parameters supplied to retrieve the Tenant Access Information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant Settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TenantAccessCreateResponse createWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName,
        String ifMatch, AccessInformationCreateParameters parameters, Context context);

    /**
     * Update tenant access information details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Parameters supplied to retrieve the Tenant Access Information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant Settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AccessInformationContractInner create(String resourceGroupName, String serviceName, AccessIdName accessName,
        String ifMatch, AccessInformationCreateParameters parameters);

    /**
     * Update tenant access information details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Parameters supplied to retrieve the Tenant Access Information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant Settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TenantAccessUpdateResponse updateWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName,
        String ifMatch, AccessInformationUpdateParameters parameters, Context context);

    /**
     * Update tenant access information details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param parameters Parameters supplied to retrieve the Tenant Access Information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant Settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AccessInformationContractInner update(String resourceGroupName, String serviceName, AccessIdName accessName,
        String ifMatch, AccessInformationUpdateParameters parameters);

    /**
     * Regenerate primary access key.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> regeneratePrimaryKeyWithResponse(String resourceGroupName, String serviceName,
        AccessIdName accessName, Context context);

    /**
     * Regenerate primary access key.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void regeneratePrimaryKey(String resourceGroupName, String serviceName, AccessIdName accessName);

    /**
     * Regenerate secondary access key.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> regenerateSecondaryKeyWithResponse(String resourceGroupName, String serviceName,
        AccessIdName accessName, Context context);

    /**
     * Regenerate secondary access key.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void regenerateSecondaryKey(String resourceGroupName, String serviceName, AccessIdName accessName);

    /**
     * Get tenant access information details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant access information details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TenantAccessListSecretsResponse listSecretsWithResponse(String resourceGroupName, String serviceName,
        AccessIdName accessName, Context context);

    /**
     * Get tenant access information details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param accessName The identifier of the Access configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tenant access information details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AccessInformationSecretsContractInner listSecrets(String resourceGroupName, String serviceName,
        AccessIdName accessName);
}
