// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tenant Settings.
 */
@Fluent
public final class AccessInformationContractInner extends ProxyResource {
    /*
     * AccessInformation entity contract properties.
     */
    private AccessInformationContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AccessInformationContractInner class.
     */
    public AccessInformationContractInner() {
    }

    /**
     * Get the innerProperties property: AccessInformation entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private AccessInformationContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the id property: Access Information type ('access' or 'gitAccess').
     * 
     * @return the id value.
     */
    public String idPropertiesId() {
        return this.innerProperties() == null ? null : this.innerProperties().id();
    }

    /**
     * Set the id property: Access Information type ('access' or 'gitAccess').
     * 
     * @param id the id value to set.
     * @return the AccessInformationContractInner object itself.
     */
    public AccessInformationContractInner withIdPropertiesId(String id) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccessInformationContractProperties();
        }
        this.innerProperties().withId(id);
        return this;
    }

    /**
     * Get the principalId property: Principal (User) Identifier.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: Principal (User) Identifier.
     * 
     * @param principalId the principalId value to set.
     * @return the AccessInformationContractInner object itself.
     */
    public AccessInformationContractInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccessInformationContractProperties();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Get the enabled property: Determines whether direct access is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Determines whether direct access is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the AccessInformationContractInner object itself.
     */
    public AccessInformationContractInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccessInformationContractProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessInformationContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessInformationContractInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AccessInformationContractInner.
     */
    public static AccessInformationContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessInformationContractInner deserializedAccessInformationContractInner
                = new AccessInformationContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAccessInformationContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAccessInformationContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAccessInformationContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAccessInformationContractInner.innerProperties
                        = AccessInformationContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessInformationContractInner;
        });
    }
}
