// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tenant access information update parameters of the API Management service.
 */
@Fluent
public final class AccessInformationCreateParameterProperties
    implements JsonSerializable<AccessInformationCreateParameterProperties> {
    /*
     * Principal (User) Identifier.
     */
    private String principalId;

    /*
     * Primary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
     * the value.
     */
    private String primaryKey;

    /*
     * Secondary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to
     * get the value.
     */
    private String secondaryKey;

    /*
     * Determines whether direct access is enabled.
     */
    private Boolean enabled;

    /**
     * Creates an instance of AccessInformationCreateParameterProperties class.
     */
    public AccessInformationCreateParameterProperties() {
    }

    /**
     * Get the principalId property: Principal (User) Identifier.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: Principal (User) Identifier.
     * 
     * @param principalId the principalId value to set.
     * @return the AccessInformationCreateParameterProperties object itself.
     */
    public AccessInformationCreateParameterProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the primaryKey property: Primary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey property: Primary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @param primaryKey the primaryKey value to set.
     * @return the AccessInformationCreateParameterProperties object itself.
     */
    public AccessInformationCreateParameterProperties withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey property: Secondary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey property: Secondary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @param secondaryKey the secondaryKey value to set.
     * @return the AccessInformationCreateParameterProperties object itself.
     */
    public AccessInformationCreateParameterProperties withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    /**
     * Get the enabled property: Determines whether direct access is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Determines whether direct access is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the AccessInformationCreateParameterProperties object itself.
     */
    public AccessInformationCreateParameterProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessInformationCreateParameterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessInformationCreateParameterProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessInformationCreateParameterProperties.
     */
    public static AccessInformationCreateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessInformationCreateParameterProperties deserializedAccessInformationCreateParameterProperties
                = new AccessInformationCreateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedAccessInformationCreateParameterProperties.principalId = reader.getString();
                } else if ("primaryKey".equals(fieldName)) {
                    deserializedAccessInformationCreateParameterProperties.primaryKey = reader.getString();
                } else if ("secondaryKey".equals(fieldName)) {
                    deserializedAccessInformationCreateParameterProperties.secondaryKey = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedAccessInformationCreateParameterProperties.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessInformationCreateParameterProperties;
        });
    }
}
