// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tenant access information contract of the API Management service.
 */
@Fluent
public final class AccessInformationSecretsContractInner
    implements JsonSerializable<AccessInformationSecretsContractInner> {
    /*
     * Access Information type ('access' or 'gitAccess')
     */
    private String id;

    /*
     * Principal (User) Identifier.
     */
    private String principalId;

    /*
     * Primary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
     * the value.
     */
    private String primaryKey;

    /*
     * Secondary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to
     * get the value.
     */
    private String secondaryKey;

    /*
     * Determines whether direct access is enabled.
     */
    private Boolean enabled;

    /**
     * Creates an instance of AccessInformationSecretsContractInner class.
     */
    public AccessInformationSecretsContractInner() {
    }

    /**
     * Get the id property: Access Information type ('access' or 'gitAccess').
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Access Information type ('access' or 'gitAccess').
     * 
     * @param id the id value to set.
     * @return the AccessInformationSecretsContractInner object itself.
     */
    public AccessInformationSecretsContractInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the principalId property: Principal (User) Identifier.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: Principal (User) Identifier.
     * 
     * @param principalId the principalId value to set.
     * @return the AccessInformationSecretsContractInner object itself.
     */
    public AccessInformationSecretsContractInner withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the primaryKey property: Primary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey property: Primary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @param primaryKey the primaryKey value to set.
     * @return the AccessInformationSecretsContractInner object itself.
     */
    public AccessInformationSecretsContractInner withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey property: Secondary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey property: Secondary access key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @param secondaryKey the secondaryKey value to set.
     * @return the AccessInformationSecretsContractInner object itself.
     */
    public AccessInformationSecretsContractInner withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    /**
     * Get the enabled property: Determines whether direct access is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Determines whether direct access is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the AccessInformationSecretsContractInner object itself.
     */
    public AccessInformationSecretsContractInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessInformationSecretsContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessInformationSecretsContractInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessInformationSecretsContractInner.
     */
    public static AccessInformationSecretsContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessInformationSecretsContractInner deserializedAccessInformationSecretsContractInner
                = new AccessInformationSecretsContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAccessInformationSecretsContractInner.id = reader.getString();
                } else if ("principalId".equals(fieldName)) {
                    deserializedAccessInformationSecretsContractInner.principalId = reader.getString();
                } else if ("primaryKey".equals(fieldName)) {
                    deserializedAccessInformationSecretsContractInner.primaryKey = reader.getString();
                } else if ("secondaryKey".equals(fieldName)) {
                    deserializedAccessInformationSecretsContractInner.secondaryKey = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedAccessInformationSecretsContractInner.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessInformationSecretsContractInner;
        });
    }
}
