// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tenant access information update parameters of the API Management service.
 */
@Fluent
public final class AccessInformationUpdateParameterProperties
    implements JsonSerializable<AccessInformationUpdateParameterProperties> {
    /*
     * Determines whether direct access is enabled.
     */
    private Boolean enabled;

    /**
     * Creates an instance of AccessInformationUpdateParameterProperties class.
     */
    public AccessInformationUpdateParameterProperties() {
    }

    /**
     * Get the enabled property: Determines whether direct access is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Determines whether direct access is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the AccessInformationUpdateParameterProperties object itself.
     */
    public AccessInformationUpdateParameterProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessInformationUpdateParameterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessInformationUpdateParameterProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessInformationUpdateParameterProperties.
     */
    public static AccessInformationUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessInformationUpdateParameterProperties deserializedAccessInformationUpdateParameterProperties
                = new AccessInformationUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedAccessInformationUpdateParameterProperties.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessInformationUpdateParameterProperties;
        });
    }
}
