// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyComplianceState;
import java.io.IOException;

/**
 * AllPolicies Contract details.
 */
@Fluent
public final class AllPoliciesContractInner extends ProxyResource {
    /*
     * Properties of the All Policies.
     */
    private AllPoliciesContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AllPoliciesContractInner class.
     */
    public AllPoliciesContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the All Policies.
     * 
     * @return the innerProperties value.
     */
    private AllPoliciesContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the referencePolicyId property: Policy Identifier.
     * 
     * @return the referencePolicyId value.
     */
    public String referencePolicyId() {
        return this.innerProperties() == null ? null : this.innerProperties().referencePolicyId();
    }

    /**
     * Set the referencePolicyId property: Policy Identifier.
     * 
     * @param referencePolicyId the referencePolicyId value to set.
     * @return the AllPoliciesContractInner object itself.
     */
    public AllPoliciesContractInner withReferencePolicyId(String referencePolicyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AllPoliciesContractProperties();
        }
        this.innerProperties().withReferencePolicyId(referencePolicyId);
        return this;
    }

    /**
     * Get the complianceState property: Policy Restriction Compliance State.
     * 
     * @return the complianceState value.
     */
    public PolicyComplianceState complianceState() {
        return this.innerProperties() == null ? null : this.innerProperties().complianceState();
    }

    /**
     * Set the complianceState property: Policy Restriction Compliance State.
     * 
     * @param complianceState the complianceState value to set.
     * @return the AllPoliciesContractInner object itself.
     */
    public AllPoliciesContractInner withComplianceState(PolicyComplianceState complianceState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AllPoliciesContractProperties();
        }
        this.innerProperties().withComplianceState(complianceState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AllPoliciesContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AllPoliciesContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AllPoliciesContractInner.
     */
    public static AllPoliciesContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AllPoliciesContractInner deserializedAllPoliciesContractInner = new AllPoliciesContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAllPoliciesContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAllPoliciesContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAllPoliciesContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAllPoliciesContractInner.innerProperties
                        = AllPoliciesContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAllPoliciesContractInner;
        });
    }
}
